/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.GenericDeleteFile;
import org.apache.iceberg.GenericManifestEntry;
import org.apache.iceberg.InheritableMetadata;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;

public class ManifestReader<F extends ContentFile<F>>
extends CloseableGroup
implements CloseableIterable<F> {
    static final ImmutableList<String> ALL_COLUMNS = ImmutableList.of("*");
    static final Set<String> STATS_COLUMNS = Sets.newHashSet("value_counts", "null_value_counts", "lower_bounds", "upper_bounds");
    private final InputFile file;
    private final InheritableMetadata inheritableMetadata;
    private final FileType content;
    private final Map<String, String> metadata;
    private final PartitionSpec spec;
    private final Schema fileSchema;
    private Expression partFilter = Expressions.alwaysTrue();
    private Expression rowFilter = Expressions.alwaysTrue();
    private Schema fileProjection = null;
    private Collection<String> columns = null;
    private boolean caseSensitive = true;
    private Evaluator lazyEvaluator = null;
    private InclusiveMetricsEvaluator lazyMetricsEvaluator = null;

    protected ManifestReader(InputFile file, Map<Integer, PartitionSpec> specsById, InheritableMetadata inheritableMetadata, FileType content) {
        this.file = file;
        this.inheritableMetadata = inheritableMetadata;
        this.content = content;
        try (AvroIterable headerReader = Avro.read(file).project(ManifestEntry.getSchema(Types.StructType.of(new Types.NestedField[0])).select("status")).build();){
            this.metadata = headerReader.getMetadata();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        int specId = 0;
        String specProperty = this.metadata.get("partition-spec-id");
        if (specProperty != null) {
            specId = Integer.parseInt(specProperty);
        }
        if (specsById != null) {
            this.spec = specsById.get(specId);
        } else {
            Schema schema = SchemaParser.fromJson(this.metadata.get("schema"));
            this.spec = PartitionSpecParser.fromJsonFields(schema, specId, this.metadata.get("partition-spec"));
        }
        this.fileSchema = new Schema(DataFile.getType(this.spec.partitionType()).fields());
    }

    public boolean isDeleteManifestReader() {
        return this.content == FileType.DELETE_FILES;
    }

    public InputFile file() {
        return this.file;
    }

    public Schema schema() {
        return this.fileSchema;
    }

    public PartitionSpec spec() {
        return this.spec;
    }

    public ManifestReader<F> select(Collection<String> newColumns) {
        Preconditions.checkState(this.fileProjection == null, "Cannot select columns using both select(String...) and project(Schema)");
        this.columns = newColumns;
        return this;
    }

    public ManifestReader<F> project(Schema newFileProjection) {
        Preconditions.checkState(this.columns == null, "Cannot select columns using both select(String...) and project(Schema)");
        this.fileProjection = newFileProjection;
        return this;
    }

    public ManifestReader<F> filterPartitions(Expression expr) {
        this.partFilter = Expressions.and(this.partFilter, expr);
        return this;
    }

    public ManifestReader<F> filterRows(Expression expr) {
        this.rowFilter = Expressions.and(this.rowFilter, expr);
        return this;
    }

    public ManifestReader<F> caseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
        return this;
    }

    CloseableIterable<ManifestEntry<F>> entries() {
        if (this.rowFilter != null && this.rowFilter != Expressions.alwaysTrue() || this.partFilter != null && this.partFilter != Expressions.alwaysTrue()) {
            Evaluator evaluator = this.evaluator();
            InclusiveMetricsEvaluator metricsEvaluator = this.metricsEvaluator();
            boolean requireStatsProjection = ManifestReader.requireStatsProjection(this.rowFilter, this.columns);
            Collection<String> projectColumns = requireStatsProjection ? ManifestReader.withStatsColumns(this.columns) : this.columns;
            return CloseableIterable.filter(this.open(ManifestReader.projection(this.fileSchema, this.fileProjection, projectColumns, this.caseSensitive)), entry -> entry != null && evaluator.eval(entry.file().partition()) && metricsEvaluator.eval((ContentFile<?>)entry.file()));
        }
        return this.open(ManifestReader.projection(this.fileSchema, this.fileProjection, this.columns, this.caseSensitive));
    }

    private CloseableIterable<ManifestEntry<F>> open(Schema projection) {
        FileFormat format = FileFormat.fromFileName(this.file.location());
        Preconditions.checkArgument(format != null, "Unable to determine format of manifest: %s", (Object)this.file);
        switch (format) {
            case AVRO: {
                AvroIterable reader = Avro.read(this.file).project(ManifestEntry.wrapFileSchema(projection.asStruct())).rename("manifest_entry", GenericManifestEntry.class.getName()).rename("partition", PartitionData.class.getName()).rename("r102", PartitionData.class.getName()).rename("data_file", this.content.fileClass()).rename("r2", this.content.fileClass()).classLoader(GenericManifestEntry.class.getClassLoader()).reuseContainers().build();
                this.addCloseable(reader);
                return CloseableIterable.transform(reader, this.inheritableMetadata::apply);
            }
        }
        throw new UnsupportedOperationException("Invalid format for manifest file: " + (Object)((Object)format));
    }

    CloseableIterable<ManifestEntry<F>> liveEntries() {
        return CloseableIterable.filter(this.entries(), entry -> entry != null && entry.status() != ManifestEntry.Status.DELETED);
    }

    @Override
    public CloseableIterator<F> iterator() {
        if (ManifestReader.dropStats(this.rowFilter, this.columns)) {
            return CloseableIterable.transform(this.liveEntries(), e -> (ContentFile)e.file().copyWithoutStats()).iterator();
        }
        return CloseableIterable.transform(this.liveEntries(), e -> (ContentFile)e.file().copy()).iterator();
    }

    private static Schema projection(Schema schema, Schema project, Collection<String> columns, boolean caseSensitive) {
        if (columns != null) {
            if (caseSensitive) {
                return schema.select(columns);
            }
            return schema.caseInsensitiveSelect(columns);
        }
        if (project != null) {
            return project;
        }
        return schema;
    }

    private Evaluator evaluator() {
        if (this.lazyEvaluator == null) {
            Expression projected = Projections.inclusive(this.spec, this.caseSensitive).project(this.rowFilter);
            Expression finalPartFilter = Expressions.and(projected, this.partFilter);
            this.lazyEvaluator = finalPartFilter != null ? new Evaluator(this.spec.partitionType(), finalPartFilter, this.caseSensitive) : new Evaluator(this.spec.partitionType(), Expressions.alwaysTrue(), this.caseSensitive);
        }
        return this.lazyEvaluator;
    }

    private InclusiveMetricsEvaluator metricsEvaluator() {
        if (this.lazyMetricsEvaluator == null) {
            this.lazyMetricsEvaluator = this.rowFilter != null ? new InclusiveMetricsEvaluator(this.spec.schema(), this.rowFilter, this.caseSensitive) : new InclusiveMetricsEvaluator(this.spec.schema(), Expressions.alwaysTrue(), this.caseSensitive);
        }
        return this.lazyMetricsEvaluator;
    }

    private static boolean requireStatsProjection(Expression rowFilter, Collection<String> columns) {
        return rowFilter != Expressions.alwaysTrue() && columns != null && !columns.containsAll(ALL_COLUMNS) && !columns.containsAll(STATS_COLUMNS);
    }

    static boolean dropStats(Expression rowFilter, Collection<String> columns) {
        return rowFilter != Expressions.alwaysTrue() && columns != null && !columns.containsAll(ALL_COLUMNS) && Sets.intersection(Sets.newHashSet(columns), STATS_COLUMNS).isEmpty();
    }

    private static Collection<String> withStatsColumns(Collection<String> columns) {
        if (columns.containsAll(ALL_COLUMNS)) {
            return columns;
        }
        ArrayList<String> projectColumns = Lists.newArrayList(columns);
        projectColumns.addAll(STATS_COLUMNS);
        return projectColumns;
    }

    protected static enum FileType {
        DATA_FILES(GenericDataFile.class.getName()),
        DELETE_FILES(GenericDeleteFile.class.getName());

        private final String fileClass;

        private FileType(String fileClass) {
            this.fileClass = fileClass;
        }

        private String fileClass() {
            return this.fileClass;
        }
    }
}

