/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.CommitCallbackTransaction;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Cache;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;

public class CachingCatalog
implements Catalog {
    private final Cache<TableIdentifier, Table> tableCache = Caffeine.newBuilder().softValues().build();
    private final Catalog catalog;
    private final boolean caseSensitive;

    public static Catalog wrap(Catalog catalog) {
        return CachingCatalog.wrap(catalog, true);
    }

    public static Catalog wrap(Catalog catalog, boolean caseSensitive) {
        return new CachingCatalog(catalog, caseSensitive);
    }

    private CachingCatalog(Catalog catalog, boolean caseSensitive) {
        this.catalog = catalog;
        this.caseSensitive = caseSensitive;
    }

    private TableIdentifier canonicalizeIdentifier(TableIdentifier tableIdentifier) {
        if (this.caseSensitive) {
            return tableIdentifier;
        }
        return tableIdentifier.toLowerCase();
    }

    @Override
    public String name() {
        return this.catalog.name();
    }

    @Override
    public List<TableIdentifier> listTables(Namespace namespace) {
        return this.catalog.listTables(namespace);
    }

    @Override
    public Table loadTable(TableIdentifier ident) {
        TableIdentifier canonicalized = this.canonicalizeIdentifier(ident);
        Table cached = this.tableCache.getIfPresent(canonicalized);
        if (cached != null) {
            return cached;
        }
        if (MetadataTableUtils.hasMetadataTableName(canonicalized)) {
            TableIdentifier originTableIdentifier = TableIdentifier.of(canonicalized.namespace().levels());
            Table originTable = this.tableCache.get(originTableIdentifier, this.catalog::loadTable);
            if (originTable instanceof HasTableOperations) {
                TableOperations ops = ((HasTableOperations)((Object)originTable)).operations();
                MetadataTableType type = MetadataTableType.from(canonicalized.name());
                Table metadataTable = MetadataTableUtils.createMetadataTableInstance(ops, this.catalog.name(), originTableIdentifier, canonicalized, type);
                this.tableCache.put(canonicalized, metadataTable);
                return metadataTable;
            }
        }
        return this.tableCache.get(canonicalized, this.catalog::loadTable);
    }

    @Override
    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        AtomicBoolean created = new AtomicBoolean(false);
        Table table = this.tableCache.get(this.canonicalizeIdentifier(ident), identifier -> {
            created.set(true);
            return this.catalog.createTable((TableIdentifier)identifier, schema, spec, location, properties);
        });
        if (!created.get()) {
            throw new AlreadyExistsException("Table already exists: %s", ident);
        }
        return table;
    }

    @Override
    public Transaction newCreateTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        return this.catalog.newCreateTableTransaction(ident, schema, spec, location, properties);
    }

    @Override
    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> properties, boolean orCreate) {
        return CommitCallbackTransaction.addCallback(this.catalog.newReplaceTableTransaction(ident, schema, spec, location, properties, orCreate), () -> this.tableCache.invalidate(this.canonicalizeIdentifier(ident)));
    }

    @Override
    public boolean dropTable(TableIdentifier ident, boolean purge) {
        boolean dropped = this.catalog.dropTable(ident, purge);
        this.tableCache.invalidate(this.canonicalizeIdentifier(ident));
        return dropped;
    }

    @Override
    public void renameTable(TableIdentifier from, TableIdentifier to) {
        this.catalog.renameTable(from, to);
        this.tableCache.invalidate(this.canonicalizeIdentifier(from));
    }
}

