/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class BaseOverwriteFiles
extends MergingSnapshotProducer<OverwriteFiles>
implements OverwriteFiles {
    private boolean validateAddedFilesMatchOverwriteFilter = false;
    private Long startingSnapshotId = null;
    private Expression conflictDetectionFilter = null;
    private boolean caseSensitive = true;

    protected BaseOverwriteFiles(String tableName, TableOperations ops) {
        super(tableName, ops);
    }

    @Override
    protected OverwriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    @Override
    public OverwriteFiles overwriteByRowFilter(Expression expr) {
        this.deleteByRowFilter(expr);
        return this;
    }

    @Override
    public OverwriteFiles addFile(DataFile file) {
        this.add(file);
        return this;
    }

    @Override
    public OverwriteFiles deleteFile(DataFile file) {
        this.delete(file);
        return this;
    }

    @Override
    public OverwriteFiles validateAddedFilesMatchOverwriteFilter() {
        this.validateAddedFilesMatchOverwriteFilter = true;
        return this;
    }

    @Override
    @Deprecated
    public OverwriteFiles validateNoConflictingAppends(Long newReadSnapshotId, Expression newConflictDetectionFilter) {
        if (newReadSnapshotId != null) {
            this.validateFromSnapshot(newReadSnapshotId);
        }
        this.validateNoConflictingAppends(newConflictDetectionFilter);
        return this;
    }

    @Override
    public OverwriteFiles validateFromSnapshot(long snapshotId) {
        this.startingSnapshotId = snapshotId;
        return this;
    }

    @Override
    public OverwriteFiles caseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
        return this;
    }

    @Override
    public OverwriteFiles validateNoConflictingAppends(Expression newConflictDetectionFilter) {
        Preconditions.checkArgument(newConflictDetectionFilter != null, "Conflict detection filter cannot be null");
        this.conflictDetectionFilter = newConflictDetectionFilter;
        this.failMissingDeletePaths();
        return this;
    }

    @Override
    protected void validate(TableMetadata base) {
        if (this.validateAddedFilesMatchOverwriteFilter) {
            PartitionSpec spec = this.writeSpec();
            Expression rowFilter = this.rowFilter();
            Expression inclusiveExpr = Projections.inclusive(spec).project(rowFilter);
            Evaluator inclusive = new Evaluator(spec.partitionType(), inclusiveExpr);
            Expression strictExpr = Projections.strict(spec).project(rowFilter);
            Evaluator strict = new Evaluator(spec.partitionType(), strictExpr);
            StrictMetricsEvaluator metrics = new StrictMetricsEvaluator(base.schema(), rowFilter);
            for (DataFile file : this.addedFiles()) {
                ValidationException.check(inclusive.eval(file.partition()) && (strict.eval(file.partition()) || metrics.eval(file)), "Cannot append file with rows that do not match filter: %s: %s", rowFilter, file.path());
            }
        }
        if (this.conflictDetectionFilter != null && base.currentSnapshot() != null) {
            this.validateAddedDataFiles(base, this.startingSnapshotId, this.conflictDetectionFilter, this.caseSensitive);
        }
    }
}

