/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.shaded.io.netty.buffer;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.iceberg.gcp.shaded.io.netty.buffer.ByteBuf;
import org.apache.iceberg.gcp.shaded.io.netty.buffer.MutableWrappedByteBuf;
import org.apache.iceberg.gcp.shaded.io.netty.buffer.NettyArrowBuf;

public class ExpandableByteBuf
extends MutableWrappedByteBuf {
    private final BufferAllocator allocator;

    public ExpandableByteBuf(ByteBuf buffer, BufferAllocator allocator) {
        super(buffer);
        this.allocator = allocator;
    }

    @Override
    public ByteBuf copy(int index, int length) {
        return new ExpandableByteBuf(this.buffer.copy(index, length), this.allocator);
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        if (newCapacity > this.capacity()) {
            NettyArrowBuf newBuf = NettyArrowBuf.unwrapBuffer(this.allocator.buffer(newCapacity));
            ((ByteBuf)newBuf).writeBytes(this.buffer, 0, this.buffer.capacity());
            ((ByteBuf)newBuf).readerIndex(this.buffer.readerIndex());
            ((ByteBuf)newBuf).writerIndex(this.buffer.writerIndex());
            this.buffer.release();
            this.buffer = newBuf;
            return newBuf;
        }
        return super.capacity(newCapacity);
    }
}

