/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.arrow.vector.util.IntObjectHashMap;
import org.apache.arrow.vector.util.MapWithOrdinal;

public class MapWithOrdinalImpl<K, V>
implements MapWithOrdinal<K, V> {
    private final Map<K, Map.Entry<Integer, V>> primary = new LinkedHashMap<K, Map.Entry<Integer, V>>();
    private final IntObjectHashMap<V> secondary = new IntObjectHashMap();
    private final Map<K, V> delegate = new Map<K, V>(){

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int size() {
            return MapWithOrdinalImpl.this.primary.size();
        }

        @Override
        public boolean containsKey(Object key) {
            return MapWithOrdinalImpl.this.primary.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return MapWithOrdinalImpl.this.primary.containsValue(value);
        }

        @Override
        public V get(Object key) {
            Map.Entry pair = (Map.Entry)MapWithOrdinalImpl.this.primary.get(key);
            if (pair != null) {
                return pair.getValue();
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            Map.Entry oldPair = (Map.Entry)MapWithOrdinalImpl.this.primary.get(key);
            int ordinal = oldPair == null ? MapWithOrdinalImpl.this.primary.size() : ((Integer)oldPair.getKey()).intValue();
            MapWithOrdinalImpl.this.primary.put(key, new AbstractMap.SimpleImmutableEntry(ordinal, value));
            MapWithOrdinalImpl.this.secondary.put(ordinal, value);
            return oldPair == null ? null : (Object)oldPair.getValue();
        }

        @Override
        public V remove(Object key) {
            Map.Entry oldPair = (Map.Entry)MapWithOrdinalImpl.this.primary.remove(key);
            if (oldPair != null) {
                int lastOrdinal = MapWithOrdinalImpl.this.secondary.size();
                Object last = MapWithOrdinalImpl.this.secondary.get(lastOrdinal);
                MapWithOrdinalImpl.this.secondary.put((Integer)oldPair.getKey(), last);
                MapWithOrdinalImpl.this.primary.put(key, new AbstractMap.SimpleImmutableEntry((Integer)oldPair.getKey(), last));
            }
            return oldPair == null ? null : (Object)oldPair.getValue();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m4) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            MapWithOrdinalImpl.this.primary.clear();
            MapWithOrdinalImpl.this.secondary.clear();
        }

        @Override
        public Set<K> keySet() {
            return MapWithOrdinalImpl.this.primary.keySet();
        }

        @Override
        public Collection<V> values() {
            return MapWithOrdinalImpl.this.secondary.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return MapWithOrdinalImpl.this.primary.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), ((Map.Entry)entry.getValue()).getValue())).collect(Collectors.toSet());
        }
    };

    @Override
    public V getByOrdinal(int id) {
        return this.secondary.get(id);
    }

    @Override
    public int getOrdinal(K key) {
        Map.Entry<Integer, V> pair = this.primary.get(key);
        if (pair != null) {
            return pair.getKey();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Collection<V> getAll(K key) {
        if (this.delegate.containsKey(key)) {
            ArrayList<V> list = new ArrayList<V>(1);
            list.add(this.get(key));
            return list;
        }
        return null;
    }

    @Override
    public V get(K key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean put(K key, V value, boolean overwrite) {
        return this.delegate.put(key, value) != null;
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public boolean remove(K key, V value) {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean removeAll(K key) {
        return this.delegate.remove(key) != null;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keys() {
        return this.delegate.keySet();
    }
}

