/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.complex.impl;

import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import org.apache.arrow.vector.complex.impl.Float4WriterImpl;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.FieldWriter;
import org.apache.arrow.vector.complex.writer.Float4Writer;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Field;

public class Float4ReaderImpl
extends AbstractFieldReader {
    private final Float4Vector vector;

    public Float4ReaderImpl(Float4Vector vector) {
        this.vector = vector;
    }

    @Override
    public Types.MinorType getMinorType() {
        return this.vector.getMinorType();
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.isNull(this.idx());
    }

    @Override
    public void copyAsValue(Float4Writer writer) {
        Float4WriterImpl impl = (Float4WriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.StructWriter writer) {
        Float4WriterImpl impl = (Float4WriterImpl)writer.float4(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(NullableFloat4Holder h2) {
        this.vector.get(this.idx(), h2);
    }

    @Override
    public Float readFloat() {
        return this.vector.getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getObject(this.idx());
    }
}

