/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import io.grpc.alts.internal.RpcProtocolVersions;
import javax.annotation.Nullable;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;

public final class RpcProtocolVersionsUtil {
    private static final int MAX_RPC_VERSION_MAJOR = 2;
    private static final int MAX_RPC_VERSION_MINOR = 1;
    private static final int MIN_RPC_VERSION_MAJOR = 2;
    private static final int MIN_RPC_VERSION_MINOR = 1;
    private static final RpcProtocolVersions RPC_PROTOCOL_VERSIONS = RpcProtocolVersions.newBuilder().setMaxRpcVersion(RpcProtocolVersions.Version.newBuilder().setMajor(2).setMinor(1).build()).setMinRpcVersion(RpcProtocolVersions.Version.newBuilder().setMajor(2).setMinor(1).build()).build();

    public static RpcProtocolVersions getRpcProtocolVersions() {
        return RPC_PROTOCOL_VERSIONS;
    }

    @VisibleForTesting
    static boolean isGreaterThanOrEqualTo(RpcProtocolVersions.Version first, RpcProtocolVersions.Version second) {
        return first.getMajor() > second.getMajor() || first.getMajor() == second.getMajor() && first.getMinor() >= second.getMinor();
    }

    static RpcVersionsCheckResult checkRpcProtocolVersions(RpcProtocolVersions localVersions, RpcProtocolVersions peerVersions) {
        RpcProtocolVersions.Version minCommonVersion;
        RpcProtocolVersions.Version maxCommonVersion = RpcProtocolVersionsUtil.isGreaterThanOrEqualTo(localVersions.getMaxRpcVersion(), peerVersions.getMaxRpcVersion()) ? peerVersions.getMaxRpcVersion() : localVersions.getMaxRpcVersion();
        if (RpcProtocolVersionsUtil.isGreaterThanOrEqualTo(maxCommonVersion, minCommonVersion = RpcProtocolVersionsUtil.isGreaterThanOrEqualTo(localVersions.getMinRpcVersion(), peerVersions.getMinRpcVersion()) ? localVersions.getMinRpcVersion() : peerVersions.getMinRpcVersion())) {
            return new RpcVersionsCheckResult.Builder().setResult(true).setHighestCommonVersion(maxCommonVersion).build();
        }
        return new RpcVersionsCheckResult.Builder().setResult(false).build();
    }

    static final class RpcVersionsCheckResult {
        private final boolean result;
        @Nullable
        private final RpcProtocolVersions.Version highestCommonVersion;

        private RpcVersionsCheckResult(Builder builder) {
            this.result = builder.result;
            this.highestCommonVersion = builder.highestCommonVersion;
        }

        boolean getResult() {
            return this.result;
        }

        RpcProtocolVersions.Version getHighestCommonVersion() {
            return this.highestCommonVersion;
        }

        static final class Builder {
            private boolean result;
            @Nullable
            private RpcProtocolVersions.Version highestCommonVersion = null;

            Builder() {
            }

            public Builder setResult(boolean result) {
                this.result = result;
                return this;
            }

            public Builder setHighestCommonVersion(RpcProtocolVersions.Version highestCommonVersion) {
                this.highestCommonVersion = highestCommonVersion;
                return this;
            }

            public RpcVersionsCheckResult build() {
                return new RpcVersionsCheckResult(this);
            }
        }
    }
}

