/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.cloud.storage.ChannelSession;
import com.google.cloud.storage.DefaultBufferedReadableByteChannel;
import com.google.cloud.storage.GapicUnbufferedReadableByteChannel;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.GzipReadableByteChannel;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.concurrent.Immutable;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.MoreExecutors;

@Immutable
final class GapicDownloadSessionBuilder {
    private static final GapicDownloadSessionBuilder INSTANCE = new GapicDownloadSessionBuilder();
    private static final int DEFAULT_BUFFER_CAPACITY = 0x1000000;

    private GapicDownloadSessionBuilder() {
    }

    public static GapicDownloadSessionBuilder create() {
        return INSTANCE;
    }

    public ReadableByteChannelSessionBuilder byteChannel(GrpcUtils.ZeroCopyServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, Retrying.Retrier retrier, ResultRetryAlgorithm<?> resultRetryAlgorithm) {
        return new ReadableByteChannelSessionBuilder(read, retrier, resultRetryAlgorithm);
    }

    public static final class ReadableByteChannelSessionBuilder {
        private final GrpcUtils.ZeroCopyServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read;
        private final Retrying.Retrier retrier;
        private final ResultRetryAlgorithm<?> resultRetryAlgorithm;
        private boolean autoGzipDecompression;
        private Hasher hasher;

        private ReadableByteChannelSessionBuilder(GrpcUtils.ZeroCopyServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, Retrying.Retrier retrier, ResultRetryAlgorithm<?> resultRetryAlgorithm) {
            this.read = read;
            this.retrier = retrier;
            this.resultRetryAlgorithm = resultRetryAlgorithm;
            this.hasher = Hasher.noop();
            this.autoGzipDecompression = false;
        }

        public BufferedReadableByteChannelSessionBuilder buffered() {
            return this.buffered(BufferHandle.allocate(0x1000000));
        }

        public ReadableByteChannelSessionBuilder setHasher(Hasher hasher) {
            this.hasher = hasher;
            return this;
        }

        public ReadableByteChannelSessionBuilder setAutoGzipDecompression(boolean autoGzipDecompression) {
            this.autoGzipDecompression = autoGzipDecompression;
            return this;
        }

        public BufferedReadableByteChannelSessionBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedReadableByteChannelSessionBuilder(bufferHandle, this.bindFunction());
        }

        public BufferedReadableByteChannelSessionBuilder buffered(ByteBuffer buffer) {
            return this.buffered(BufferHandle.handleOf(buffer));
        }

        public UnbufferedReadableByteChannelSessionBuilder unbuffered() {
            return new UnbufferedReadableByteChannelSessionBuilder(this.bindFunction());
        }

        private BiFunction<ReadObjectRequest, SettableApiFuture<com.google.storage.v2.Object>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> bindFunction() {
            Hasher hasher = this.hasher;
            boolean autoGzipDecompression = this.autoGzipDecompression;
            return (object, resultFuture) -> {
                if (autoGzipDecompression) {
                    return new GzipReadableByteChannel(new GapicUnbufferedReadableByteChannel((SettableApiFuture<com.google.storage.v2.Object>)resultFuture, this.read, (ReadObjectRequest)object, hasher, this.retrier, this.resultRetryAlgorithm), ApiFutures.transform(resultFuture, com.google.storage.v2.Object::getContentEncoding, MoreExecutors.directExecutor()));
                }
                return new GapicUnbufferedReadableByteChannel((SettableApiFuture<com.google.storage.v2.Object>)resultFuture, this.read, (ReadObjectRequest)object, hasher, this.retrier, this.resultRetryAlgorithm);
            };
        }

        public static final class BufferedReadableByteChannelSessionBuilder {
            private final BiFunction<ReadObjectRequest, SettableApiFuture<com.google.storage.v2.Object>, BufferedReadableByteChannelSession.BufferedReadableByteChannel> f;
            private ReadObjectRequest request;

            private BufferedReadableByteChannelSessionBuilder(BufferHandle buffer, BiFunction<ReadObjectRequest, SettableApiFuture<com.google.storage.v2.Object>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f) {
                this.f = f.andThen(c -> new DefaultBufferedReadableByteChannel(buffer, (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel)c));
            }

            public BufferedReadableByteChannelSessionBuilder setReadObjectRequest(ReadObjectRequest request) {
                this.request = Objects.requireNonNull(request, "request must be non null");
                return this;
            }

            public BufferedReadableByteChannelSession<com.google.storage.v2.Object> build() {
                return new ChannelSession.BufferedReadSession<ReadObjectRequest, com.google.storage.v2.Object>(ApiFutures.immediateFuture(this.request), this.f.andThen(StorageByteChannels.readable()::createSynchronized));
            }
        }

        public static final class UnbufferedReadableByteChannelSessionBuilder {
            private final BiFunction<ReadObjectRequest, SettableApiFuture<com.google.storage.v2.Object>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f;
            private ReadObjectRequest request;

            private UnbufferedReadableByteChannelSessionBuilder(BiFunction<ReadObjectRequest, SettableApiFuture<com.google.storage.v2.Object>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f) {
                this.f = f;
            }

            public UnbufferedReadableByteChannelSessionBuilder setReadObjectRequest(ReadObjectRequest request) {
                this.request = Objects.requireNonNull(request, "request must be non null");
                return this;
            }

            public UnbufferedReadableByteChannelSession<com.google.storage.v2.Object> build() {
                return new ChannelSession.UnbufferedReadSession<ReadObjectRequest, com.google.storage.v2.Object>(ApiFutures.immediateFuture(this.request), this.f.andThen(StorageByteChannels.readable()::createSynchronized));
            }
        }
    }
}

