/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.v1.AutokeyClient;
import com.google.cloud.kms.v1.CreateKeyHandleMetadata;
import com.google.cloud.kms.v1.CreateKeyHandleRequest;
import com.google.cloud.kms.v1.GetKeyHandleRequest;
import com.google.cloud.kms.v1.KeyHandle;
import com.google.cloud.kms.v1.ListKeyHandlesRequest;
import com.google.cloud.kms.v1.ListKeyHandlesResponse;
import com.google.cloud.kms.v1.stub.AutokeyStub;
import com.google.cloud.kms.v1.stub.AutokeyStubSettings;
import com.google.cloud.kms.v1.stub.GrpcAutokeyCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAutokeyStub
extends AutokeyStub {
    private static final MethodDescriptor<CreateKeyHandleRequest, Operation> createKeyHandleMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.Autokey/CreateKeyHandle").setRequestMarshaller(ProtoUtils.marshaller(CreateKeyHandleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetKeyHandleRequest, KeyHandle> getKeyHandleMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.Autokey/GetKeyHandle").setRequestMarshaller(ProtoUtils.marshaller(GetKeyHandleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(KeyHandle.getDefaultInstance())).build();
    private static final MethodDescriptor<ListKeyHandlesRequest, ListKeyHandlesResponse> listKeyHandlesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.Autokey/ListKeyHandles").setRequestMarshaller(ProtoUtils.marshaller(ListKeyHandlesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListKeyHandlesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller(ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller(GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller(SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller(GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller(TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateKeyHandleRequest, Operation> createKeyHandleCallable;
    private final OperationCallable<CreateKeyHandleRequest, KeyHandle, CreateKeyHandleMetadata> createKeyHandleOperationCallable;
    private final UnaryCallable<GetKeyHandleRequest, KeyHandle> getKeyHandleCallable;
    private final UnaryCallable<ListKeyHandlesRequest, ListKeyHandlesResponse> listKeyHandlesCallable;
    private final UnaryCallable<ListKeyHandlesRequest, AutokeyClient.ListKeyHandlesPagedResponse> listKeyHandlesPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, AutokeyClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAutokeyStub create(AutokeyStubSettings settings) throws IOException {
        return new GrpcAutokeyStub(settings, ClientContext.create(settings));
    }

    public static final GrpcAutokeyStub create(ClientContext clientContext) throws IOException {
        return new GrpcAutokeyStub(AutokeyStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAutokeyStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAutokeyStub(AutokeyStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAutokeyStub(AutokeyStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAutokeyCallableFactory());
    }

    protected GrpcAutokeyStub(AutokeyStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<CreateKeyHandleRequest, Operation> createKeyHandleTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createKeyHandleMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetKeyHandleRequest, KeyHandle> getKeyHandleTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getKeyHandleMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListKeyHandlesRequest, ListKeyHandlesResponse> listKeyHandlesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listKeyHandlesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListLocationsRequest, ListLocationsResponse> listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetLocationRequest, Location> getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<SetIamPolicyRequest, Policy> setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetIamPolicyRequest, Policy> getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createKeyHandleCallable = callableFactory.createUnaryCallable(createKeyHandleTransportSettings, settings.createKeyHandleSettings(), clientContext);
        this.createKeyHandleOperationCallable = callableFactory.createOperationCallable(createKeyHandleTransportSettings, settings.createKeyHandleOperationSettings(), clientContext, this.operationsStub);
        this.getKeyHandleCallable = callableFactory.createUnaryCallable(getKeyHandleTransportSettings, settings.getKeyHandleSettings(), clientContext);
        this.listKeyHandlesCallable = callableFactory.createUnaryCallable(listKeyHandlesTransportSettings, settings.listKeyHandlesSettings(), clientContext);
        this.listKeyHandlesPagedCallable = callableFactory.createPagedCallable(listKeyHandlesTransportSettings, settings.listKeyHandlesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateKeyHandleRequest, Operation> createKeyHandleCallable() {
        return this.createKeyHandleCallable;
    }

    @Override
    public OperationCallable<CreateKeyHandleRequest, KeyHandle, CreateKeyHandleMetadata> createKeyHandleOperationCallable() {
        return this.createKeyHandleOperationCallable;
    }

    @Override
    public UnaryCallable<GetKeyHandleRequest, KeyHandle> getKeyHandleCallable() {
        return this.getKeyHandleCallable;
    }

    @Override
    public UnaryCallable<ListKeyHandlesRequest, ListKeyHandlesResponse> listKeyHandlesCallable() {
        return this.listKeyHandlesCallable;
    }

    @Override
    public UnaryCallable<ListKeyHandlesRequest, AutokeyClient.ListKeyHandlesPagedResponse> listKeyHandlesPagedCallable() {
        return this.listKeyHandlesPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, AutokeyClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

