/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;

public class AutokeyConfigName
implements ResourceName {
    private static final PathTemplate FOLDER = PathTemplate.createWithoutUrlEncoding("folders/{folder}/autokeyConfig");
    private volatile Map<String, String> fieldValuesMap;
    private final String folder;

    @Deprecated
    protected AutokeyConfigName() {
        this.folder = null;
    }

    private AutokeyConfigName(Builder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AutokeyConfigName of(String folder) {
        return AutokeyConfigName.newBuilder().setFolder(folder).build();
    }

    public static String format(String folder) {
        return AutokeyConfigName.newBuilder().setFolder(folder).build().toString();
    }

    public static AutokeyConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = FOLDER.validatedMatch(formattedString, "AutokeyConfigName.parse: formattedString not in valid format");
        return AutokeyConfigName.of(matchMap.get("folder"));
    }

    public static List<AutokeyConfigName> parseList(List<String> formattedStrings) {
        ArrayList<AutokeyConfigName> list = new ArrayList<AutokeyConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AutokeyConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AutokeyConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AutokeyConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return FOLDER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AutokeyConfigName autokeyConfigName = this;
            synchronized (autokeyConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return FOLDER.instantiate("folder", this.folder);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AutokeyConfigName that = (AutokeyConfigName)o;
            return Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.folder);
    }

    public static class Builder {
        private String folder;

        protected Builder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        private Builder(AutokeyConfigName autokeyConfigName) {
            this.folder = autokeyConfigName.folder;
        }

        public AutokeyConfigName build() {
            return new AutokeyConfigName(this);
        }
    }
}

