/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.StreamingRetryAlgorithm;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageGrpc;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageSettings;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.stub.BigQueryStorageStubSettings;
import com.google.cloud.bigquery.storage.v1beta1.stub.EnhancedBigQueryStorageStubSettings;
import com.google.cloud.bigquery.storage.v1beta1.stub.GrpcBigQueryStorageStub;
import com.google.cloud.bigquery.storage.v1beta1.stub.readrows.ApiResultRetryAlgorithm;
import com.google.cloud.bigquery.storage.v1beta1.stub.readrows.ReadRowsRetryingCallable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Empty;

public class EnhancedBigQueryStorageStub
implements BackgroundResource {
    private static final String TRACING_OUTER_CLIENT_NAME = "BigQueryStorage";
    private final GrpcBigQueryStorageStub stub;
    private final BigQueryStorageStubSettings stubSettings;
    private final BigQueryStorageSettings.RetryAttemptListener readRowsRetryAttemptListener;
    private final ClientContext context;

    public static EnhancedBigQueryStorageStub create(EnhancedBigQueryStorageStubSettings settings) throws IOException {
        return EnhancedBigQueryStorageStub.create(settings, null);
    }

    public static EnhancedBigQueryStorageStub create(EnhancedBigQueryStorageStubSettings settings, BigQueryStorageSettings.RetryAttemptListener readRowsRetryAttemptListener) throws IOException {
        BigQueryStorageStubSettings.Builder baseSettingsBuilder = (BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)BigQueryStorageStubSettings.newBuilder().setUniverseDomain(settings.getUniverseDomain())).setTransportChannelProvider(settings.getTransportChannelProvider())).setHeaderProvider(settings.getHeaderProvider())).setCredentialsProvider(settings.getCredentialsProvider())).setStreamWatchdogCheckInterval(settings.getStreamWatchdogCheckInterval())).setStreamWatchdogProvider(settings.getStreamWatchdogProvider());
        baseSettingsBuilder.createReadSessionSettings().setRetryableCodes(settings.createReadSessionSettings().getRetryableCodes()).setRetrySettings(settings.createReadSessionSettings().getRetrySettings());
        baseSettingsBuilder.readRowsSettings().setRetryableCodes(settings.readRowsSettings().getRetryableCodes()).setRetrySettings(settings.readRowsSettings().getRetrySettings()).setResumptionStrategy(settings.readRowsSettings().getResumptionStrategy()).setIdleTimeout(settings.readRowsSettings().getIdleTimeout());
        baseSettingsBuilder.batchCreateReadSessionStreamsSettings().setRetryableCodes(settings.batchCreateReadSessionStreamsSettings().getRetryableCodes()).setRetrySettings(settings.batchCreateReadSessionStreamsSettings().getRetrySettings());
        baseSettingsBuilder.finalizeStreamSettings().setRetryableCodes(settings.finalizeStreamSettings().getRetryableCodes()).setRetrySettings(settings.finalizeStreamSettings().getRetrySettings());
        baseSettingsBuilder.splitReadStreamSettings().setRetryableCodes(settings.splitReadStreamSettings().getRetryableCodes()).setRetrySettings(settings.splitReadStreamSettings().getRetrySettings());
        BigQueryStorageStubSettings baseSettings = baseSettingsBuilder.build();
        ClientContext clientContext = ClientContext.create(baseSettings);
        GrpcBigQueryStorageStub stub = new GrpcBigQueryStorageStub(baseSettings, clientContext);
        return new EnhancedBigQueryStorageStub(stub, baseSettings, readRowsRetryAttemptListener, clientContext);
    }

    @InternalApi(value="Visible for testing")
    EnhancedBigQueryStorageStub(GrpcBigQueryStorageStub stub, BigQueryStorageStubSettings stubSettings, BigQueryStorageSettings.RetryAttemptListener readRowsRetryAttemptListener, ClientContext context) {
        this.stub = stub;
        this.stubSettings = stubSettings;
        this.readRowsRetryAttemptListener = readRowsRetryAttemptListener;
        this.context = context;
    }

    public UnaryCallable<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionCallable() {
        return this.stub.createReadSessionCallable();
    }

    public ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsCallable() {
        ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> innerCallable = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigQueryStorageGrpc.getReadRowsMethod()).setParamsExtractor(new RequestParamsExtractor<Storage.ReadRowsRequest>(){

            @Override
            public Map<String, String> extract(Storage.ReadRowsRequest request) {
                return ImmutableMap.of("read_position.stream.name", String.valueOf(request.getReadPosition().getStream().getName()));
            }
        }).build(), this.stubSettings.readRowsSettings().getRetryableCodes());
        ServerStreamingCallSettings<Storage.ReadRowsRequest, Storage.ReadRowsResponse> callSettings = this.stubSettings.readRowsSettings();
        StreamingRetryAlgorithm retryAlgorithm = new StreamingRetryAlgorithm(new ApiResultRetryAlgorithm(this.readRowsRetryAttemptListener), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(callSettings.getRetrySettings(), this.context.getClock()));
        ScheduledRetryingExecutor<Void> retryingExecutor = new ScheduledRetryingExecutor<Void>(retryAlgorithm, this.context.getExecutor());
        if (this.context.getStreamWatchdog() != null) {
            innerCallable = Callables.watched(innerCallable, callSettings, this.context);
        }
        ReadRowsRetryingCallable outerCallable = new ReadRowsRetryingCallable(this.context.getDefaultCallContext(), innerCallable, retryingExecutor, callSettings.getResumptionStrategy());
        TracedServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> traced = new TracedServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse>(outerCallable, this.context.getTracerFactory(), SpanName.of(TRACING_OUTER_CLIENT_NAME, "ReadRows"));
        return traced.withDefaultCallContext(this.context.getDefaultCallContext());
    }

    public UnaryCallable<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsCallable() {
        return this.stub.batchCreateReadSessionStreamsCallable();
    }

    public UnaryCallable<Storage.FinalizeStreamRequest, Empty> finalizeStreamCallable() {
        return this.stub.finalizeStreamCallable();
    }

    public UnaryCallable<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamCallable() {
        return this.stub.splitReadStreamCallable();
    }

    @Override
    public void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

