/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.v1.AnnotationsProto;
import com.google.cloud.bigquery.storage.v1.BigQuerySchemaUtil;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.DescriptorProtos;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Descriptors;

public class BQTableSchemaToProtoDescriptor {
    private static ImmutableMap<TableFieldSchema.Mode, DescriptorProtos.FieldDescriptorProto.Label> BQTableSchemaModeMap = ImmutableMap.of(TableFieldSchema.Mode.NULLABLE, DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL, TableFieldSchema.Mode.REPEATED, DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED, TableFieldSchema.Mode.REQUIRED, DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
    private static ImmutableMap<TableFieldSchema.Type, DescriptorProtos.FieldDescriptorProto.Type> BQTableSchemaTypeMap = new ImmutableMap.Builder<TableFieldSchema.Type, DescriptorProtos.FieldDescriptorProto.Type>().put(TableFieldSchema.Type.BOOL, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put(TableFieldSchema.Type.BYTES, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put(TableFieldSchema.Type.DATE, DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put(TableFieldSchema.Type.DATETIME, DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put(TableFieldSchema.Type.DOUBLE, DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put(TableFieldSchema.Type.GEOGRAPHY, DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put(TableFieldSchema.Type.INT64, DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put(TableFieldSchema.Type.NUMERIC, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put(TableFieldSchema.Type.BIGNUMERIC, DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put(TableFieldSchema.Type.STRING, DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put(TableFieldSchema.Type.STRUCT, DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).put(TableFieldSchema.Type.TIME, DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put(TableFieldSchema.Type.TIMESTAMP, DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put(TableFieldSchema.Type.JSON, DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put(TableFieldSchema.Type.INTERVAL, DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put(TableFieldSchema.Type.RANGE, DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).build();

    public static Descriptors.Descriptor convertBQTableSchemaToProtoDescriptor(TableSchema BQTableSchema) throws Descriptors.DescriptorValidationException {
        Preconditions.checkNotNull(BQTableSchema, "BQTableSchema is null.");
        return BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptorImpl(BQTableSchema, "root", new HashMap<ImmutableList<TableFieldSchema>, Descriptors.Descriptor>());
    }

    private static Descriptors.Descriptor convertBQTableSchemaToProtoDescriptorImpl(TableSchema BQTableSchema, String scope, HashMap<ImmutableList<TableFieldSchema>, Descriptors.Descriptor> dependencyMap) throws Descriptors.DescriptorValidationException, IllegalArgumentException {
        ArrayList<Descriptors.FileDescriptor> dependenciesList = new ArrayList<Descriptors.FileDescriptor>();
        ArrayList<DescriptorProtos.FieldDescriptorProto> fields = new ArrayList<DescriptorProtos.FieldDescriptorProto>();
        int index = 1;
        block7: for (TableFieldSchema BQTableField : BQTableSchema.getFieldsList()) {
            String scopeName = BigQuerySchemaUtil.isProtoCompatible(BQTableField.getName()) ? BQTableField.getName() : BigQuerySchemaUtil.generatePlaceholderFieldName(BQTableField.getName());
            String currentScope = scope + "__" + scopeName;
            switch (BQTableField.getType()) {
                case STRUCT: {
                    Descriptors.Descriptor descriptor;
                    ImmutableList<TableFieldSchema> fieldList = ImmutableList.copyOf(BQTableField.getFieldsList());
                    if (dependencyMap.containsKey(fieldList)) {
                        descriptor = dependencyMap.get(fieldList);
                        dependenciesList.add(descriptor.getFile());
                        fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, descriptor.getName()));
                        continue block7;
                    }
                    descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptorImpl(TableSchema.newBuilder().addAllFields(fieldList).build(), currentScope, dependencyMap);
                    dependenciesList.add(descriptor.getFile());
                    dependencyMap.put(fieldList, descriptor);
                    fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, currentScope));
                    continue block7;
                }
                case RANGE: {
                    Descriptors.Descriptor descriptor;
                    switch (BQTableField.getRangeElementType().getType()) {
                        case DATE: 
                        case DATETIME: 
                        case TIMESTAMP: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("Error: %s of type RANGE requires range element type (DATE, DATETIME, TIMESTAMP)", currentScope));
                        }
                    }
                    ImmutableList<TableFieldSchema> rangeFields = ImmutableList.of(TableFieldSchema.newBuilder().setType(BQTableField.getRangeElementType().getType()).setName("start").setMode(TableFieldSchema.Mode.NULLABLE).build(), TableFieldSchema.newBuilder().setType(BQTableField.getRangeElementType().getType()).setName("end").setMode(TableFieldSchema.Mode.NULLABLE).build());
                    if (dependencyMap.containsKey(rangeFields)) {
                        descriptor = dependencyMap.get(rangeFields);
                        dependenciesList.add(descriptor.getFile());
                        fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, descriptor.getName()));
                        continue block7;
                    }
                    descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptorImpl(TableSchema.newBuilder().addAllFields(rangeFields).build(), currentScope, dependencyMap);
                    dependenciesList.add(descriptor.getFile());
                    dependencyMap.put(rangeFields, descriptor);
                    fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, currentScope));
                    continue block7;
                }
            }
            fields.add(BQTableSchemaToProtoDescriptor.convertBQTableFieldToProtoField(BQTableField, index++, currentScope));
        }
        Descriptors.FileDescriptor[] dependenciesArray = new Descriptors.FileDescriptor[dependenciesList.size()];
        dependenciesArray = dependenciesList.toArray(dependenciesArray);
        DescriptorProtos.DescriptorProto descriptorProto = DescriptorProtos.DescriptorProto.newBuilder().setName(scope).addAllField(fields).build();
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom(fileDescriptorProto, dependenciesArray);
        Descriptors.Descriptor descriptor = fileDescriptor.findMessageTypeByName(scope);
        return descriptor;
    }

    private static DescriptorProtos.FieldDescriptorProto convertBQTableFieldToProtoField(TableFieldSchema BQTableField, int index, String scope) {
        TableFieldSchema.Mode mode = BQTableField.getMode();
        String fieldName = BQTableField.getName().toLowerCase();
        DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptor = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(fieldName).setNumber(index).setLabel(BQTableSchemaModeMap.get(mode));
        switch (BQTableField.getType()) {
            case STRUCT: {
                fieldDescriptor.setTypeName(scope);
                break;
            }
            case RANGE: {
                fieldDescriptor.setType(BQTableSchemaTypeMap.get(BQTableField.getType()));
                fieldDescriptor.setTypeName(scope);
                break;
            }
            default: {
                fieldDescriptor.setType(BQTableSchemaTypeMap.get(BQTableField.getType()));
            }
        }
        if (!BigQuerySchemaUtil.isProtoCompatible(fieldName)) {
            fieldDescriptor.setName(BigQuerySchemaUtil.generatePlaceholderFieldName(fieldName));
            DescriptorProtos.FieldOptions.Builder fieldOptionBuilder = DescriptorProtos.FieldOptions.newBuilder();
            fieldOptionBuilder.setField(AnnotationsProto.columnName.getDescriptor(), fieldName);
            fieldDescriptor.setOptions((DescriptorProtos.FieldOptions)fieldOptionBuilder.build());
        }
        return fieldDescriptor.build();
    }
}

