/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ObsoleteApi;
import com.google.api.services.bigquery.model.QueryParameterType;
import com.google.api.services.bigquery.model.RangeValue;
import com.google.auto.value.AutoValue;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.bigquery.AutoValue_QueryParameterValue;
import com.google.cloud.bigquery.FieldElementType;
import com.google.cloud.bigquery.Range;
import com.google.cloud.bigquery.StandardSQLTypeName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Function;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.gcp.shaded.com.google.common.io.BaseEncoding;
import org.apache.iceberg.gcp.shaded.com.google.gson.JsonObject;
import org.threeten.extra.PeriodDuration;

@AutoValue
public abstract class QueryParameterValue
implements Serializable {
    private static final DateTimeFormatter timestampFormatter = new DateTimeFormatterBuilder().parseLenient().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 6, 9, true).optionalStart().appendOffset("+HHMM", "+00:00").optionalEnd().toFormatter().withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter timestampValidator = new DateTimeFormatterBuilder().parseLenient().append(timestampFormatter).optionalStart().appendOffsetId().optionalEnd().toFormatter().withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS");
    private static final DateTimeFormatter datetimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
    static final Function<QueryParameterValue, com.google.api.services.bigquery.model.QueryParameterValue> TO_VALUE_PB_FUNCTION = new Function<QueryParameterValue, com.google.api.services.bigquery.model.QueryParameterValue>(){

        @Override
        public com.google.api.services.bigquery.model.QueryParameterValue apply(QueryParameterValue value) {
            return value.toValuePb();
        }
    };
    private static final long serialVersionUID = -5620695863123562896L;

    QueryParameterValue() {
    }

    @Nullable
    public abstract String getValue();

    @Nullable
    public List<QueryParameterValue> getArrayValues() {
        return this.getArrayValuesInner();
    }

    @Nullable
    abstract ImmutableList<QueryParameterValue> getArrayValuesInner();

    @Nullable
    public Map<String, QueryParameterValue> getStructValues() {
        return this.getStructValuesInner();
    }

    @Nullable
    abstract Map<String, QueryParameterValue> getStructValuesInner();

    @Nullable
    public Range getRangeValues() {
        return this.getRangeValuesInner();
    }

    @Nullable
    abstract Range getRangeValuesInner();

    public abstract StandardSQLTypeName getType();

    @Nullable
    public abstract StandardSQLTypeName getArrayType();

    @Nullable
    public Map<String, QueryParameterValue> getStructTypes() {
        return this.getStructTypesInner();
    }

    @Nullable
    abstract Map<String, QueryParameterValue> getStructTypesInner();

    public static <T> QueryParameterValue of(T value, Class<T> type) {
        return QueryParameterValue.of(value, QueryParameterValue.classToType(type));
    }

    public static <T> QueryParameterValue of(T value, StandardSQLTypeName type) {
        return QueryParameterValue.newBuilder().setValue(QueryParameterValue.valueToStringOrNull(value, type)).setType(type).build();
    }

    public static QueryParameterValue bool(Boolean value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.BOOL);
    }

    public static QueryParameterValue int64(Long value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.INT64);
    }

    public static QueryParameterValue int64(Integer value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.INT64);
    }

    public static QueryParameterValue float64(Double value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.FLOAT64);
    }

    public static QueryParameterValue float64(Float value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.FLOAT64);
    }

    public static QueryParameterValue numeric(BigDecimal value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.NUMERIC);
    }

    public static QueryParameterValue bigNumeric(BigDecimal value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.BIGNUMERIC);
    }

    public static QueryParameterValue string(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.STRING);
    }

    public static QueryParameterValue geography(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.GEOGRAPHY);
    }

    public static QueryParameterValue json(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.JSON);
    }

    public static QueryParameterValue json(JsonObject value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.JSON);
    }

    public static QueryParameterValue bytes(byte[] value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.BYTES);
    }

    public static QueryParameterValue timestamp(Long value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.TIMESTAMP);
    }

    public static QueryParameterValue timestamp(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.TIMESTAMP);
    }

    public static QueryParameterValue date(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.DATE);
    }

    public static QueryParameterValue time(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.TIME);
    }

    public static QueryParameterValue dateTime(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.DATETIME);
    }

    public static QueryParameterValue interval(String value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.INTERVAL);
    }

    @ObsoleteApi(value="Use interval(String) instead")
    public static QueryParameterValue interval(PeriodDuration value) {
        return QueryParameterValue.of(value, StandardSQLTypeName.INTERVAL);
    }

    public static QueryParameterValue range(Range value) {
        return QueryParameterValue.newBuilder().setRangeValues(value).setType(StandardSQLTypeName.RANGE).build();
    }

    public static <T> QueryParameterValue array(T[] array, Class<T> clazz) {
        return QueryParameterValue.array(array, QueryParameterValue.classToType(clazz));
    }

    public static <T> QueryParameterValue array(T[] array, StandardSQLTypeName type) {
        ArrayList<QueryParameterValue> listValues = new ArrayList<QueryParameterValue>();
        for (T obj : array) {
            if (type == StandardSQLTypeName.STRUCT) {
                listValues.add((QueryParameterValue)obj);
                continue;
            }
            listValues.add(QueryParameterValue.of(obj, type));
        }
        return QueryParameterValue.newBuilder().setArrayValues(listValues).setType(StandardSQLTypeName.ARRAY).setArrayType(type).build();
    }

    public static QueryParameterValue struct(Map<String, QueryParameterValue> struct) {
        return QueryParameterValue.newBuilder().setStructValues(struct).setType(StandardSQLTypeName.STRUCT).build();
    }

    private static <T> StandardSQLTypeName classToType(Class<T> type) {
        if (Boolean.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.BOOL;
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.STRING;
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.GEOGRAPHY;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.INT64;
        }
        if (Long.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.INT64;
        }
        if (Double.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.FLOAT64;
        }
        if (Float.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.FLOAT64;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.NUMERIC;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.DATE;
        }
        if (String.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.JSON;
        }
        if (JsonObject.class.isAssignableFrom(type)) {
            return StandardSQLTypeName.JSON;
        }
        throw new IllegalArgumentException("Unsupported object type for QueryParameter: " + type);
    }

    private static <T> String valueToStringOrNull(T value, StandardSQLTypeName type) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case BOOL: {
                if (!(value instanceof Boolean)) break;
                return value.toString();
            }
            case INT64: {
                if (!(value instanceof Integer) && !(value instanceof Long)) break;
                return value.toString();
            }
            case FLOAT64: {
                if (!(value instanceof Double) && !(value instanceof Float)) break;
                return value.toString();
            }
            case NUMERIC: 
            case BIGNUMERIC: {
                if (!(value instanceof BigDecimal)) break;
                return value.toString();
            }
            case BYTES: {
                if (!(value instanceof byte[])) break;
                return BaseEncoding.base64().encode((byte[])value);
            }
            case STRING: {
                return value.toString();
            }
            case GEOGRAPHY: {
                return value.toString();
            }
            case JSON: {
                if (value instanceof String || value instanceof JsonObject) {
                    return value.toString();
                }
            }
            case INTERVAL: {
                if (!(value instanceof String) && !(value instanceof PeriodDuration)) break;
                return value.toString();
            }
            case STRUCT: {
                throw new IllegalArgumentException("Cannot convert STRUCT to String value");
            }
            case ARRAY: {
                throw new IllegalArgumentException("Cannot convert ARRAY to String value");
            }
            case RANGE: {
                throw new IllegalArgumentException("Cannot convert RANGE to String value");
            }
            case TIMESTAMP: {
                if (value instanceof Long) {
                    Timestamp timestamp = Timestamp.ofTimeMicroseconds((Long)value);
                    return timestampFormatter.format(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()));
                }
                if (!(value instanceof String)) break;
                QueryParameterValue.checkFormat(value, timestampValidator);
                return (String)value;
            }
            case DATE: {
                if (value instanceof String) {
                    QueryParameterValue.checkFormat(value, dateFormatter);
                    return (String)value;
                }
                if (!(value instanceof java.util.Date)) break;
                Date date = Date.fromJavaUtilDate((java.util.Date)value);
                return date.toString();
            }
            case TIME: {
                if (!(value instanceof String)) break;
                QueryParameterValue.checkFormat(value, timeFormatter);
                return (String)value;
            }
            case DATETIME: {
                if (!(value instanceof String)) break;
                QueryParameterValue.checkFormat(value, datetimeFormatter);
                return (String)value;
            }
            default: {
                throw new UnsupportedOperationException("Implementation error - Unsupported type: " + (Object)((Object)type));
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)type) + " incompatible with " + value.getClass().getCanonicalName());
    }

    private static void checkFormat(Object value, DateTimeFormatter formatter) {
        try {
            formatter.parse((String)value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_QueryParameterValue.Builder();
    }

    com.google.api.services.bigquery.model.QueryParameterValue toValuePb() {
        com.google.api.services.bigquery.model.QueryParameterValue valuePb = new com.google.api.services.bigquery.model.QueryParameterValue();
        valuePb.setValue(this.getValue());
        if (this.getArrayValues() != null) {
            valuePb.setArrayValues(Lists.transform(this.getArrayValues(), TO_VALUE_PB_FUNCTION));
        }
        if (this.getStructValues() != null) {
            HashMap<String, com.google.api.services.bigquery.model.QueryParameterValue> structValues = new HashMap<String, com.google.api.services.bigquery.model.QueryParameterValue>();
            for (Map.Entry<String, QueryParameterValue> structValue : this.getStructValues().entrySet()) {
                structValues.put(structValue.getKey(), structValue.getValue().toValuePb());
            }
            valuePb.setStructValues(structValues);
        }
        if (this.getType() == StandardSQLTypeName.RANGE) {
            RangeValue rangeValue = new RangeValue();
            if (!this.getRangeValues().getStart().isNull()) {
                com.google.api.services.bigquery.model.QueryParameterValue startValue = new com.google.api.services.bigquery.model.QueryParameterValue();
                startValue.setValue(this.getRangeValues().getStart().getStringValue());
                rangeValue.setStart(startValue);
            }
            if (!this.getRangeValues().getEnd().isNull()) {
                com.google.api.services.bigquery.model.QueryParameterValue endValue = new com.google.api.services.bigquery.model.QueryParameterValue();
                endValue.setValue(this.getRangeValues().getEnd().getStringValue());
                rangeValue.setEnd(endValue);
            }
            valuePb.setRangeValue(rangeValue);
        }
        return valuePb;
    }

    QueryParameterType toTypePb() {
        QueryParameterType typePb = new QueryParameterType();
        typePb.setType(this.getType().toString());
        if (this.getArrayType() != null) {
            List<QueryParameterValue> values = this.getArrayValues();
            if (this.getArrayType() == StandardSQLTypeName.STRUCT && values != null && values.size() != 0) {
                QueryParameterType structType = values.get(0).toTypePb();
                typePb.setArrayType(structType);
            } else {
                QueryParameterType arrayTypePb = new QueryParameterType();
                arrayTypePb.setType(this.getArrayType().toString());
                typePb.setArrayType(arrayTypePb);
            }
        }
        if (this.getStructTypes() != null) {
            ArrayList<QueryParameterType.StructTypes> structTypes = new ArrayList<QueryParameterType.StructTypes>();
            for (Map.Entry<String, QueryParameterValue> entry : this.getStructTypes().entrySet()) {
                QueryParameterType.StructTypes structType = new QueryParameterType.StructTypes();
                structType.setName(entry.getKey());
                structType.setType(entry.getValue().toTypePb());
                structTypes.add(structType);
            }
            typePb.setStructTypes(structTypes);
        }
        if (this.getType() == StandardSQLTypeName.RANGE && this.getRangeValues() != null && this.getRangeValues().getType() != null) {
            QueryParameterType rangeTypePb = new QueryParameterType();
            rangeTypePb.setType(this.getRangeValues().getType().getType());
            typePb.setRangeElementType(rangeTypePb);
        }
        return typePb;
    }

    static QueryParameterValue fromPb(com.google.api.services.bigquery.model.QueryParameterValue valuePb, QueryParameterType typePb) {
        Builder valueBuilder = QueryParameterValue.newBuilder();
        HashMap<String, QueryParameterType> parameterTypes = new HashMap<String, QueryParameterType>();
        StandardSQLTypeName type = StandardSQLTypeName.valueOf(typePb.getType());
        valueBuilder.setType(type);
        if (type == StandardSQLTypeName.ARRAY) {
            valueBuilder.setArrayType(StandardSQLTypeName.valueOf(typePb.getArrayType().getType()));
            if (valuePb == null || valuePb.getArrayValues() == null) {
                valueBuilder.setArrayValues(ImmutableList.of());
            } else {
                ImmutableList.Builder arrayValues = ImmutableList.builder();
                for (com.google.api.services.bigquery.model.QueryParameterValue elementValuePb : valuePb.getArrayValues()) {
                    arrayValues.add(QueryParameterValue.fromPb(elementValuePb, typePb.getArrayType()));
                }
                valueBuilder.setArrayValues((List<QueryParameterValue>)((Object)arrayValues.build()));
            }
        } else if (type == StandardSQLTypeName.STRUCT) {
            HashMap<String, QueryParameterValue> structTypes = new HashMap<String, QueryParameterValue>();
            for (QueryParameterType.StructTypes types : typePb.getStructTypes()) {
                structTypes.put(types.getName(), QueryParameterValue.newBuilder().setType(StandardSQLTypeName.valueOf(types.getType().getType())).build());
            }
            valueBuilder.setStructTypes(structTypes);
            if (valuePb == null || valuePb.getStructValues() == null) {
                valueBuilder.setStructValues(ImmutableMap.of());
            } else {
                HashMap<String, QueryParameterValue> structValues = new HashMap<String, QueryParameterValue>();
                for (QueryParameterType.StructTypes structTypes2 : typePb.getStructTypes()) {
                    parameterTypes.put(structTypes2.getName(), structTypes2.getType());
                }
                for (Map.Entry entry : valuePb.getStructValues().entrySet()) {
                    structValues.put((String)entry.getKey(), QueryParameterValue.fromPb((com.google.api.services.bigquery.model.QueryParameterValue)entry.getValue(), (QueryParameterType)parameterTypes.get(entry.getKey())));
                }
                valueBuilder.setStructValues(structValues);
            }
        } else if (type == StandardSQLTypeName.RANGE) {
            Range.Builder range = Range.newBuilder();
            if (valuePb.getRangeValue() != null) {
                RangeValue rangeValuePb = valuePb.getRangeValue();
                if (rangeValuePb.getStart() != null && rangeValuePb.getStart().getValue() != null) {
                    range.setStart(valuePb.getRangeValue().getStart().getValue());
                }
                if (rangeValuePb.getEnd() != null && rangeValuePb.getEnd().getValue() != null) {
                    range.setEnd(valuePb.getRangeValue().getEnd().getValue());
                }
            }
            if (typePb.getRangeElementType() != null && typePb.getRangeElementType().getType() != null) {
                range.setType(FieldElementType.fromPb(typePb));
            }
            valueBuilder.setRangeValues(range.build());
        } else {
            valueBuilder.setValue(valuePb == null ? "" : valuePb.getValue());
        }
        return valueBuilder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setValue(String var1);

        public Builder setArrayValues(List<QueryParameterValue> arrayValues) {
            return this.setArrayValuesInner(ImmutableList.copyOf(arrayValues));
        }

        abstract Builder setArrayValuesInner(ImmutableList<QueryParameterValue> var1);

        public Builder setStructValues(Map<String, QueryParameterValue> structValues) {
            this.setStructTypes(ImmutableMap.copyOf(structValues));
            return this.setStructValuesInner(ImmutableMap.copyOf(structValues));
        }

        abstract Builder setStructValuesInner(Map<String, QueryParameterValue> var1);

        public Builder setRangeValues(Range range) {
            return this.setRangeValuesInner(range);
        }

        abstract Builder setRangeValuesInner(Range var1);

        public abstract Builder setType(StandardSQLTypeName var1);

        public abstract Builder setArrayType(StandardSQLTypeName var1);

        public Builder setStructTypes(Map<String, QueryParameterValue> structTypes) {
            return this.setStructTypesInner(structTypes);
        }

        abstract Builder setStructTypesInner(Map<String, QueryParameterValue> var1);

        public abstract QueryParameterValue build();
    }
}

