/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Expr;
import com.google.cloud.Binding;
import com.google.cloud.Condition;
import com.google.cloud.Policy;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;

class PolicyHelper {
    PolicyHelper() {
    }

    static Policy convertFromApiPolicy(com.google.api.services.bigquery.model.Policy apiPolicy) {
        Policy.Builder policyBuilder = Policy.newBuilder();
        List<com.google.api.services.bigquery.model.Binding> bindings = apiPolicy.getBindings();
        if (null != bindings) {
            ImmutableList.Builder coreBindings = ImmutableList.builder();
            Binding.Builder bindingBuilder = Binding.newBuilder();
            for (com.google.api.services.bigquery.model.Binding binding : bindings) {
                bindingBuilder.setRole(binding.getRole());
                bindingBuilder.setMembers(binding.getMembers());
                if (binding.getCondition() != null) {
                    Condition.Builder conditionBuilder = Condition.newBuilder();
                    conditionBuilder.setTitle(binding.getCondition().getTitle());
                    conditionBuilder.setDescription(binding.getCondition().getDescription());
                    conditionBuilder.setExpression(binding.getCondition().getExpression());
                    bindingBuilder.setCondition(conditionBuilder.build());
                }
                coreBindings.add(bindingBuilder.build());
            }
            policyBuilder.setBindings((List<Binding>)((Object)coreBindings.build()));
        }
        if (null != apiPolicy.getVersion()) {
            policyBuilder.setVersion(apiPolicy.getVersion());
        }
        return policyBuilder.setEtag(apiPolicy.getEtag()).build();
    }

    static com.google.api.services.bigquery.model.Policy convertToApiPolicy(Policy policy) {
        ArrayList<com.google.api.services.bigquery.model.Binding> bindings = null;
        if (policy.getBindingsList().size() != 0) {
            bindings = new ArrayList<com.google.api.services.bigquery.model.Binding>(policy.getBindingsList().size());
            for (Binding binding : policy.getBindingsList()) {
                com.google.api.services.bigquery.model.Binding apiBinding = new com.google.api.services.bigquery.model.Binding();
                apiBinding.setRole(binding.getRole());
                apiBinding.setMembers(new ArrayList<String>(binding.getMembers()));
                if (binding.getCondition() != null) {
                    Expr expr = new Expr();
                    expr.setTitle(binding.getCondition().getTitle());
                    expr.setDescription(binding.getCondition().getDescription());
                    expr.setExpression(binding.getCondition().getExpression());
                    apiBinding.setCondition(expr);
                }
                bindings.add(apiBinding);
            }
        }
        return new com.google.api.services.bigquery.model.Policy().setBindings(bindings).setEtag(policy.getEtag()).setVersion(policy.getVersion());
    }
}

