/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TrainingRun;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.ModelId;
import com.google.cloud.bigquery.ModelInfo;
import com.google.cloud.bigquery.StandardSQLField;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;

public class Model
extends ModelInfo {
    private final BigQueryOptions options;
    private transient BigQuery bigquery;

    Model(BigQuery bigquery, ModelInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.bigquery = Preconditions.checkNotNull(bigquery);
        this.options = (BigQueryOptions)bigquery.getOptions();
    }

    public boolean exists() {
        return this.bigquery.getModel(this.getModelId(), BigQuery.ModelOption.fields(new BigQuery.ModelField[0])) != null;
    }

    public Model reload(BigQuery.ModelOption ... options) {
        return this.bigquery.getModel(this.getModelId(), options);
    }

    public Model update(BigQuery.ModelOption ... options) {
        return this.bigquery.update(this, options);
    }

    public boolean delete() {
        return this.bigquery.delete(this.getModelId());
    }

    public BigQuery getBigQuery() {
        return this.bigquery;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Model.class)) {
            return false;
        }
        Model other = (Model)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals(this.options, other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(super.hashCode(), this.options);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bigquery = (BigQuery)this.options.getService();
    }

    static Model fromPb(BigQuery bigquery, com.google.api.services.bigquery.model.Model modelPb) {
        return new Model(bigquery, new ModelInfo.BuilderImpl(modelPb));
    }

    public static class Builder
    extends ModelInfo.Builder {
        private final BigQuery bigquery;
        private final ModelInfo.BuilderImpl infoBuilder;

        Builder(BigQuery bigquery, ModelId modelId) {
            this.bigquery = bigquery;
            this.infoBuilder = new ModelInfo.BuilderImpl();
            this.infoBuilder.setModelId(modelId);
        }

        Builder(Model model) {
            this.bigquery = model.bigquery;
            this.infoBuilder = new ModelInfo.BuilderImpl(model);
        }

        @Override
        Builder setCreationTime(Long creationTime) {
            this.infoBuilder.setCreationTime(creationTime);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        public Builder setExpirationTime(Long expirationTime) {
            this.infoBuilder.setExpirationTime(expirationTime);
            return this;
        }

        @Override
        public Builder setFriendlyName(String friendlyName) {
            this.infoBuilder.setFriendlyName(friendlyName);
            return this;
        }

        @Override
        Builder setLastModifiedTime(Long lastModifiedTime) {
            this.infoBuilder.setLastModifiedTime(lastModifiedTime);
            return this;
        }

        @Override
        public Builder setModelId(ModelId modelId) {
            this.infoBuilder.setModelId(modelId);
            return this;
        }

        @Override
        Builder setModelType(String modelType) {
            this.infoBuilder.setModelType(modelType);
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.infoBuilder.setLabels(labels);
            return this;
        }

        @Override
        Builder setLocation(String location) {
            this.infoBuilder.setLocation(location);
            return this;
        }

        @Override
        Builder setTrainingRuns(List<TrainingRun> trainingRunList) {
            this.infoBuilder.setTrainingRuns(trainingRunList);
            return this;
        }

        @Override
        Builder setLabelColumns(List<StandardSQLField> labelColumnList) {
            this.infoBuilder.setLabelColumns(labelColumnList);
            return this;
        }

        @Override
        Builder setFeatureColumns(List<StandardSQLField> featureColumnList) {
            this.infoBuilder.setFeatureColumns(featureColumnList);
            return this;
        }

        @Override
        public Builder setEncryptionConfiguration(EncryptionConfiguration configuration) {
            this.infoBuilder.setEncryptionConfiguration(configuration);
            return this;
        }

        @Override
        public Model build() {
            return new Model(this.bigquery, this.infoBuilder);
        }
    }
}

