/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableSet;

public class BigQueryRetryConfig {
    private final ImmutableSet<String> retriableErrorMessages;
    private final ImmutableSet<String> retriableRegExes;

    private BigQueryRetryConfig(Builder builder) {
        this.retriableErrorMessages = builder.retriableErrorMessages.build();
        this.retriableRegExes = builder.retriableRegExes.build();
    }

    public ImmutableSet<String> getRetriableErrorMessages() {
        return this.retriableErrorMessages;
    }

    public ImmutableSet<String> getRetriableRegExes() {
        return this.retriableRegExes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> retriableErrorMessages = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> retriableRegExes = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder retryOnMessage(String ... errorMessages) {
            for (String errorMessage : errorMessages) {
                this.retriableErrorMessages.add((Object)Preconditions.checkNotNull(errorMessage));
            }
            return this;
        }

        public final Builder retryOnRegEx(String ... regExPatterns) {
            for (String regExPattern : regExPatterns) {
                this.retriableRegExes.add((Object)Preconditions.checkNotNull(regExPattern));
            }
            return this;
        }

        public BigQueryRetryConfig build() {
            return new BigQueryRetryConfig(this);
        }
    }
}

