/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.paging.Page;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TestIamPermissionsResponse;
import com.google.cloud.BaseService;
import com.google.cloud.PageImpl;
import com.google.cloud.Policy;
import com.google.cloud.RetryOption;
import com.google.cloud.Tuple;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryBaseService;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import com.google.cloud.bigquery.BigQueryRetryHelper;
import com.google.cloud.bigquery.Connection;
import com.google.cloud.bigquery.ConnectionImpl;
import com.google.cloud.bigquery.ConnectionSettings;
import com.google.cloud.bigquery.Dataset;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.InsertAllRequest;
import com.google.cloud.bigquery.InsertAllResponse;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobException;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.Model;
import com.google.cloud.bigquery.ModelId;
import com.google.cloud.bigquery.ModelInfo;
import com.google.cloud.bigquery.Option;
import com.google.cloud.bigquery.PolicyHelper;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryRequestInfo;
import com.google.cloud.bigquery.QueryResponse;
import com.google.cloud.bigquery.Routine;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.RoutineInfo;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.cloud.bigquery.spi.v2.HttpBigQueryRpc;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Function;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Strings;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Supplier;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.FluentIterable;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.Iterables;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.NonNull;

final class BigQueryImpl
extends BaseService<BigQueryOptions>
implements BigQuery {
    private final HttpBigQueryRpc bigQueryRpc;
    private static final BigQueryRetryConfig EMPTY_RETRY_CONFIG = BigQueryRetryConfig.newBuilder().build();
    private static final BigQueryRetryConfig DEFAULT_RETRY_CONFIG = BigQueryRetryConfig.newBuilder().retryOnMessage("Exceeded rate limits:").retryOnMessage("Job exceeded rate limits:").retryOnRegEx(".*exceed.*rate.*limit.*").build();

    BigQueryImpl(BigQueryOptions options) {
        super(options);
        this.bigQueryRpc = options.getBigQueryRpcV2();
    }

    @Override
    public Dataset create(DatasetInfo datasetInfo, BigQuery.DatasetOption ... options) {
        final com.google.api.services.bigquery.model.Dataset datasetPb = datasetInfo.setProjectId(Strings.isNullOrEmpty(datasetInfo.getDatasetId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : datasetInfo.getDatasetId().getProject()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed datasetCreate = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            datasetCreate = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.createDataset").setAllAttributes(datasetInfo.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope datasetCreateScope = datasetCreate != null ? datasetCreate.makeCurrent() : null;
            try {
                Dataset dataset = Dataset.fromPb(this, BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Dataset>(){

                    @Override
                    public com.google.api.services.bigquery.model.Dataset call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.createSkipExceptionTranslation(datasetPb, optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                if (datasetCreateScope != null) {
                    datasetCreateScope.close();
                }
                return dataset;
            }
            catch (Throwable throwable) {
                try {
                    if (datasetCreateScope != null) {
                        try {
                            datasetCreateScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (datasetCreate != null) {
                datasetCreate.end();
            }
        }
    }

    @Override
    public Table create(TableInfo tableInfo, BigQuery.TableOption ... options) {
        final com.google.api.services.bigquery.model.Table tablePb = tableInfo.setProjectId(Strings.isNullOrEmpty(tableInfo.getTableId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableInfo.getTableId().getProject()).toPb();
        this.handleExternalTableSchema(tablePb);
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed tableCreate = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            tableCreate = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.createTable").setAllAttributes(tableInfo.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope tableCreateScope = tableCreate != null ? tableCreate.makeCurrent() : null;
            try {
                Table table = Table.fromPb(this, BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Table>(){

                    @Override
                    public com.google.api.services.bigquery.model.Table call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.createSkipExceptionTranslation(tablePb, optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                if (tableCreateScope != null) {
                    tableCreateScope.close();
                }
                return table;
            }
            catch (Throwable throwable) {
                try {
                    if (tableCreateScope != null) {
                        try {
                            tableCreateScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (tableCreate != null) {
                tableCreate.end();
            }
        }
    }

    private void handleExternalTableSchema(com.google.api.services.bigquery.model.Table tablePb) {
        if (tablePb.getExternalDataConfiguration() != null) {
            tablePb.setSchema(tablePb.getExternalDataConfiguration().getSchema());
            tablePb.getExternalDataConfiguration().setSchema(null);
        }
    }

    @Override
    public Routine create(RoutineInfo routineInfo, BigQuery.RoutineOption ... options) {
        final com.google.api.services.bigquery.model.Routine routinePb = routineInfo.setProjectId(Strings.isNullOrEmpty(routineInfo.getRoutineId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : routineInfo.getRoutineId().getProject()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed routineCreate = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            routineCreate = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.createRoutine").setAllAttributes(routineInfo.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope createRoutineScope = routineCreate != null ? routineCreate.makeCurrent() : null;
            try {
                Routine routine = Routine.fromPb(this, BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Routine>(){

                    @Override
                    public com.google.api.services.bigquery.model.Routine call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.createSkipExceptionTranslation(routinePb, optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                if (createRoutineScope != null) {
                    createRoutineScope.close();
                }
                return routine;
            }
            catch (Throwable throwable) {
                try {
                    if (createRoutineScope != null) {
                        try {
                            createRoutineScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (routineCreate != null) {
                routineCreate.end();
            }
        }
    }

    @Override
    public Job create(JobInfo jobInfo, BigQuery.JobOption ... options) {
        Supplier<JobId> idProvider = new Supplier<JobId>(){

            @Override
            public JobId get() {
                return JobId.of();
            }
        };
        return this.create(jobInfo, idProvider, options);
    }

    @Override
    @BetaApi
    public Connection createConnection(@NonNull ConnectionSettings connectionSettings) throws BigQueryException {
        return new ConnectionImpl(connectionSettings, (BigQueryOptions)this.getOptions(), this.bigQueryRpc, DEFAULT_RETRY_CONFIG);
    }

    @Override
    @BetaApi
    public Connection createConnection() throws BigQueryException {
        ConnectionSettings defaultConnectionSettings = ConnectionSettings.newBuilder().build();
        return new ConnectionImpl(defaultConnectionSettings, (BigQueryOptions)this.getOptions(), this.bigQueryRpc, DEFAULT_RETRY_CONFIG);
    }

    /*
     * Unable to fully structure code
     */
    @InternalApi(value="visible for testing")
    Job create(final JobInfo jobInfo, final Supplier<JobId> idProvider, BigQuery.JobOption ... options) {
        idRandom = jobInfo.getJobId() == null;
        optionsMap = BigQueryImpl.optionMap(options);
        jobCreate = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            jobCreate = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.createJob").setAllAttributes(jobInfo.getJobId().getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        finalJobId = new JobId[1];
        try {
            block26: {
                jobCreateScope = jobCreate != null ? jobCreate.makeCurrent() : null;
                try {
                    var10_9 = Job.fromPb(this, BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Job>(){

                        @Override
                        public com.google.api.services.bigquery.model.Job call() throws IOException {
                            if (idRandom) {
                                JobInfo recreatedJobInfo = jobInfo.toBuilder().setJobId((JobId)idProvider.get()).build();
                                com.google.api.services.bigquery.model.Job newJobPb = recreatedJobInfo.setProjectId(((BigQueryOptions)BigQueryImpl.this.getOptions()).getProjectId()).toPb();
                                finalJobId[0] = recreatedJobInfo.getJobId();
                                return BigQueryImpl.this.bigQueryRpc.createSkipExceptionTranslation(newJobPb, optionsMap);
                            }
                            com.google.api.services.bigquery.model.Job jobPb = jobInfo.setProjectId(((BigQueryOptions)BigQueryImpl.this.getOptions()).getProjectId()).toPb();
                            return BigQueryImpl.this.bigQueryRpc.createSkipExceptionTranslation(jobPb, optionsMap);
                        }
                    }, BigQueryImpl.getRetryOptions(optionsMap) != null ? RetryOption.mergeToSettings(((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryImpl.getRetryOptions(optionsMap)) : ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), BigQueryImpl.getBigQueryRetryConfig(optionsMap) != null ? BigQueryImpl.getBigQueryRetryConfig(optionsMap) : BigQueryImpl.DEFAULT_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                    if (jobCreateScope == null) break block26;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    try {
                        throw BigQueryException.translateAndThrow(e);
                    }
                    catch (BigQueryException e) {
                        createException = e;
                        if (idRandom) ** GOTO lbl33
                        if (createException instanceof BigQueryException && createException.getCause() != null && createException.getCause().getMessage() != null && (matcher = (pattern = Pattern.compile(".*Already.*Exists:.*Job.*", 2)).matcher(createException.getCause().getMessage())).find() && (jobCreationTime = (job = this.getJob(jobInfo.getJobId(), new BigQuery.JobOption[]{BigQuery.JobOption.fields(new BigQuery.JobField[]{BigQuery.JobField.STATISTICS})})).getStatistics().getCreationTime().longValue()) >= (jobMaxStaleTime = Instant.ofEpochMilli(jobMinStaleTime = System.currentTimeMillis()).minus(1L, ChronoUnit.DAYS).toEpochMilli()) && jobCreationTime <= jobMinStaleTime) {
                            var19_24 = job;
                            if (jobCreateScope != null) {
                                jobCreateScope.close();
                            }
                            if (jobCreate != null) {
                                jobCreate.end();
                            }
                            return var19_24;
                        }
                        try {
                            throw createException;
lbl33:
                            // 1 sources

                            try {
                                job = this.getJob(finalJobId[0], new BigQuery.JobOption[0]);
                            }
                            catch (BigQueryException e) {
                                throw createException;
                            }
                            if (job == null) {
                                throw createException;
                            }
                            var11_18 = job;
                            if (jobCreateScope != null) {
                                jobCreateScope.close();
                            }
                            if (jobCreate != null) {
                                jobCreate.end();
                            }
                            return var11_18;
                        }
                        catch (Throwable var10_14) {
                            if (jobCreateScope != null) {
                                try {
                                    jobCreateScope.close();
                                }
                                catch (Throwable var11_19) {
                                    var10_14.addSuppressed(var11_19);
                                }
                            }
                            throw var10_14;
                        }
                    }
                }
                jobCreateScope.close();
            }
            return var10_9;
        }
        finally {
            if (jobCreate != null) {
                jobCreate.end();
            }
        }
    }

    @Override
    public Dataset getDataset(String datasetId, BigQuery.DatasetOption ... options) {
        return this.getDataset(DatasetId.of(datasetId), options);
    }

    @Override
    public Dataset getDataset(DatasetId datasetId, BigQuery.DatasetOption ... options) {
        final DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed datasetGet = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            datasetGet = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.getDataset").setAllAttributes(completeDatasetId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope datasetGetScope = datasetGet != null ? datasetGet.makeCurrent() : null;
            try {
                com.google.api.services.bigquery.model.Dataset answer = BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Dataset>(){

                    @Override
                    public com.google.api.services.bigquery.model.Dataset call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.getDatasetSkipExceptionTranslation(completeDatasetId.getProject(), completeDatasetId.getDataset(), optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                Dataset dataset = Dataset.fromPb(this, answer);
                if (datasetGetScope != null) {
                    datasetGetScope.close();
                }
                return dataset;
            }
            catch (Throwable throwable) {
                try {
                    if (datasetGetScope != null) {
                        try {
                            datasetGetScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        if (((BigQueryOptions)this.getOptions()).getThrowNotFound()) {
                            throw new BigQueryException(404, "Dataset not found");
                        }
                        Dataset dataset = null;
                        return dataset;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (datasetGet != null) {
                datasetGet.end();
            }
        }
    }

    @Override
    public Page<Dataset> listDatasets(BigQuery.DatasetListOption ... options) {
        return this.listDatasets(((BigQueryOptions)this.getOptions()).getProjectId(), options);
    }

    @Override
    public Page<Dataset> listDatasets(String projectId, BigQuery.DatasetListOption ... options) {
        ImplicitContextKeyed datasetsList = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            datasetsList = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listDatasets").setAttribute("bq.dataset.project_id", projectId).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope datasetsListScope = datasetsList != null ? datasetsList.makeCurrent() : null;
            try {
                Page<Dataset> page = BigQueryImpl.listDatasets(projectId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
                if (datasetsListScope != null) {
                    datasetsListScope.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                if (datasetsListScope != null) {
                    try {
                        datasetsListScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (datasetsList != null) {
                datasetsList.end();
            }
        }
    }

    private static Page<Dataset> listDatasets(final String projectId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple<String, Iterable<com.google.api.services.bigquery.model.Dataset>> result = BigQueryRetryHelper.runWithRetries(new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Dataset>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Dataset>> call() throws IOException {
                    return serviceOptions.getBigQueryRpcV2().listDatasetsSkipExceptionTranslation(projectId, optionsMap);
                }
            }, serviceOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, serviceOptions.getClock(), EMPTY_RETRY_CONFIG, serviceOptions.isOpenTelemetryTracingEnabled(), serviceOptions.getOpenTelemetryTracer());
            String cursor = result.x();
            return new PageImpl<Dataset>(new DatasetPageFetcher(projectId, serviceOptions, cursor, optionsMap), cursor, Iterables.transform(result.y(), new Function<com.google.api.services.bigquery.model.Dataset, Dataset>(){

                @Override
                public Dataset apply(com.google.api.services.bigquery.model.Dataset dataset) {
                    return Dataset.fromPb((BigQuery)serviceOptions.getService(), dataset);
                }
            }));
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean delete(String datasetId, BigQuery.DatasetDeleteOption ... options) {
        return this.delete(DatasetId.of(datasetId), options);
    }

    @Override
    public boolean delete(DatasetId datasetId, BigQuery.DatasetDeleteOption ... options) {
        final DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed datasetDelete = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            datasetDelete = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.deleteDataset").setAllAttributes(datasetId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope datasetDeleteScope = datasetDelete != null ? datasetDelete.makeCurrent() : null;
            try {
                boolean bl = BigQueryRetryHelper.runWithRetries(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.deleteDatasetSkipExceptionTranslation(completeDatasetId.getProject(), completeDatasetId.getDataset(), optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                if (datasetDeleteScope != null) {
                    datasetDeleteScope.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (datasetDeleteScope != null) {
                        try {
                            datasetDeleteScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        boolean bl = false;
                        return bl;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (datasetDelete != null) {
                datasetDelete.end();
            }
        }
    }

    @Override
    public boolean delete(String datasetId, String tableId) {
        return this.delete(TableId.of(datasetId, tableId));
    }

    @Override
    public boolean delete(TableId tableId) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty(tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        ImplicitContextKeyed tableDelete = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            tableDelete = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.deleteTable").setAllAttributes(tableId.getOtelAttributes()).startSpan();
        }
        try {
            Scope tableDeleteScope = tableDelete != null ? tableDelete.makeCurrent() : null;
            try {
                boolean bl = BigQueryRetryHelper.runWithRetries(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.deleteTableSkipExceptionTranslation(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable());
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                if (tableDeleteScope != null) {
                    tableDeleteScope.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (tableDeleteScope != null) {
                        try {
                            tableDeleteScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        boolean bl = false;
                        return bl;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (tableDelete != null) {
                tableDelete.end();
            }
        }
    }

    @Override
    public boolean delete(ModelId modelId) {
        final ModelId completeModelId = modelId.setProjectId(Strings.isNullOrEmpty(modelId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : modelId.getProject());
        ImplicitContextKeyed modelDelete = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            modelDelete = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.deleteModel").setAllAttributes(modelId.getOtelAttributes()).startSpan();
        }
        try {
            Scope modelDeleteScope = modelDelete != null ? modelDelete.makeCurrent() : null;
            try {
                boolean bl = BigQueryRetryHelper.runWithRetries(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.deleteModelSkipExceptionTranslation(completeModelId.getProject(), completeModelId.getDataset(), completeModelId.getModel());
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                if (modelDeleteScope != null) {
                    modelDeleteScope.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (modelDeleteScope != null) {
                        try {
                            modelDeleteScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        boolean bl = false;
                        return bl;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (modelDelete != null) {
                modelDelete.end();
            }
        }
    }

    @Override
    public boolean delete(RoutineId routineId) {
        final RoutineId completeRoutineId = routineId.setProjectId(Strings.isNullOrEmpty(routineId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : routineId.getProject());
        ImplicitContextKeyed routineDelete = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            routineDelete = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.deleteRoutine").setAllAttributes(routineId.getOtelAttributes()).startSpan();
        }
        try {
            Scope routineDeleteScope = routineDelete != null ? routineDelete.makeCurrent() : null;
            try {
                boolean bl = BigQueryRetryHelper.runWithRetries(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.deleteRoutineSkipExceptionTranslation(completeRoutineId.getProject(), completeRoutineId.getDataset(), completeRoutineId.getRoutine());
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                if (routineDeleteScope != null) {
                    routineDeleteScope.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (routineDeleteScope != null) {
                        try {
                            routineDeleteScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        boolean bl = false;
                        return bl;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (routineDelete != null) {
                routineDelete.end();
            }
        }
    }

    @Override
    public boolean delete(JobId jobId) {
        final JobId completeJobId = jobId.setProjectId(Strings.isNullOrEmpty(jobId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : jobId.getProject());
        Span jobDelete = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            jobDelete = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.deleteJob").setAllAttributes(completeJobId.getOtelAttributes()).startSpan();
        }
        try {
            boolean bl = BigQueryRetryHelper.runWithRetries(new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    return BigQueryImpl.this.bigQueryRpc.deleteJobSkipExceptionTranslation(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation());
                }
            }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
            return bl;
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
        finally {
            if (jobDelete != null) {
                jobDelete.end();
            }
        }
    }

    @Override
    public Dataset update(DatasetInfo datasetInfo, BigQuery.DatasetOption ... options) {
        final com.google.api.services.bigquery.model.Dataset datasetPb = datasetInfo.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed datasetUpdate = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            datasetUpdate = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.updateDataset").setAllAttributes(datasetInfo.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope datasetUpdateScope = datasetUpdate != null ? datasetUpdate.makeCurrent() : null;
            try {
                Dataset dataset = Dataset.fromPb(this, BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Dataset>(){

                    @Override
                    public com.google.api.services.bigquery.model.Dataset call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.patchSkipExceptionTranslation(datasetPb, optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                if (datasetUpdateScope != null) {
                    datasetUpdateScope.close();
                }
                return dataset;
            }
            catch (Throwable throwable) {
                try {
                    if (datasetUpdateScope != null) {
                        try {
                            datasetUpdateScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (datasetUpdate != null) {
                datasetUpdate.end();
            }
        }
    }

    @Override
    public Table update(TableInfo tableInfo, BigQuery.TableOption ... options) {
        final com.google.api.services.bigquery.model.Table tablePb = tableInfo.setProjectId(Strings.isNullOrEmpty(tableInfo.getTableId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableInfo.getTableId().getProject()).toPb();
        this.handleExternalTableSchema(tablePb);
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed tableUpdate = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            tableUpdate = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.updateTable").setAllAttributes(tableInfo.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope tableUpdateScope = tableUpdate != null ? tableUpdate.makeCurrent() : null;
            try {
                Table table = Table.fromPb(this, BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Table>(){

                    @Override
                    public com.google.api.services.bigquery.model.Table call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.patchSkipExceptionTranslation(tablePb, optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                if (tableUpdateScope != null) {
                    tableUpdateScope.close();
                }
                return table;
            }
            catch (Throwable throwable) {
                try {
                    if (tableUpdateScope != null) {
                        try {
                            tableUpdateScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (tableUpdate != null) {
                tableUpdate.end();
            }
        }
    }

    @Override
    public Model update(ModelInfo modelInfo, BigQuery.ModelOption ... options) {
        final com.google.api.services.bigquery.model.Model modelPb = modelInfo.setProjectId(Strings.isNullOrEmpty(modelInfo.getModelId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : modelInfo.getModelId().getProject()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed modelUpdate = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            modelUpdate = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.updateModel").setAllAttributes(modelInfo.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope modelUpdateScope = modelUpdate != null ? modelUpdate.makeCurrent() : null;
            try {
                Model model = Model.fromPb(this, BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Model>(){

                    @Override
                    public com.google.api.services.bigquery.model.Model call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.patchSkipExceptionTranslation(modelPb, optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                if (modelUpdateScope != null) {
                    modelUpdateScope.close();
                }
                return model;
            }
            catch (Throwable throwable) {
                try {
                    if (modelUpdateScope != null) {
                        try {
                            modelUpdateScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (modelUpdate != null) {
                modelUpdate.end();
            }
        }
    }

    @Override
    public Routine update(RoutineInfo routineInfo, BigQuery.RoutineOption ... options) {
        final com.google.api.services.bigquery.model.Routine routinePb = routineInfo.setProjectId(Strings.isNullOrEmpty(routineInfo.getRoutineId().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : routineInfo.getRoutineId().getProject()).toPb();
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed routineUpdate = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            routineUpdate = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.updateRoutine").setAllAttributes(routineInfo.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope routineUpdateScope = routineUpdate != null ? routineUpdate.makeCurrent() : null;
            try {
                Routine routine = Routine.fromPb(this, BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Routine>(){

                    @Override
                    public com.google.api.services.bigquery.model.Routine call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.updateSkipExceptionTranslation(routinePb, optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                if (routineUpdateScope != null) {
                    routineUpdateScope.close();
                }
                return routine;
            }
            catch (Throwable throwable) {
                try {
                    if (routineUpdateScope != null) {
                        try {
                            routineUpdateScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (routineUpdate != null) {
                routineUpdate.end();
            }
        }
    }

    @Override
    public Table getTable(String datasetId, String tableId, BigQuery.TableOption ... options) {
        return this.getTable(TableId.of(datasetId, tableId), options);
    }

    @Override
    public Table getTable(TableId tableId, BigQuery.TableOption ... options) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty(tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed tableGet = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            tableGet = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.getTable").setAllAttributes(tableId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope tableGetScope = tableGet != null ? tableGet.makeCurrent() : null;
            try {
                com.google.api.services.bigquery.model.Table answer = BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Table>(){

                    @Override
                    public com.google.api.services.bigquery.model.Table call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.getTableSkipExceptionTranslation(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable(), optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                Table table = Table.fromPb(this, answer);
                if (tableGetScope != null) {
                    tableGetScope.close();
                }
                return table;
            }
            catch (Throwable throwable) {
                try {
                    if (tableGetScope != null) {
                        try {
                            tableGetScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        if (((BigQueryOptions)this.getOptions()).getThrowNotFound()) {
                            throw new BigQueryException(404, "Table not found");
                        }
                        Table table = null;
                        return table;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (tableGet != null) {
                tableGet.end();
            }
        }
    }

    @Override
    public Model getModel(String datasetId, String modelId, BigQuery.ModelOption ... options) {
        return this.getModel(ModelId.of(datasetId, modelId), options);
    }

    @Override
    public Model getModel(ModelId modelId, BigQuery.ModelOption ... options) {
        final ModelId completeModelId = modelId.setProjectId(Strings.isNullOrEmpty(modelId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : modelId.getProject());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed modelGet = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            modelGet = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.getModel").setAllAttributes(modelId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope modelGetScope = modelGet != null ? modelGet.makeCurrent() : null;
            try {
                com.google.api.services.bigquery.model.Model answer = BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Model>(){

                    @Override
                    public com.google.api.services.bigquery.model.Model call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.getModelSkipExceptionTranslation(completeModelId.getProject(), completeModelId.getDataset(), completeModelId.getModel(), optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                Model model = Model.fromPb(this, answer);
                if (modelGetScope != null) {
                    modelGetScope.close();
                }
                return model;
            }
            catch (Throwable throwable) {
                try {
                    if (modelGetScope != null) {
                        try {
                            modelGetScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        if (((BigQueryOptions)this.getOptions()).getThrowNotFound()) {
                            throw new BigQueryException(404, "Model not found");
                        }
                        Model model = null;
                        return model;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (modelGet != null) {
                modelGet.end();
            }
        }
    }

    @Override
    public Routine getRoutine(String datasetId, String routineId, BigQuery.RoutineOption ... options) {
        return this.getRoutine(RoutineId.of(datasetId, routineId), options);
    }

    @Override
    public Routine getRoutine(RoutineId routineId, BigQuery.RoutineOption ... options) {
        final RoutineId completeRoutineId = routineId.setProjectId(Strings.isNullOrEmpty(routineId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : routineId.getProject());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed routineGet = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            routineGet = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.getRoutine").setAllAttributes(routineId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope routineGetScope = routineGet != null ? routineGet.makeCurrent() : null;
            try {
                com.google.api.services.bigquery.model.Routine answer = BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Routine>(){

                    @Override
                    public com.google.api.services.bigquery.model.Routine call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.getRoutineSkipExceptionTranslation(completeRoutineId.getProject(), completeRoutineId.getDataset(), completeRoutineId.getRoutine(), optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                Routine routine = Routine.fromPb(this, answer);
                if (routineGetScope != null) {
                    routineGetScope.close();
                }
                return routine;
            }
            catch (Throwable throwable) {
                try {
                    if (routineGetScope != null) {
                        try {
                            routineGetScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        if (((BigQueryOptions)this.getOptions()).getThrowNotFound()) {
                            throw new BigQueryException(404, "Routine not found");
                        }
                        Routine routine = null;
                        return routine;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (routineGet != null) {
                routineGet.end();
            }
        }
    }

    @Override
    public Page<Table> listTables(String datasetId, BigQuery.TableListOption ... options) {
        ImplicitContextKeyed tablesList = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            tablesList = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listTables").setAllAttributes(DatasetId.of(datasetId).getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope tablesListScope = tablesList != null ? tablesList.makeCurrent() : null;
            try {
                Page<Table> page = BigQueryImpl.listTables(DatasetId.of(((BigQueryOptions)this.getOptions()).getProjectId(), datasetId), (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
                if (tablesListScope != null) {
                    tablesListScope.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                if (tablesListScope != null) {
                    try {
                        tablesListScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (tablesList != null) {
                tablesList.end();
            }
        }
    }

    @Override
    public Page<Table> listTables(DatasetId datasetId, BigQuery.TableListOption ... options) {
        DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        ImplicitContextKeyed tablesList = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            tablesList = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listTables").setAllAttributes(completeDatasetId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope tablesListScope = tablesList != null ? tablesList.makeCurrent() : null;
            try {
                Page<Table> page = BigQueryImpl.listTables(completeDatasetId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
                if (tablesListScope != null) {
                    tablesListScope.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                if (tablesListScope != null) {
                    try {
                        tablesListScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (tablesList != null) {
                tablesList.end();
            }
        }
    }

    @Override
    public Page<Model> listModels(String datasetId, BigQuery.ModelListOption ... options) {
        ImplicitContextKeyed modelsList = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            modelsList = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listModels").setAllAttributes(DatasetId.of(datasetId).getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope modelsListScope = modelsList != null ? modelsList.makeCurrent() : null;
            try {
                Page<Model> page = BigQueryImpl.listModels(DatasetId.of(((BigQueryOptions)this.getOptions()).getProjectId(), datasetId), (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
                if (modelsListScope != null) {
                    modelsListScope.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                if (modelsListScope != null) {
                    try {
                        modelsListScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (modelsList != null) {
                modelsList.end();
            }
        }
    }

    @Override
    public Page<Model> listModels(DatasetId datasetId, BigQuery.ModelListOption ... options) {
        DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        ImplicitContextKeyed modelsList = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            modelsList = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listModels").setAllAttributes(datasetId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope modelsListScope = modelsList != null ? modelsList.makeCurrent() : null;
            try {
                Page<Model> page = BigQueryImpl.listModels(completeDatasetId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
                if (modelsListScope != null) {
                    modelsListScope.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                if (modelsListScope != null) {
                    try {
                        modelsListScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (modelsList != null) {
                modelsList.end();
            }
        }
    }

    @Override
    public Page<Routine> listRoutines(String datasetId, BigQuery.RoutineListOption ... options) {
        ImplicitContextKeyed routinesList = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            routinesList = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listRoutines").setAllAttributes(DatasetId.of(datasetId).getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope routinesListScope = routinesList != null ? routinesList.makeCurrent() : null;
            try {
                Page<Routine> page = BigQueryImpl.listRoutines(DatasetId.of(((BigQueryOptions)this.getOptions()).getProjectId(), datasetId), (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
                if (routinesListScope != null) {
                    routinesListScope.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                if (routinesListScope != null) {
                    try {
                        routinesListScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (routinesList != null) {
                routinesList.end();
            }
        }
    }

    @Override
    public Page<Routine> listRoutines(DatasetId datasetId, BigQuery.RoutineListOption ... options) {
        DatasetId completeDatasetId = datasetId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId());
        ImplicitContextKeyed routinesList = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            routinesList = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listRoutines").setAllAttributes(datasetId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope routinesListScope = routinesList != null ? routinesList.makeCurrent() : null;
            try {
                Page<Routine> page = BigQueryImpl.listRoutines(completeDatasetId, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
                if (routinesListScope != null) {
                    routinesListScope.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                if (routinesListScope != null) {
                    try {
                        routinesListScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (routinesList != null) {
                routinesList.end();
            }
        }
    }

    @Override
    public List<String> listPartitions(TableId tableId) {
        ImplicitContextKeyed listPartitions = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            listPartitions = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listPartitions").setAllAttributes(tableId.getOtelAttributes()).startSpan();
        }
        try {
            Scope listPartitionsScope = listPartitions != null ? listPartitions.makeCurrent() : null;
            try {
                ArrayList<String> partitions = new ArrayList<String>();
                String partitionsTable = tableId.getTable() + "$__PARTITIONS_SUMMARY__";
                TableId metaTableId = tableId.getProject() == null ? TableId.of(tableId.getDataset(), partitionsTable) : TableId.of(tableId.getProject(), tableId.getDataset(), partitionsTable);
                Table metaTable = this.getTable(metaTableId, new BigQuery.TableOption[0]);
                Schema metaSchema = ((TableDefinition)metaTable.getDefinition()).getSchema();
                String partition_id = null;
                for (Field field : metaSchema.getFields()) {
                    if (!field.getName().equals("partition_id")) continue;
                    partition_id = field.getName();
                    break;
                }
                TableResult result = metaTable.list(metaSchema, new BigQuery.TableDataListOption[0]);
                for (FieldValueList list : result.iterateAll()) {
                    partitions.add(list.get(partition_id).getStringValue());
                }
                ArrayList<String> arrayList = partitions;
                if (listPartitionsScope != null) {
                    listPartitionsScope.close();
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                if (listPartitionsScope != null) {
                    try {
                        listPartitionsScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (listPartitions != null) {
                listPartitions.end();
            }
        }
    }

    private static Page<Table> listTables(final DatasetId datasetId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple<String, Iterable<com.google.api.services.bigquery.model.Table>> result = BigQueryRetryHelper.runWithRetries(new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Table>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Table>> call() throws IOException {
                    return serviceOptions.getBigQueryRpcV2().listTablesSkipExceptionTranslation(datasetId.getProject(), datasetId.getDataset(), optionsMap);
                }
            }, serviceOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, serviceOptions.getClock(), EMPTY_RETRY_CONFIG, serviceOptions.isOpenTelemetryTracingEnabled(), serviceOptions.getOpenTelemetryTracer());
            String cursor = result.x();
            Iterable<Table> tables = Iterables.transform(result.y(), new Function<com.google.api.services.bigquery.model.Table, Table>(){

                @Override
                public Table apply(com.google.api.services.bigquery.model.Table table) {
                    return Table.fromPb((BigQuery)serviceOptions.getService(), table);
                }
            });
            return new PageImpl<Table>(new TablePageFetcher(datasetId, serviceOptions, cursor, optionsMap), cursor, tables);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static Page<Model> listModels(final DatasetId datasetId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple<String, Iterable<com.google.api.services.bigquery.model.Model>> result = BigQueryRetryHelper.runWithRetries(new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Model>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Model>> call() throws IOException {
                    return serviceOptions.getBigQueryRpcV2().listModelsSkipExceptionTranslation(datasetId.getProject(), datasetId.getDataset(), optionsMap);
                }
            }, serviceOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, serviceOptions.getClock(), EMPTY_RETRY_CONFIG, serviceOptions.isOpenTelemetryTracingEnabled(), serviceOptions.getOpenTelemetryTracer());
            String cursor = result.x();
            Iterable<Model> models = Iterables.transform(result.y(), new Function<com.google.api.services.bigquery.model.Model, Model>(){

                @Override
                public Model apply(com.google.api.services.bigquery.model.Model model) {
                    return Model.fromPb((BigQuery)serviceOptions.getService(), model);
                }
            });
            return new PageImpl<Model>(new ModelPageFetcher(datasetId, serviceOptions, cursor, optionsMap), cursor, models);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static Page<Routine> listRoutines(final DatasetId datasetId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple<String, Iterable<com.google.api.services.bigquery.model.Routine>> result = BigQueryRetryHelper.runWithRetries(new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Routine>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Routine>> call() throws IOException {
                    return serviceOptions.getBigQueryRpcV2().listRoutinesSkipExceptionTranslation(datasetId.getProject(), datasetId.getDataset(), optionsMap);
                }
            }, serviceOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, serviceOptions.getClock(), EMPTY_RETRY_CONFIG, serviceOptions.isOpenTelemetryTracingEnabled(), serviceOptions.getOpenTelemetryTracer());
            String cursor = result.x();
            Iterable<Routine> routines = Iterables.transform(result.y(), new Function<com.google.api.services.bigquery.model.Routine, Routine>(){

                @Override
                public Routine apply(com.google.api.services.bigquery.model.Routine routinePb) {
                    return Routine.fromPb((BigQuery)serviceOptions.getService(), routinePb);
                }
            });
            return new PageImpl<Routine>(new RoutinePageFetcher(datasetId, serviceOptions, cursor, optionsMap), cursor, routines);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public InsertAllResponse insertAll(InsertAllRequest request) {
        final TableId tableId = request.getTable().setProjectId(Strings.isNullOrEmpty(request.getTable().getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : request.getTable().getProject());
        final TableDataInsertAllRequest requestPb = new TableDataInsertAllRequest();
        requestPb.setIgnoreUnknownValues(request.ignoreUnknownValues());
        requestPb.setSkipInvalidRows(request.skipInvalidRows());
        requestPb.setTemplateSuffix(request.getTemplateSuffix());
        final boolean[] allInsertIdsSet = new boolean[]{true};
        ImmutableList<TableDataInsertAllRequest.Rows> rowsPb = FluentIterable.from(request.getRows()).transform(new Function<InsertAllRequest.RowToInsert, TableDataInsertAllRequest.Rows>(){

            @Override
            public TableDataInsertAllRequest.Rows apply(InsertAllRequest.RowToInsert rowToInsert) {
                allInsertIdsSet[0] = allInsertIdsSet[0] & rowToInsert.getId() != null;
                return new TableDataInsertAllRequest.Rows().setInsertId(rowToInsert.getId()).setJson(rowToInsert.getContent());
            }
        }).toList();
        requestPb.setRows(rowsPb);
        ImplicitContextKeyed insertAll = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            insertAll = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.insertAll").setAllAttributes(request.getOtelAttributes()).startSpan();
        }
        try {
            Scope insertAllScope = insertAll != null ? insertAll.makeCurrent() : null;
            try {
                TableDataInsertAllResponse responsePb;
                if (allInsertIdsSet[0]) {
                    try {
                        responsePb = BigQueryRetryHelper.runWithRetries(new Callable<TableDataInsertAllResponse>(){

                            @Override
                            public TableDataInsertAllResponse call() throws Exception {
                                return BigQueryImpl.this.bigQueryRpc.insertAllSkipExceptionTranslation(tableId.getProject(), tableId.getDataset(), tableId.getTable(), requestPb);
                            }
                        }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                    }
                    catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                        throw BigQueryException.translateAndThrow(e);
                    }
                } else {
                    responsePb = this.bigQueryRpc.insertAll(tableId.getProject(), tableId.getDataset(), tableId.getTable(), requestPb);
                }
                InsertAllResponse insertAllResponse = InsertAllResponse.fromPb(responsePb);
                if (insertAllScope != null) {
                    insertAllScope.close();
                }
                return insertAllResponse;
            }
            catch (Throwable throwable) {
                if (insertAllScope != null) {
                    try {
                        insertAllScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (insertAll != null) {
                insertAll.end();
            }
        }
    }

    @Override
    public TableResult listTableData(String datasetId, String tableId, BigQuery.TableDataListOption ... options) {
        return this.listTableData(TableId.of(datasetId, tableId), options);
    }

    @Override
    public TableResult listTableData(TableId tableId, BigQuery.TableDataListOption ... options) {
        return this.listTableData(tableId, (Schema)null, options);
    }

    @Override
    public TableResult listTableData(String datasetId, String tableId, Schema schema, BigQuery.TableDataListOption ... options) {
        return this.listTableData(TableId.of(datasetId, tableId), schema, options);
    }

    @Override
    public TableResult listTableData(TableId tableId, Schema schema, BigQuery.TableDataListOption ... options) {
        Tuple<? extends Page<FieldValueList>, Long> data = BigQueryImpl.listTableData(tableId, schema, (BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
        ImplicitContextKeyed tableDataList = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            tableDataList = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listTableData").setAllAttributes(tableId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope tableDataListScope = tableDataList != null ? tableDataList.makeCurrent() : null;
            try {
                TableResult tableResult = TableResult.newBuilder().setSchema(schema).setTotalRows(data.y()).setPageNoSchema(data.x()).build();
                if (tableDataListScope != null) {
                    tableDataListScope.close();
                }
                return tableResult;
            }
            catch (Throwable throwable) {
                if (tableDataListScope != null) {
                    try {
                        tableDataListScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (tableDataList != null) {
                tableDataList.end();
            }
        }
    }

    private static Tuple<? extends Page<FieldValueList>, Long> listTableData(TableId tableId, Schema schema, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty(tableId.getProject()) ? serviceOptions.getProjectId() : tableId.getProject());
            TableDataList result = BigQueryRetryHelper.runWithRetries(new Callable<TableDataList>(){

                @Override
                public TableDataList call() throws IOException {
                    return serviceOptions.getBigQueryRpcV2().listTableDataSkipExceptionTranslation(completeTableId.getProject(), completeTableId.getDataset(), completeTableId.getTable(), optionsMap);
                }
            }, serviceOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, serviceOptions.getClock(), EMPTY_RETRY_CONFIG, serviceOptions.isOpenTelemetryTracingEnabled(), serviceOptions.getOpenTelemetryTracer());
            String cursor = result.getPageToken();
            Map<BigQueryRpc.Option, ?> pageOptionMap = Strings.isNullOrEmpty(cursor) ? optionsMap : BigQueryImpl.optionMap(BigQuery.TableDataListOption.startIndex(0L));
            return Tuple.of(new PageImpl<FieldValueList>(new TableDataPageFetcher(tableId, schema, serviceOptions, cursor, pageOptionMap), cursor, BigQueryImpl.transformTableData(result.getRows(), schema, serviceOptions.getUseInt64Timestamps())), result.getTotalRows());
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    private static Iterable<FieldValueList> transformTableData(Iterable<TableRow> tableDataPb, final Schema schema, final boolean useInt64Timestamps) {
        return ImmutableList.copyOf(Iterables.transform(tableDataPb != null ? tableDataPb : ImmutableList.of(), new Function<TableRow, FieldValueList>(){
            FieldList fields;
            {
                this.fields = schema != null ? schema.getFields() : null;
            }

            @Override
            public FieldValueList apply(TableRow rowPb) {
                return FieldValueList.fromPb(rowPb.getF(), this.fields, useInt64Timestamps);
            }
        }));
    }

    @Override
    public Job getJob(String jobId, BigQuery.JobOption ... options) {
        return this.getJob(JobId.of(jobId), options);
    }

    @Override
    public Job getJob(JobId jobId, BigQuery.JobOption ... options) {
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        final JobId completeJobId = jobId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).setLocation(jobId.getLocation() == null && ((BigQueryOptions)this.getOptions()).getLocation() != null ? ((BigQueryOptions)this.getOptions()).getLocation() : jobId.getLocation());
        ImplicitContextKeyed jobGet = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            jobGet = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.getJob").setAllAttributes(completeJobId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope jobGetScope = jobGet != null ? jobGet.makeCurrent() : null;
            try {
                com.google.api.services.bigquery.model.Job answer = BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Job>(){

                    @Override
                    public com.google.api.services.bigquery.model.Job call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.getJobSkipExceptionTranslation(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation(), optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                Job job = Job.fromPb(this, answer);
                if (jobGetScope != null) {
                    jobGetScope.close();
                }
                return job;
            }
            catch (Throwable throwable) {
                try {
                    if (jobGetScope != null) {
                        try {
                            jobGetScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        if (((BigQueryOptions)this.getOptions()).getThrowNotFound()) {
                            throw new BigQueryException(404, "Job not found");
                        }
                        Job job = null;
                        return job;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (jobGet != null) {
                jobGet.end();
            }
        }
    }

    @Override
    public Page<Job> listJobs(BigQuery.JobListOption ... options) {
        ImplicitContextKeyed jobsList = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            jobsList = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.listJobs").setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope jobsListScope = jobsList != null ? jobsList.makeCurrent() : null;
            try {
                Page<Job> page = BigQueryImpl.listJobs((BigQueryOptions)this.getOptions(), BigQueryImpl.optionMap(options));
                if (jobsListScope != null) {
                    jobsListScope.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                if (jobsListScope != null) {
                    try {
                        jobsListScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (jobsList != null) {
                jobsList.end();
            }
        }
    }

    private static Page<Job> listJobs(final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        try {
            Tuple<String, Iterable<com.google.api.services.bigquery.model.Job>> result = BigQueryRetryHelper.runWithRetries(new Callable<Tuple<String, Iterable<com.google.api.services.bigquery.model.Job>>>(){

                @Override
                public Tuple<String, Iterable<com.google.api.services.bigquery.model.Job>> call() throws IOException {
                    return serviceOptions.getBigQueryRpcV2().listJobsSkipExceptionTranslation(serviceOptions.getProjectId(), optionsMap);
                }
            }, serviceOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, serviceOptions.getClock(), EMPTY_RETRY_CONFIG, serviceOptions.isOpenTelemetryTracingEnabled(), serviceOptions.getOpenTelemetryTracer());
            String cursor = result.x();
            Iterable<Job> jobs = Iterables.transform(result.y(), new Function<com.google.api.services.bigquery.model.Job, Job>(){

                @Override
                public Job apply(com.google.api.services.bigquery.model.Job job) {
                    return Job.fromPb((BigQuery)serviceOptions.getService(), job);
                }
            });
            return new PageImpl<Job>(new JobPageFetcher(serviceOptions, cursor, optionsMap), cursor, jobs);
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public boolean cancel(String jobId) {
        return this.cancel(JobId.of(jobId));
    }

    @Override
    public boolean cancel(JobId jobId) {
        final JobId completeJobId = jobId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()).setLocation(jobId.getLocation() == null && ((BigQueryOptions)this.getOptions()).getLocation() != null ? ((BigQueryOptions)this.getOptions()).getLocation() : jobId.getLocation());
        ImplicitContextKeyed jobCancel = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            jobCancel = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.cancelJob").setAllAttributes(completeJobId.getOtelAttributes()).startSpan();
        }
        try {
            Scope jobCancelScope = jobCancel != null ? jobCancel.makeCurrent() : null;
            try {
                boolean bl = BigQueryRetryHelper.runWithRetries(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.cancelSkipExceptionTranslation(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation());
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                if (jobCancelScope != null) {
                    jobCancelScope.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (jobCancelScope != null) {
                        try {
                            jobCancelScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    if (BigQueryImpl.isRetryErrorCodeHttpNotFound(e)) {
                        boolean bl = false;
                        return bl;
                    }
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (jobCancel != null) {
                jobCancel.end();
            }
        }
    }

    @Override
    public TableResult query(QueryJobConfiguration configuration, BigQuery.JobOption ... options) throws InterruptedException, JobException {
        Job.checkNotDryRun(configuration, "query");
        configuration = configuration.toBuilder().setJobCreationMode(((BigQueryOptions)this.getOptions()).getDefaultJobCreationMode()).build();
        ImplicitContextKeyed querySpan = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            querySpan = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.query").setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope queryScope;
            block16: {
                queryScope = querySpan != null ? querySpan.makeCurrent() : null;
                try {
                    QueryRequestInfo requestInfo = new QueryRequestInfo(configuration, ((BigQueryOptions)this.getOptions()).getUseInt64Timestamps());
                    if (!requestInfo.isFastQuerySupported(null)) break block16;
                    String projectId = ((BigQueryOptions)this.getOptions()).getProjectId();
                    QueryRequest content = requestInfo.toPb();
                    if (((BigQueryOptions)this.getOptions()).getLocation() != null) {
                        content.setLocation(((BigQueryOptions)this.getOptions()).getLocation());
                    }
                    TableResult tableResult = this.queryRpc(projectId, content, options);
                    if (queryScope != null) {
                        queryScope.close();
                    }
                    return tableResult;
                }
                catch (Throwable throwable) {
                    if (queryScope != null) {
                        try {
                            queryScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            TableResult tableResult = this.create(JobInfo.of(configuration), options).getQueryResults(new BigQuery.QueryResultsOption[0]);
            if (queryScope != null) {
                queryScope.close();
            }
            return tableResult;
        }
        finally {
            if (querySpan != null) {
                querySpan.end();
            }
        }
    }

    private TableResult queryRpc(final String projectId, final QueryRequest content, BigQuery.JobOption ... options) throws InterruptedException {
        long numRows;
        Schema schema;
        com.google.api.services.bigquery.model.QueryResponse results;
        ImplicitContextKeyed queryRpc = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            queryRpc = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.queryRpc").setAttribute("bq.query.project_id", projectId).setAllAttributes(BigQueryImpl.otelAttributesFromQueryRequest(content)).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try (Scope queryRpcScope = queryRpc != null ? queryRpc.makeCurrent() : null;){
            results = BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.QueryResponse>(){

                @Override
                public com.google.api.services.bigquery.model.QueryResponse call() throws IOException {
                    return BigQueryImpl.this.bigQueryRpc.queryRpcSkipExceptionTranslation(projectId, content);
                }
            }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), DEFAULT_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
        finally {
            if (queryRpc != null) {
                queryRpc.end();
            }
        }
        if (results.getErrors() != null) {
            List<BigQueryError> bigQueryErrors = Lists.transform(results.getErrors(), BigQueryError.FROM_PB_FUNCTION);
            throw new BigQueryException(bigQueryErrors);
        }
        if (results.getJobComplete().booleanValue() && results.getSchema() != null) {
            schema = Schema.fromPb(results.getSchema());
            numRows = results.getNumDmlAffectedRows() == null && results.getTotalRows() == null ? 0L : (results.getNumDmlAffectedRows() != null ? results.getNumDmlAffectedRows().longValue() : results.getTotalRows().longValue());
        } else {
            JobId jobId = JobId.fromPb(results.getJobReference());
            Job job = this.getJob(jobId, options);
            return job.getQueryResults(new BigQuery.QueryResultsOption[0]);
        }
        if (results.getPageToken() != null) {
            JobId jobId = JobId.fromPb(results.getJobReference());
            String cursor = results.getPageToken();
            return TableResult.newBuilder().setSchema(schema).setTotalRows(numRows).setPageNoSchema(new PageImpl<FieldValueList>(new QueryPageFetcher(jobId, schema, (BigQueryOptions)this.getOptions(), cursor, BigQueryImpl.optionMap(options)), cursor, BigQueryImpl.transformTableData(results.getRows(), schema, ((BigQueryOptions)this.getOptions()).getUseInt64Timestamps()))).setJobId(jobId).setQueryId(results.getQueryId()).build();
        }
        return TableResult.newBuilder().setSchema(schema).setTotalRows(numRows).setPageNoSchema(new PageImpl<FieldValueList>(new TableDataPageFetcher(null, schema, (BigQueryOptions)this.getOptions(), null, BigQueryImpl.optionMap(options)), null, BigQueryImpl.transformTableData(results.getRows(), schema, ((BigQueryOptions)this.getOptions()).getUseInt64Timestamps()))).setJobId(results.getJobReference() != null ? JobId.fromPb(results.getJobReference()) : null).setQueryId(results.getQueryId()).build();
    }

    @Override
    public TableResult query(QueryJobConfiguration configuration, JobId jobId, BigQuery.JobOption ... options) throws InterruptedException, JobException {
        Job.checkNotDryRun(configuration, "query");
        ImplicitContextKeyed querySpan = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            querySpan = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.query").setAllAttributes(jobId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope queryScope;
            block18: {
                queryScope = querySpan != null ? querySpan.makeCurrent() : null;
                try {
                    QueryRequestInfo requestInfo = new QueryRequestInfo(configuration, ((BigQueryOptions)this.getOptions()).getUseInt64Timestamps());
                    if (!requestInfo.isFastQuerySupported(jobId)) break block18;
                    String projectId = jobId.getProject() != null ? jobId.getProject() : ((BigQueryOptions)this.getOptions()).getProjectId();
                    QueryRequest content = requestInfo.toPb();
                    if (jobId.getLocation() != null) {
                        content.setLocation(jobId.getLocation());
                    } else if (((BigQueryOptions)this.getOptions()).getLocation() != null) {
                        content.setLocation(((BigQueryOptions)this.getOptions()).getLocation());
                    }
                    TableResult tableResult = this.queryRpc(projectId, content, options);
                    if (queryScope != null) {
                        queryScope.close();
                    }
                    return tableResult;
                }
                catch (Throwable throwable) {
                    if (queryScope != null) {
                        try {
                            queryScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            TableResult tableResult = this.create(JobInfo.of(jobId, configuration), options).getQueryResults(new BigQuery.QueryResultsOption[0]);
            if (queryScope != null) {
                queryScope.close();
            }
            return tableResult;
        }
        finally {
            if (querySpan != null) {
                querySpan.end();
            }
        }
    }

    @Override
    public QueryResponse getQueryResults(JobId jobId, BigQuery.QueryResultsOption ... options) {
        Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed getQueryResults = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            getQueryResults = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.getQueryResults").setAllAttributes(jobId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope getQueryResultsScope = getQueryResults != null ? getQueryResults.makeCurrent() : null;
            try {
                QueryResponse queryResponse = BigQueryImpl.getQueryResults(jobId, (BigQueryOptions)this.getOptions(), optionsMap);
                if (getQueryResultsScope != null) {
                    getQueryResultsScope.close();
                }
                return queryResponse;
            }
            catch (Throwable throwable) {
                if (getQueryResultsScope != null) {
                    try {
                        getQueryResultsScope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (getQueryResults != null) {
                getQueryResults.end();
            }
        }
    }

    private static QueryResponse getQueryResults(JobId jobId, final BigQueryOptions serviceOptions, final Map<BigQueryRpc.Option, ?> optionsMap) {
        final JobId completeJobId = jobId.setProjectId(serviceOptions.getProjectId()).setLocation(jobId.getLocation() == null && serviceOptions.getLocation() != null ? serviceOptions.getLocation() : jobId.getLocation());
        try {
            GetQueryResultsResponse results = BigQueryRetryHelper.runWithRetries(new Callable<GetQueryResultsResponse>(){

                @Override
                public GetQueryResultsResponse call() throws IOException {
                    return serviceOptions.getBigQueryRpcV2().getQueryResultsSkipExceptionTranslation(completeJobId.getProject(), completeJobId.getJob(), completeJobId.getLocation(), optionsMap);
                }
            }, serviceOptions.getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, serviceOptions.getClock(), DEFAULT_RETRY_CONFIG, serviceOptions.isOpenTelemetryTracingEnabled(), serviceOptions.getOpenTelemetryTracer());
            TableSchema schemaPb = results.getSchema();
            ImmutableList.Builder errors = ImmutableList.builder();
            if (results.getErrors() != null) {
                for (ErrorProto error : results.getErrors()) {
                    errors.add(BigQueryError.fromPb(error));
                }
            }
            return QueryResponse.newBuilder().setCompleted(results.getJobComplete()).setSchema(schemaPb == null ? null : Schema.fromPb(schemaPb)).setTotalRows(results.getTotalRows() == null ? 0L : results.getTotalRows().longValue()).setErrors((ImmutableList<BigQueryError>)errors.build()).build();
        }
        catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
            throw BigQueryException.translateAndThrow(e);
        }
    }

    @Override
    public TableDataWriteChannel writer(WriteChannelConfiguration writeChannelConfiguration) {
        return this.writer(JobId.of(), writeChannelConfiguration);
    }

    @Override
    public TableDataWriteChannel writer(JobId jobId, WriteChannelConfiguration writeChannelConfiguration) {
        return new TableDataWriteChannel((BigQueryOptions)this.getOptions(), jobId.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()), writeChannelConfiguration.setProjectId(((BigQueryOptions)this.getOptions()).getProjectId()));
    }

    @Override
    public Policy getIamPolicy(TableId tableId, BigQuery.IAMOption ... options) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty(tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed iamPolicyGet = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            iamPolicyGet = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.getIamPolicy").setAllAttributes(tableId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope iamPolicyGetScope = iamPolicyGet != null ? iamPolicyGet.makeCurrent() : null;
            try {
                Policy policy = PolicyHelper.convertFromApiPolicy(BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Policy>(){

                    @Override
                    public com.google.api.services.bigquery.model.Policy call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.getIamPolicySkipExceptionTranslation(completeTableId.getIAMResourceName(), optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                if (iamPolicyGetScope != null) {
                    iamPolicyGetScope.close();
                }
                return policy;
            }
            catch (Throwable throwable) {
                try {
                    if (iamPolicyGetScope != null) {
                        try {
                            iamPolicyGetScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (iamPolicyGet != null) {
                iamPolicyGet.end();
            }
        }
    }

    @Override
    public Policy setIamPolicy(TableId tableId, final Policy policy, BigQuery.IAMOption ... options) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty(tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed iamPolicySet = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            iamPolicySet = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.setIamPolicy").setAllAttributes(tableId.getOtelAttributes()).setAllAttributes(BigQueryImpl.otelAttributesFromPolicy(policy)).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope iamPolicySetScope = iamPolicySet != null ? iamPolicySet.makeCurrent() : null;
            try {
                Policy policy2 = PolicyHelper.convertFromApiPolicy(BigQueryRetryHelper.runWithRetries(new Callable<com.google.api.services.bigquery.model.Policy>(){

                    @Override
                    public com.google.api.services.bigquery.model.Policy call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.setIamPolicySkipExceptionTranslation(completeTableId.getIAMResourceName(), PolicyHelper.convertToApiPolicy(policy), optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer()));
                if (iamPolicySetScope != null) {
                    iamPolicySetScope.close();
                }
                return policy2;
            }
            catch (Throwable throwable) {
                try {
                    if (iamPolicySetScope != null) {
                        try {
                            iamPolicySetScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (iamPolicySet != null) {
                iamPolicySet.end();
            }
        }
    }

    @Override
    public List<String> testIamPermissions(TableId tableId, final List<String> permissions, BigQuery.IAMOption ... options) {
        final TableId completeTableId = tableId.setProjectId(Strings.isNullOrEmpty(tableId.getProject()) ? ((BigQueryOptions)this.getOptions()).getProjectId() : tableId.getProject());
        final Map<BigQueryRpc.Option, ?> optionsMap = BigQueryImpl.optionMap(options);
        ImplicitContextKeyed testIamPermissions = null;
        if (((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled() && ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer() != null) {
            testIamPermissions = ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQuery.testIamPermissions").setAllAttributes(tableId.getOtelAttributes()).setAttribute("bq.iam.permissions", permissions.toString()).setAllAttributes(BigQueryImpl.otelAttributesFromOptions(options)).startSpan();
        }
        try {
            Scope testIamPermissionsScope = testIamPermissions != null ? testIamPermissions.makeCurrent() : null;
            try {
                ImmutableList<String> immutableList;
                TestIamPermissionsResponse response = BigQueryRetryHelper.runWithRetries(new Callable<TestIamPermissionsResponse>(){

                    @Override
                    public TestIamPermissionsResponse call() throws IOException {
                        return BigQueryImpl.this.bigQueryRpc.testIamPermissionsSkipExceptionTranslation(completeTableId.getIAMResourceName(), permissions, optionsMap);
                    }
                }, ((BigQueryOptions)this.getOptions()).getRetrySettings(), BigQueryBaseService.BIGQUERY_EXCEPTION_HANDLER, ((BigQueryOptions)this.getOptions()).getClock(), EMPTY_RETRY_CONFIG, ((BigQueryOptions)this.getOptions()).isOpenTelemetryTracingEnabled(), ((BigQueryOptions)this.getOptions()).getOpenTelemetryTracer());
                ImmutableList<String> immutableList2 = immutableList = response.getPermissions() == null ? ImmutableList.of() : ImmutableList.copyOf(response.getPermissions());
                if (testIamPermissionsScope != null) {
                    testIamPermissionsScope.close();
                }
                return immutableList;
            }
            catch (Throwable throwable) {
                try {
                    if (testIamPermissionsScope != null) {
                        try {
                            testIamPermissionsScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (BigQueryRetryHelper.BigQueryRetryHelperException e) {
                    throw BigQueryException.translateAndThrow(e);
                }
            }
        }
        finally {
            if (testIamPermissions != null) {
                testIamPermissions.end();
            }
        }
    }

    @VisibleForTesting
    static Map<BigQueryRpc.Option, ?> optionMap(Option ... options) {
        EnumMap<BigQueryRpc.Option, Object> optionMap = Maps.newEnumMap(BigQueryRpc.Option.class);
        for (Option option : options) {
            Object prev = optionMap.put(option.getRpcOption(), option.getValue());
            Preconditions.checkArgument(prev == null, "Duplicate option %s", (Object)option);
        }
        return optionMap;
    }

    private static String getFieldAsString(Object field) {
        return field == null ? "null" : field.toString();
    }

    private static Attributes otelAttributesFromOptions(Option ... options) {
        Attributes attributes = Attributes.builder().build();
        for (Option option : options) {
            attributes = attributes.toBuilder().put("bq.option." + option.getRpcOption().toString(), option.getValue().toString()).build();
        }
        return attributes;
    }

    private static Attributes otelAttributesFromQueryRequest(QueryRequest request) {
        return Attributes.builder().put("bq.query.dry_run", BigQueryImpl.getFieldAsString(request.getDryRun())).put("bq.query.job_creation_mode", BigQueryImpl.getFieldAsString(request.getJobCreationMode())).put("bq.query.kind", BigQueryImpl.getFieldAsString(request.getKind())).put("bq.query.location", BigQueryImpl.getFieldAsString(request.getLocation())).put("bq.query.request_id", BigQueryImpl.getFieldAsString(request.getRequestId())).put("bq.query.use_query_cache", BigQueryImpl.getFieldAsString(request.getUseQueryCache())).build();
    }

    private static Attributes otelAttributesFromPolicy(Policy policy) {
        return Attributes.builder().put("bq.policy.version", BigQueryImpl.getFieldAsString(policy.getVersion())).put("bq.policy.bindings", BigQueryImpl.getFieldAsString(policy.getBindings())).build();
    }

    static BigQueryRetryConfig getBigQueryRetryConfig(Map<BigQueryRpc.Option, ?> options) {
        return options.getOrDefault((Object)BigQueryRpc.Option.BIGQUERY_RETRY_CONFIG, null);
    }

    static RetryOption[] getRetryOptions(Map<BigQueryRpc.Option, ?> options) {
        return options.getOrDefault((Object)BigQueryRpc.Option.RETRY_OPTIONS, null);
    }

    private static boolean isRetryErrorCodeHttpNotFound(BigQueryRetryHelper.BigQueryRetryHelperException e) {
        return e.getCause() instanceof BigQueryException && ((BigQueryException)e.getCause()).getCode() == 404;
    }

    private static class DatasetPageFetcher
    implements PageImpl.NextPageFetcher<Dataset> {
        private static final long serialVersionUID = -3057564042439021278L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final String projectId;

        DatasetPageFetcher(String projectId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.projectId = projectId;
            this.requestOptions = PageImpl.nextRequestOptions(BigQueryRpc.Option.PAGE_TOKEN, cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        @Override
        public Page<Dataset> getNextPage() {
            return BigQueryImpl.listDatasets(this.projectId, this.serviceOptions, this.requestOptions);
        }
    }

    private static class TablePageFetcher
    implements PageImpl.NextPageFetcher<Table> {
        private static final long serialVersionUID = 8611248840504201187L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final DatasetId datasetId;

        TablePageFetcher(DatasetId datasetId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions(BigQueryRpc.Option.PAGE_TOKEN, cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.datasetId = datasetId;
        }

        @Override
        public Page<Table> getNextPage() {
            return BigQueryImpl.listTables(this.datasetId, this.serviceOptions, this.requestOptions);
        }
    }

    private static class ModelPageFetcher
    implements PageImpl.NextPageFetcher<Model> {
        private static final long serialVersionUID = 8611248811504201187L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final DatasetId datasetId;

        ModelPageFetcher(DatasetId datasetId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions(BigQueryRpc.Option.PAGE_TOKEN, cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.datasetId = datasetId;
        }

        @Override
        public Page<Model> getNextPage() {
            return BigQueryImpl.listModels(this.datasetId, this.serviceOptions, this.requestOptions);
        }
    }

    private static class RoutinePageFetcher
    implements PageImpl.NextPageFetcher<Routine> {
        private static final long serialVersionUID = 8611242311504201187L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final DatasetId datasetId;

        RoutinePageFetcher(DatasetId datasetId, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions(BigQueryRpc.Option.PAGE_TOKEN, cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.datasetId = datasetId;
        }

        @Override
        public Page<Routine> getNextPage() {
            return BigQueryImpl.listRoutines(this.datasetId, this.serviceOptions, this.requestOptions);
        }
    }

    private static class TableDataPageFetcher
    implements PageImpl.NextPageFetcher<FieldValueList> {
        private static final long serialVersionUID = -8501991114794410114L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private final TableId table;
        private final Schema schema;

        TableDataPageFetcher(TableId table, Schema schema, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions(BigQueryRpc.Option.PAGE_TOKEN, cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.table = table;
            this.schema = schema;
        }

        @Override
        public Page<FieldValueList> getNextPage() {
            return (Page)BigQueryImpl.listTableData(this.table, this.schema, this.serviceOptions, this.requestOptions).x();
        }
    }

    private static class JobPageFetcher
    implements PageImpl.NextPageFetcher<Job> {
        private static final long serialVersionUID = 8536533282558245472L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;

        JobPageFetcher(BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions(BigQueryRpc.Option.PAGE_TOKEN, cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        @Override
        public Page<Job> getNextPage() {
            return BigQueryImpl.listJobs(this.serviceOptions, this.requestOptions);
        }
    }

    private class QueryPageFetcher
    extends Thread
    implements PageImpl.NextPageFetcher<FieldValueList> {
        private static final long serialVersionUID = -8501991114794410114L;
        private final Map<BigQueryRpc.Option, ?> requestOptions;
        private final BigQueryOptions serviceOptions;
        private Job job;
        private final TableId table;
        private final Schema schema;

        QueryPageFetcher(JobId jobId, Schema schema, BigQueryOptions serviceOptions, String cursor, Map<BigQueryRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions(BigQueryRpc.Option.PAGE_TOKEN, cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.job = BigQueryImpl.this.getJob(jobId, new BigQuery.JobOption[0]);
            this.table = ((QueryJobConfiguration)this.job.getConfiguration()).getDestinationTable();
            this.schema = schema;
        }

        @Override
        public Page<FieldValueList> getNextPage() {
            while (!JobStatus.State.DONE.equals(this.job.getStatus().getState())) {
                try {
                    QueryPageFetcher.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex.getMessage());
                }
                this.job = this.job.reload(new BigQuery.JobOption[0]);
            }
            return (Page)BigQueryImpl.listTableData(this.table, this.schema, this.serviceOptions, this.requestOptions).x();
        }
    }
}

