/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.mtls;

import com.google.auth.mtls.CertificateSourceUnavailableException;
import com.google.auth.mtls.MtlsProvider;
import com.google.auth.mtls.WorkloadCertificateConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Locale;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Strings;

public class X509Provider
implements MtlsProvider {
    static final String CERTIFICATE_CONFIGURATION_ENV_VARIABLE = "GOOGLE_API_CERTIFICATE_CONFIG";
    static final String WELL_KNOWN_CERTIFICATE_CONFIG_FILE = "certificate_config.json";
    static final String CLOUDSDK_CONFIG_DIRECTORY = "gcloud";
    private final String certConfigPathOverride;

    public X509Provider(String certConfigPathOverride) {
        this.certConfigPathOverride = certConfigPathOverride;
    }

    public X509Provider() {
        this(null);
    }

    public String getCertificatePath() throws IOException {
        String certPath = this.getWorkloadCertificateConfiguration().getCertPath();
        if (Strings.isNullOrEmpty(certPath)) {
            throw new CertificateSourceUnavailableException("Certificate configuration loaded successfully, but does not contain a 'certificate_file' path.");
        }
        return certPath;
    }

    /*
     * Exception decompiling
     */
    @Override
    public KeyStore getKeyStore() throws CertificateSourceUnavailableException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isAvailable() throws IOException {
        try {
            this.getKeyStore();
        }
        catch (CertificateSourceUnavailableException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkloadCertificateConfiguration getWorkloadCertificateConfiguration() throws IOException {
        String envCredentialsPath;
        File certConfig = this.certConfigPathOverride != null ? new File(this.certConfigPathOverride) : (!Strings.isNullOrEmpty(envCredentialsPath = this.getEnv(CERTIFICATE_CONFIGURATION_ENV_VARIABLE)) ? new File(envCredentialsPath) : this.getWellKnownCertificateConfigFile());
        try (InputStream certConfigStream = null;){
            if (!this.isFile(certConfig)) {
                throw new CertificateSourceUnavailableException("File does not exist.");
            }
            certConfigStream = this.createInputStream(certConfig);
            WorkloadCertificateConfiguration workloadCertificateConfiguration = WorkloadCertificateConfiguration.fromCertificateConfigurationStream(certConfigStream);
            return workloadCertificateConfiguration;
        }
    }

    boolean isFile(File file) {
        return file.isFile();
    }

    InputStream createInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    String getEnv(String name) {
        return System.getenv(name);
    }

    String getOsName() {
        return this.getProperty("os.name", "").toLowerCase(Locale.US);
    }

    String getProperty(String property, String def) {
        return System.getProperty(property, def);
    }

    private File getWellKnownCertificateConfigFile() {
        File cloudConfigPath;
        String envPath = this.getEnv("CLOUDSDK_CONFIG");
        if (envPath != null) {
            cloudConfigPath = new File(envPath);
        } else if (this.getOsName().indexOf("windows") >= 0) {
            File appDataPath = new File(this.getEnv("APPDATA"));
            cloudConfigPath = new File(appDataPath, CLOUDSDK_CONFIG_DIRECTORY);
        } else {
            File configPath = new File(this.getProperty("user.home", ""), ".config");
            cloudConfigPath = new File(configPath, CLOUDSDK_CONFIG_DIRECTORY);
        }
        return new File(cloudConfigPath, WELL_KNOWN_CERTIFICATE_CONFIG_FILE);
    }
}

