/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.ApiFuture;
import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.RequestUrlParamsEncoder;
import com.google.api.gax.rpc.UnaryCallable;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;

class HttpJsonUnaryRequestParamCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final RequestUrlParamsEncoder<RequestT> paramsEncoder;

    public HttpJsonUnaryRequestParamCallable(UnaryCallable<RequestT, ResponseT> callable, RequestParamsExtractor<RequestT> paramsExtractor) {
        this.callable = Preconditions.checkNotNull(callable);
        this.paramsEncoder = new RequestUrlParamsEncoder<RequestT>(Preconditions.checkNotNull(paramsExtractor));
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext context) {
        ApiCallContext newCallContext = context;
        String encodedHeader = this.paramsEncoder.encode(request);
        if (!encodedHeader.isEmpty()) {
            newCallContext = HttpJsonCallContext.createDefault().nullToSelf(context).withExtraHeaders(ImmutableMap.of("x-goog-request-params", ImmutableList.of(encodedHeader)));
        }
        return this.callable.futureCall(request, newCallContext);
    }
}

