/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.escapevelocity;

import autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import autovalue.shaded.com.google.escapevelocity.Node;
import autovalue.shaded.com.google.escapevelocity.Parser;

abstract class ExpressionNode
extends Node {
    ExpressionNode(String resourceName, int lineNumber) {
        super(resourceName, lineNumber);
    }

    @Override
    final void render(EvaluationContext context, StringBuilder output) {
        Object rendered = this.evaluate(context);
        if (rendered == null) {
            if (this.isSilent()) {
                return;
            }
            throw this.evaluationException("Null value for " + this);
        }
        if (rendered instanceof Node) {
            ((Node)rendered).render(context, output);
        } else {
            output.append(rendered);
        }
    }

    public abstract String toString();

    abstract Object evaluate(EvaluationContext var1, boolean var2);

    final Object evaluate(EvaluationContext context) {
        return this.evaluate(context, false);
    }

    boolean isTrue(EvaluationContext context, boolean undefinedIsFalse) {
        Object value = this.evaluate(context, undefinedIsFalse);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return value != null;
    }

    boolean isSilent() {
        return false;
    }

    Integer intValue(EvaluationContext context) {
        Object value = this.evaluate(context);
        if (value == null) {
            return null;
        }
        if (!(value instanceof Integer)) {
            throw this.evaluationException("Arithmetic is only available on integers, not " + ExpressionNode.show(value));
        }
        return (Integer)value;
    }

    private static String show(Object value) {
        if (value == null) {
            return "null";
        }
        return value + " (a " + value.getClass().getName() + ")";
    }

    static class NotExpressionNode
    extends ExpressionNode {
        private final ExpressionNode expr;

        NotExpressionNode(ExpressionNode expr) {
            super(expr.resourceName, expr.lineNumber);
            this.expr = expr;
        }

        @Override
        public String toString() {
            if (this.expr instanceof BinaryExpressionNode) {
                return "!(" + this.expr + ")";
            }
            return "!" + this.expr;
        }

        @Override
        Object evaluate(EvaluationContext context, boolean undefinedIsFalse) {
            return !this.expr.isTrue(context, undefinedIsFalse);
        }
    }

    static class BinaryExpressionNode
    extends ExpressionNode {
        final ExpressionNode lhs;
        final Parser.Operator op;
        final ExpressionNode rhs;

        BinaryExpressionNode(ExpressionNode lhs, Parser.Operator op, ExpressionNode rhs) {
            super(lhs.resourceName, lhs.lineNumber);
            this.lhs = lhs;
            this.op = op;
            this.rhs = rhs;
        }

        @Override
        public String toString() {
            return this.operandString(this.lhs) + " " + (Object)((Object)this.op) + " " + this.operandString(this.rhs);
        }

        private String operandString(ExpressionNode operand) {
            String s2 = String.valueOf(operand);
            if (operand instanceof BinaryExpressionNode) {
                BinaryExpressionNode binaryOperand = (BinaryExpressionNode)operand;
                if (binaryOperand.op.precedence < this.op.precedence) {
                    return "(" + s2 + ")";
                }
            }
            return s2;
        }

        @Override
        Object evaluate(EvaluationContext context, boolean undefinedIsFalse) {
            switch (this.op) {
                case OR: {
                    return this.lhs.isTrue(context, undefinedIsFalse) || this.rhs.isTrue(context, undefinedIsFalse);
                }
                case AND: {
                    return this.lhs.isTrue(context, undefinedIsFalse) && this.rhs.isTrue(context, undefinedIsFalse);
                }
                case EQUAL: {
                    return this.equal(context);
                }
                case NOT_EQUAL: {
                    return !this.equal(context);
                }
                case PLUS: {
                    return this.plus(context);
                }
            }
            Integer lhsInt = this.lhs.intValue(context);
            Integer rhsInt = this.rhs.intValue(context);
            if (lhsInt == null || rhsInt == null) {
                return this.nullOperand(lhsInt == null);
            }
            switch (this.op) {
                case LESS: {
                    return lhsInt < rhsInt;
                }
                case LESS_OR_EQUAL: {
                    return lhsInt <= rhsInt;
                }
                case GREATER: {
                    return lhsInt > rhsInt;
                }
                case GREATER_OR_EQUAL: {
                    return lhsInt >= rhsInt;
                }
                case MINUS: {
                    return lhsInt - rhsInt;
                }
                case TIMES: {
                    return lhsInt * rhsInt;
                }
                case DIVIDE: {
                    return rhsInt == 0 ? null : Integer.valueOf(lhsInt / rhsInt);
                }
                case REMAINDER: {
                    return rhsInt == 0 ? null : Integer.valueOf(lhsInt % rhsInt);
                }
            }
            throw new AssertionError((Object)this.op);
        }

        private Void nullOperand(boolean leftIsNull) {
            if (this.op.isInequality()) {
                String operand = leftIsNull ? "Left operand " + this.lhs : "Right operand " + this.rhs;
                throw this.evaluationException(operand + " of " + (Object)((Object)this.op) + " must not be null");
            }
            return null;
        }

        private boolean equal(EvaluationContext context) {
            Object rhsValue;
            Object lhsValue = this.lhs.evaluate(context);
            if (lhsValue == (rhsValue = this.rhs.evaluate(context))) {
                return true;
            }
            if (lhsValue == null || rhsValue == null) {
                return false;
            }
            if (lhsValue.getClass().equals(rhsValue.getClass())) {
                return lhsValue.equals(rhsValue);
            }
            return lhsValue.toString().equals(rhsValue.toString());
        }

        private Object plus(EvaluationContext context) {
            Object lhsValue = this.lhs.evaluate(context);
            Object rhsValue = this.rhs.evaluate(context);
            if (lhsValue instanceof String || rhsValue instanceof String) {
                if (lhsValue == null) {
                    lhsValue = this.lhs.toString();
                }
                if (rhsValue == null) {
                    rhsValue = this.rhs.toString();
                }
                return "" + lhsValue + rhsValue;
            }
            if (lhsValue == null || rhsValue == null) {
                return null;
            }
            if (!(lhsValue instanceof Integer) || !(rhsValue instanceof Integer)) {
                throw this.evaluationException("Operands of + must both be integers, or at least one must be a string: " + ExpressionNode.show(lhsValue) + " + " + ExpressionNode.show(rhsValue));
            }
            return (Integer)lhsValue + (Integer)rhsValue;
        }
    }
}

