/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.BufferLayout;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.TypeLayout;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.InvalidArrowFileException;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.DecimalUtility;
import org.apache.arrow.vector.util.DictionaryUtility;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.iceberg.gcp.shaded.com.fasterxml.jackson.core.JsonParseException;
import org.apache.iceberg.gcp.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.gcp.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.iceberg.gcp.shaded.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.iceberg.gcp.shaded.com.fasterxml.jackson.databind.MappingJsonFactory;
import org.apache.iceberg.gcp.shaded.com.fasterxml.jackson.databind.ObjectMapper;

public class JsonFileReader
implements AutoCloseable,
DictionaryProvider {
    private final JsonParser parser;
    private final BufferAllocator allocator;
    private Schema schema;
    private Map<Long, Dictionary> dictionaries;
    private Boolean started = false;

    public JsonFileReader(File inputFile, BufferAllocator allocator) throws JsonParseException, IOException {
        this.allocator = allocator;
        MappingJsonFactory jsonFactory = new MappingJsonFactory(new ObjectMapper().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true));
        this.parser = jsonFactory.createParser(inputFile);
        this.parser.configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    @Override
    public Dictionary lookup(long id) {
        if (!this.started.booleanValue()) {
            throw new IllegalStateException("Unable to lookup until after read() has started");
        }
        return this.dictionaries.get(id);
    }

    @Override
    public Set<Long> getDictionaryIds() {
        return this.dictionaries.keySet();
    }

    public Schema start() throws JsonParseException, IOException {
        this.readToken(JsonToken.START_OBJECT);
        Schema originalSchema = this.readNextField("schema", Schema.class);
        ArrayList<Field> fields = new ArrayList<Field>();
        this.dictionaries = new HashMap<Long, Dictionary>();
        for (Field field : originalSchema.getFields()) {
            fields.add(DictionaryUtility.toMemoryFormat(field, this.allocator, this.dictionaries));
        }
        this.schema = new Schema(fields, originalSchema.getCustomMetadata());
        if (!this.dictionaries.isEmpty()) {
            this.nextFieldIs("dictionaries");
            this.readDictionaryBatches();
        }
        this.nextFieldIs("batches");
        this.readToken(JsonToken.START_ARRAY);
        this.started = true;
        return this.schema;
    }

    private void readDictionaryBatches() throws JsonParseException, IOException {
        boolean haveDictionaryBatch;
        this.readToken(JsonToken.START_ARRAY);
        JsonToken token = this.parser.nextToken();
        boolean bl = haveDictionaryBatch = token == JsonToken.START_OBJECT;
        while (haveDictionaryBatch) {
            long id = this.readNextField("id", Long.class);
            Dictionary dict = this.dictionaries.get(id);
            if (dict == null) {
                throw new IllegalArgumentException("Dictionary with id: " + id + " missing encoding from schema Field");
            }
            this.nextFieldIs("data");
            FieldVector vector = dict.getVector();
            List<Field> fields = Collections.singletonList(vector.getField());
            List<FieldVector> vectors = Collections.singletonList(vector);
            VectorSchemaRoot root = new VectorSchemaRoot(fields, vectors, vector.getValueCount());
            this.read(root);
            this.readToken(JsonToken.END_OBJECT);
            token = this.parser.nextToken();
            haveDictionaryBatch = token == JsonToken.START_OBJECT;
        }
        if (token != JsonToken.END_ARRAY) {
            throw new IllegalArgumentException("Invalid token: " + (Object)((Object)token) + " expected end of array at " + this.parser.getTokenLocation());
        }
    }

    public boolean read(VectorSchemaRoot root) throws IOException {
        JsonToken t2 = this.parser.nextToken();
        if (t2 == JsonToken.START_OBJECT) {
            int count = this.readNextField("count", Integer.class);
            this.nextFieldIs("columns");
            this.readToken(JsonToken.START_ARRAY);
            for (Field field : root.getSchema().getFields()) {
                FieldVector vector = root.getVector(field);
                this.readFromJsonIntoVector(field, vector);
            }
            this.readToken(JsonToken.END_ARRAY);
            root.setRowCount(count);
            this.readToken(JsonToken.END_OBJECT);
            return true;
        }
        if (t2 == JsonToken.END_ARRAY) {
            root.setRowCount(0);
            return false;
        }
        throw new IllegalArgumentException("Invalid token: " + (Object)((Object)t2));
    }

    public VectorSchemaRoot read() throws IOException {
        JsonToken t2 = this.parser.nextToken();
        if (t2 == JsonToken.START_OBJECT) {
            VectorSchemaRoot recordBatch = VectorSchemaRoot.create(this.schema, this.allocator);
            int count = this.readNextField("count", Integer.class);
            recordBatch.setRowCount(count);
            this.nextFieldIs("columns");
            this.readToken(JsonToken.START_ARRAY);
            for (Field field : this.schema.getFields()) {
                FieldVector vector = recordBatch.getVector(field);
                this.readFromJsonIntoVector(field, vector);
            }
            this.readToken(JsonToken.END_ARRAY);
            this.readToken(JsonToken.END_OBJECT);
            return recordBatch;
        }
        if (t2 == JsonToken.END_ARRAY) {
            return null;
        }
        throw new IllegalArgumentException("Invalid token: " + (Object)((Object)t2));
    }

    public int skip(int numBatches) throws IOException {
        for (int i = 0; i < numBatches; ++i) {
            JsonToken t2 = this.parser.nextToken();
            if (t2 == JsonToken.START_OBJECT) {
                this.parser.skipChildren();
                assert (this.parser.getCurrentToken() == JsonToken.END_OBJECT);
                continue;
            }
            if (t2 == JsonToken.END_ARRAY) {
                return i;
            }
            throw new IllegalArgumentException("Invalid token: " + (Object)((Object)t2));
        }
        return numBatches;
    }

    List<ArrowBuf> readVariadicBuffers(BufferAllocator allocator, int variadicBuffersCount) throws IOException {
        this.readToken(JsonToken.START_ARRAY);
        ArrayList<ArrowBuf> dataBuffers = new ArrayList<ArrowBuf>(variadicBuffersCount);
        for (int i = 0; i < variadicBuffersCount; ++i) {
            this.parser.nextToken();
            String variadicStr = this.parser.readValueAs(String.class);
            byte[] value = variadicStr == null ? new byte[]{} : this.decodeHexSafe(variadicStr);
            ArrowBuf buf = allocator.buffer(value.length);
            buf.writeBytes(value);
            dataBuffers.add(buf);
        }
        this.readToken(JsonToken.END_ARRAY);
        return dataBuffers;
    }

    private ArrowBuf readViewBuffers(BufferAllocator allocator, int count, List<Integer> variadicBufferIndices, Types.MinorType type) throws IOException {
        this.readToken(JsonToken.START_ARRAY);
        ArrayList<byte[]> values = new ArrayList<byte[]>(count);
        long bufferSize = 0L;
        for (int i = 0; i < count; ++i) {
            byte[] value;
            this.readToken(JsonToken.START_OBJECT);
            int length = this.readNextField("SIZE", Integer.class);
            if (length > 12) {
                byte[] prefix = this.decodeHexSafe(this.readNextField("PREFIX_HEX", String.class));
                int bufferIndex = this.readNextField("BUFFER_INDEX", Integer.class);
                if (variadicBufferIndices.isEmpty()) {
                    variadicBufferIndices.add(bufferIndex);
                } else {
                    int lastBufferIndex = variadicBufferIndices.get(variadicBufferIndices.size() - 1);
                    if (lastBufferIndex != bufferIndex) {
                        variadicBufferIndices.add(bufferIndex);
                    }
                }
                int offset = this.readNextField("OFFSET", Integer.class);
                ByteBuffer buffer = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN);
                buffer.putInt(length);
                buffer.put(prefix);
                buffer.putInt(bufferIndex);
                buffer.putInt(offset);
                value = buffer.array();
            } else {
                ByteBuffer buffer = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN);
                buffer.putInt(length);
                if (type == Types.MinorType.VIEWVARCHAR) {
                    buffer.put(this.readNextField("INLINED", String.class).getBytes(StandardCharsets.UTF_8));
                } else {
                    String inlined = this.readNextField("INLINED", String.class);
                    if (inlined == null) {
                        buffer.put(new byte[length]);
                    } else {
                        buffer.put(this.decodeHexSafe(inlined));
                    }
                }
                value = buffer.array();
            }
            values.add(value);
            bufferSize += (long)value.length;
            this.readToken(JsonToken.END_OBJECT);
        }
        ArrowBuf buf = allocator.buffer(bufferSize);
        for (byte[] value : values) {
            buf.writeBytes(value);
        }
        this.readToken(JsonToken.END_ARRAY);
        return buf;
    }

    private List<ArrowBuf> readIntoBuffer(BufferAllocator allocator, BufferLayout.BufferType bufferType, Types.MinorType type, int count, List<Integer> variadicBufferIndices) throws IOException {
        BufferReader reader;
        block32: {
            block35: {
                BufferHelper helper;
                block34: {
                    block33: {
                        block31: {
                            helper = new BufferHelper();
                            if (!bufferType.equals((Object)BufferLayout.BufferType.VALIDITY)) break block31;
                            reader = helper.BIT;
                            break block32;
                        }
                        if (!bufferType.equals((Object)BufferLayout.BufferType.OFFSET)) break block33;
                        reader = type == Types.MinorType.LARGELIST || type == Types.MinorType.LARGEVARCHAR || type == Types.MinorType.LARGEVARBINARY ? helper.INT8 : helper.INT4;
                        break block32;
                    }
                    if (!bufferType.equals((Object)BufferLayout.BufferType.TYPE)) break block34;
                    reader = helper.INT1;
                    break block32;
                }
                if (!bufferType.equals((Object)BufferLayout.BufferType.DATA)) break block35;
                switch (type) {
                    case BIT: {
                        reader = helper.BIT;
                        break block32;
                    }
                    case TINYINT: {
                        reader = helper.INT1;
                        break block32;
                    }
                    case SMALLINT: {
                        reader = helper.INT2;
                        break block32;
                    }
                    case INT: {
                        reader = helper.INT4;
                        break block32;
                    }
                    case BIGINT: {
                        reader = helper.INT8;
                        break block32;
                    }
                    case UINT1: {
                        reader = helper.UINT1;
                        break block32;
                    }
                    case UINT2: {
                        reader = helper.UINT2;
                        break block32;
                    }
                    case UINT4: {
                        reader = helper.UINT4;
                        break block32;
                    }
                    case UINT8: {
                        reader = helper.UINT8;
                        break block32;
                    }
                    case FLOAT4: {
                        reader = helper.FLOAT4;
                        break block32;
                    }
                    case FLOAT8: {
                        reader = helper.FLOAT8;
                        break block32;
                    }
                    case DECIMAL: {
                        reader = helper.DECIMAL;
                        break block32;
                    }
                    case DECIMAL256: {
                        reader = helper.DECIMAL256;
                        break block32;
                    }
                    case FIXEDSIZEBINARY: {
                        reader = helper.FIXEDSIZEBINARY;
                        break block32;
                    }
                    case VARCHAR: {
                        reader = helper.VARCHAR;
                        break block32;
                    }
                    case LARGEVARCHAR: {
                        reader = helper.LARGEVARCHAR;
                        break block32;
                    }
                    case VARBINARY: {
                        reader = helper.VARBINARY;
                        break block32;
                    }
                    case LARGEVARBINARY: {
                        reader = helper.LARGEVARBINARY;
                        break block32;
                    }
                    case DATEDAY: {
                        reader = helper.INT4;
                        break block32;
                    }
                    case DATEMILLI: {
                        reader = helper.INT8;
                        break block32;
                    }
                    case TIMESEC: 
                    case TIMEMILLI: {
                        reader = helper.INT4;
                        break block32;
                    }
                    case TIMEMICRO: 
                    case TIMENANO: {
                        reader = helper.INT8;
                        break block32;
                    }
                    case TIMESTAMPNANO: 
                    case TIMESTAMPMICRO: 
                    case TIMESTAMPMILLI: 
                    case TIMESTAMPSEC: 
                    case TIMESTAMPNANOTZ: 
                    case TIMESTAMPMICROTZ: 
                    case TIMESTAMPMILLITZ: 
                    case TIMESTAMPSECTZ: {
                        reader = helper.INT8;
                        break block32;
                    }
                    case INTERVALYEAR: {
                        reader = helper.INT4;
                        break block32;
                    }
                    case INTERVALDAY: {
                        reader = helper.DAY_MILLIS;
                        break block32;
                    }
                    case INTERVALMONTHDAYNANO: {
                        reader = helper.MONTH_DAY_NANOS;
                        break block32;
                    }
                    case DURATION: {
                        reader = helper.INT8;
                        break block32;
                    }
                    default: {
                        throw new UnsupportedOperationException("Cannot read array of type " + (Object)((Object)type));
                    }
                }
            }
            if (bufferType.equals((Object)BufferLayout.BufferType.VIEWS)) {
                return Collections.singletonList(this.readViewBuffers(allocator, count, variadicBufferIndices, type));
            }
            if (bufferType.equals((Object)BufferLayout.BufferType.VARIADIC_DATA_BUFFERS)) {
                return this.readVariadicBuffers(allocator, variadicBufferIndices.size());
            }
            throw new InvalidArrowFileException("Unrecognized buffer type " + (Object)((Object)bufferType));
        }
        ArrowBuf buf = reader.readBuffer(allocator, count);
        Preconditions.checkNotNull(buf);
        return Collections.singletonList(buf);
    }

    private void readFromJsonIntoVector(Field field, FieldVector vector) throws IOException {
        ArrowType type = field.getType();
        TypeLayout typeLayout = TypeLayout.getTypeLayout(type);
        List<BufferLayout.BufferType> vectorTypes = typeLayout.getBufferTypes();
        ArrayList<ArrowBuf> vectorBuffers = new ArrayList<ArrowBuf>(vectorTypes.size());
        ArrayList<Integer> variadicBufferIndices = new ArrayList<Integer>();
        if (!typeLayout.isFixedBufferCount()) {
            vectorTypes.add(BufferLayout.BufferType.VARIADIC_DATA_BUFFERS);
        }
        this.readToken(JsonToken.START_OBJECT);
        String name = this.readNextField("name", String.class);
        if (this.started.booleanValue() && !Objects.equals(field.getName(), name)) {
            throw new IllegalArgumentException("Expected field " + field.getName() + " but got " + name);
        }
        int valueCount = this.readNextField("count", Integer.class);
        vector.setInitialCapacity(valueCount);
        for (int v = 0; v < vectorTypes.size(); ++v) {
            BufferLayout.BufferType bufferType = vectorTypes.get(v);
            this.nextFieldIs(bufferType.getName());
            int innerBufferValueCount = valueCount;
            if (bufferType.equals((Object)BufferLayout.BufferType.OFFSET) && !(type instanceof ArrowType.Union)) {
                innerBufferValueCount = valueCount + 1;
            }
            vectorBuffers.addAll(this.readIntoBuffer(this.allocator, bufferType, vector.getMinorType(), innerBufferValueCount, variadicBufferIndices));
        }
        int nullCount = 0;
        if (type instanceof ArrowType.Null) {
            nullCount = valueCount;
        } else if (!(type instanceof ArrowType.Union)) {
            nullCount = BitVectorHelper.getNullCount((ArrowBuf)vectorBuffers.get(0), valueCount);
        }
        ArrowFieldNode fieldNode = new ArrowFieldNode(valueCount, nullCount);
        vector.loadFieldBuffers(fieldNode, vectorBuffers);
        List<Field> fields = field.getChildren();
        if (!fields.isEmpty()) {
            List<FieldVector> vectorChildren = vector.getChildrenFromFields();
            if (fields.size() != vectorChildren.size()) {
                throw new IllegalArgumentException("fields and children are not the same size: " + fields.size() + " != " + vectorChildren.size());
            }
            this.nextFieldIs("children");
            this.readToken(JsonToken.START_ARRAY);
            for (int i = 0; i < fields.size(); ++i) {
                Field childField = fields.get(i);
                FieldVector childVector = vectorChildren.get(i);
                this.readFromJsonIntoVector(childField, childVector);
            }
            this.readToken(JsonToken.END_ARRAY);
        }
        this.readToken(JsonToken.END_OBJECT);
        for (ArrowBuf buffer : vectorBuffers) {
            buffer.getReferenceManager().release();
        }
    }

    private byte[] decodeHexSafe(String hexString) throws IOException {
        try {
            return Hex.decodeHex(hexString.toCharArray());
        }
        catch (DecoderException e) {
            throw new IOException("Unable to decode hex string: " + hexString, e);
        }
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
        if (this.dictionaries != null) {
            for (Dictionary dictionary : this.dictionaries.values()) {
                dictionary.getVector().close();
            }
        }
    }

    private <T> T readNextField(String expectedFieldName, Class<T> c) throws IOException, JsonParseException {
        this.nextFieldIs(expectedFieldName);
        this.parser.nextToken();
        return this.parser.readValueAs(c);
    }

    private void nextFieldIs(String expectedFieldName) throws IOException, JsonParseException {
        String name = this.parser.nextFieldName();
        if (name == null || !name.equals(expectedFieldName)) {
            throw new IllegalStateException("Expected " + expectedFieldName + " but got " + name);
        }
    }

    private void readToken(JsonToken expected) throws JsonParseException, IOException {
        JsonToken t2 = this.parser.nextToken();
        if (t2 != expected) {
            throw new IllegalStateException("Expected " + (Object)((Object)expected) + " but got " + (Object)((Object)t2));
        }
    }

    private class BufferHelper {
        BufferReader BIT = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                int bufferSize = BitVectorHelper.getValidityBufferSize(count);
                ArrowBuf buf = allocator.buffer(bufferSize);
                buf.setZero(0L, bufferSize);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    BitVectorHelper.setValidityBit(buf, i, JsonFileReader.this.parser.readValueAs(Boolean.class) != false ? 1 : 0);
                }
                buf.writerIndex(bufferSize);
                return buf;
            }
        };
        BufferReader DAY_MILLIS = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 8L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.readToken(JsonToken.START_OBJECT);
                    buf.writeInt((Integer)JsonFileReader.this.readNextField("days", Integer.class));
                    buf.writeInt((Integer)JsonFileReader.this.readNextField("milliseconds", Integer.class));
                    JsonFileReader.this.readToken(JsonToken.END_OBJECT);
                }
                return buf;
            }
        };
        BufferReader MONTH_DAY_NANOS = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 16L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.readToken(JsonToken.START_OBJECT);
                    buf.writeInt((Integer)JsonFileReader.this.readNextField("months", Integer.class));
                    buf.writeInt((Integer)JsonFileReader.this.readNextField("days", Integer.class));
                    buf.writeLong((Long)JsonFileReader.this.readNextField("nanoseconds", Long.class));
                    JsonFileReader.this.readToken(JsonToken.END_OBJECT);
                }
                return buf;
            }
        };
        BufferReader INT1 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 1L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeByte(JsonFileReader.this.parser.getByteValue());
                }
                return buf;
            }
        };
        BufferReader INT2 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 2L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeShort(JsonFileReader.this.parser.getShortValue());
                }
                return buf;
            }
        };
        BufferReader INT4 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 4L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeInt(JsonFileReader.this.parser.getIntValue());
                }
                return buf;
            }
        };
        BufferReader INT8 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 8L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    String value = JsonFileReader.this.parser.getValueAsString();
                    buf.writeLong(Long.valueOf(value));
                }
                return buf;
            }
        };
        BufferReader UINT1 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 1L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeByte(JsonFileReader.this.parser.getShortValue() & 0xFF);
                }
                return buf;
            }
        };
        BufferReader UINT2 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 2L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeShort(JsonFileReader.this.parser.getIntValue() & 0xFFFF);
                }
                return buf;
            }
        };
        BufferReader UINT4 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 4L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeInt((int)JsonFileReader.this.parser.getLongValue());
                }
                return buf;
            }
        };
        BufferReader UINT8 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 8L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    BigInteger value = new BigInteger(JsonFileReader.this.parser.getValueAsString());
                    buf.writeLong(value.longValue());
                }
                return buf;
            }
        };
        BufferReader FLOAT4 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 4L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeFloat(JsonFileReader.this.parser.getFloatValue());
                }
                return buf;
            }
        };
        BufferReader FLOAT8 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 8L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    buf.writeDouble(JsonFileReader.this.parser.getDoubleValue());
                }
                return buf;
            }
        };
        BufferReader DECIMAL = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 16L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    BigDecimal decimalValue = new BigDecimal(JsonFileReader.this.parser.readValueAs(String.class));
                    DecimalUtility.writeBigDecimalToArrowBuf(decimalValue, buf, i, 16);
                }
                buf.writerIndex(size);
                return buf;
            }
        };
        BufferReader DECIMAL256 = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                long size = (long)count * 32L;
                ArrowBuf buf = allocator.buffer(size);
                for (int i = 0; i < count; ++i) {
                    JsonFileReader.this.parser.nextToken();
                    BigDecimal decimalValue = new BigDecimal(JsonFileReader.this.parser.readValueAs(String.class));
                    DecimalUtility.writeBigDecimalToArrowBuf(decimalValue, buf, i, 32);
                }
                buf.writerIndex(size);
                return buf;
            }
        };
        BufferReader FIXEDSIZEBINARY = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                return BufferHelper.this.readBinaryValues(allocator, count);
            }
        };
        BufferReader VARCHAR = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                return BufferHelper.this.readStringValues(allocator, count);
            }
        };
        BufferReader LARGEVARCHAR = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                return BufferHelper.this.readStringValues(allocator, count);
            }
        };
        BufferReader VARBINARY = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                return BufferHelper.this.readBinaryValues(allocator, count);
            }
        };
        BufferReader LARGEVARBINARY = new BufferReader(){

            @Override
            protected ArrowBuf read(BufferAllocator allocator, int count) throws IOException {
                return BufferHelper.this.readBinaryValues(allocator, count);
            }
        };

        private BufferHelper() {
        }

        ArrowBuf readBinaryValues(BufferAllocator allocator, int count) throws IOException {
            ArrayList<byte[]> values = new ArrayList<byte[]>(count);
            long bufferSize = 0L;
            for (int i = 0; i < count; ++i) {
                JsonFileReader.this.parser.nextToken();
                byte[] value = JsonFileReader.this.decodeHexSafe(JsonFileReader.this.parser.readValueAs(String.class));
                values.add(value);
                bufferSize += (long)value.length;
            }
            ArrowBuf buf = allocator.buffer(bufferSize);
            for (byte[] value : values) {
                buf.writeBytes(value);
            }
            return buf;
        }

        ArrowBuf readStringValues(BufferAllocator allocator, int count) throws IOException {
            ArrayList<byte[]> values = new ArrayList<byte[]>(count);
            long bufferSize = 0L;
            for (int i = 0; i < count; ++i) {
                JsonFileReader.this.parser.nextToken();
                byte[] value = JsonFileReader.this.parser.getValueAsString().getBytes(StandardCharsets.UTF_8);
                values.add(value);
                bufferSize += (long)value.length;
            }
            ArrowBuf buf = allocator.buffer(bufferSize);
            for (byte[] value : values) {
                buf.writeBytes(value);
            }
            return buf;
        }
    }

    private abstract class BufferReader {
        private BufferReader() {
        }

        protected abstract ArrowBuf read(BufferAllocator var1, int var2) throws IOException;

        ArrowBuf readBuffer(BufferAllocator allocator, int count) throws IOException {
            JsonFileReader.this.readToken(JsonToken.START_ARRAY);
            ArrowBuf buf = this.read(allocator, count);
            JsonFileReader.this.readToken(JsonToken.END_ARRAY);
            return buf;
        }
    }
}

