/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.WrrLocalityLoadBalancer;
import java.util.Map;

@Internal
public final class WrrLocalityLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new WrrLocalityLoadBalancer(helper);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "wrr_locality_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            NameResolver.ConfigOrError childConfig = GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig(JsonUtil.getListOfObjects(rawConfig, "childPolicy"));
            if (childConfig.getError() != null) {
                return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("Failed to parse child policy in wrr_locality LB policy: " + rawConfig).withCause(childConfig.getError().asRuntimeException()));
            }
            return NameResolver.ConfigOrError.fromConfig(new WrrLocalityLoadBalancer.WrrLocalityConfig(childConfig.getConfig()));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withCause(e).withDescription("Failed to parse wrr_locality LB config: " + rawConfig));
        }
    }
}

