/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import javax.annotation.Nullable;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;

final class StructOrError<T> {
    private final String errorDetail;
    private final T struct;

    public static <T> StructOrError<T> fromStruct(T struct) {
        return new StructOrError<T>(struct);
    }

    public static <T> StructOrError<T> fromError(String errorDetail) {
        return new StructOrError<T>(errorDetail);
    }

    private StructOrError(T struct) {
        this.struct = Preconditions.checkNotNull(struct, "struct");
        this.errorDetail = null;
    }

    private StructOrError(String errorDetail) {
        this.struct = null;
        this.errorDetail = Preconditions.checkNotNull(errorDetail, "errorDetail");
    }

    @Nullable
    @VisibleForTesting
    public T getStruct() {
        return this.struct;
    }

    @Nullable
    @VisibleForTesting
    public String getErrorDetail() {
        return this.errorDetail;
    }
}

