/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.xds.ConfigOrError;
import io.grpc.xds.Filter;
import io.grpc.xds.RbacConfig;
import io.grpc.xds.internal.MatcherParser;
import io.grpc.xds.internal.Matchers;
import io.grpc.xds.internal.rbac.engine.GrpcAuthorizationEngine;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.CidrRange;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.rbac.v3.Permission;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.rbac.v3.Policy;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.rbac.v3.Principal;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.rbac.v3.RBAC;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.rbac.v3.RBACPerRoute;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.matcher.v3.PathMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.matcher.v3.StringMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.Int32Range;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Any;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Message;

final class RbacFilter
implements Filter,
Filter.ServerInterceptorBuilder {
    private static final Logger logger = Logger.getLogger(RbacFilter.class.getName());
    static final RbacFilter INSTANCE = new RbacFilter();
    static final String TYPE_URL = "type.googleapis.com/envoy.extensions.filters.http.rbac.v3.RBAC";
    private static final String TYPE_URL_OVERRIDE_CONFIG = "type.googleapis.com/envoy.extensions.filters.http.rbac.v3.RBACPerRoute";

    RbacFilter() {
    }

    @Override
    public String[] typeUrls() {
        return new String[]{TYPE_URL, TYPE_URL_OVERRIDE_CONFIG};
    }

    public ConfigOrError<RbacConfig> parseFilterConfig(Message rawProtoMessage) {
        io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.rbac.v3.RBAC rbacProto;
        if (!(rawProtoMessage instanceof Any)) {
            return ConfigOrError.fromError("Invalid config type: " + rawProtoMessage.getClass());
        }
        Any anyMessage = (Any)rawProtoMessage;
        try {
            rbacProto = anyMessage.unpack(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.rbac.v3.RBAC.class);
        }
        catch (InvalidProtocolBufferException e) {
            return ConfigOrError.fromError("Invalid proto: " + e);
        }
        return RbacFilter.parseRbacConfig(rbacProto);
    }

    @VisibleForTesting
    static ConfigOrError<RbacConfig> parseRbacConfig(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.http.rbac.v3.RBAC rbac) {
        GrpcAuthorizationEngine.Action authAction;
        if (!rbac.hasRules()) {
            return ConfigOrError.fromConfig(RbacConfig.create(null));
        }
        RBAC rbacConfig = rbac.getRules();
        switch (rbacConfig.getAction()) {
            case ALLOW: {
                authAction = GrpcAuthorizationEngine.Action.ALLOW;
                break;
            }
            case DENY: {
                authAction = GrpcAuthorizationEngine.Action.DENY;
                break;
            }
            case LOG: {
                return ConfigOrError.fromConfig(RbacConfig.create(null));
            }
            default: {
                return ConfigOrError.fromError("Unknown rbacConfig action type: " + rbacConfig.getAction());
            }
        }
        ArrayList<GrpcAuthorizationEngine.PolicyMatcher> policyMatchers = new ArrayList<GrpcAuthorizationEngine.PolicyMatcher>();
        List sortedPolicyEntries = rbacConfig.getPoliciesMap().entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareTo((String)b.getKey())).collect(Collectors.toList());
        for (Map.Entry entry : sortedPolicyEntries) {
            try {
                Policy policy = (Policy)entry.getValue();
                if (policy.hasCondition() || policy.hasCheckedCondition()) {
                    return ConfigOrError.fromError("Policy.condition and Policy.checked_condition must not set: " + (String)entry.getKey());
                }
                policyMatchers.add(GrpcAuthorizationEngine.PolicyMatcher.create((String)entry.getKey(), RbacFilter.parsePermissionList(policy.getPermissionsList()), RbacFilter.parsePrincipalList(policy.getPrincipalsList())));
            }
            catch (Exception e) {
                return ConfigOrError.fromError("Encountered error parsing policy: " + e);
            }
        }
        return ConfigOrError.fromConfig(RbacConfig.create(GrpcAuthorizationEngine.AuthConfig.create(policyMatchers, authAction)));
    }

    public ConfigOrError<RbacConfig> parseFilterConfigOverride(Message rawProtoMessage) {
        RBACPerRoute rbacPerRoute;
        if (!(rawProtoMessage instanceof Any)) {
            return ConfigOrError.fromError("Invalid config type: " + rawProtoMessage.getClass());
        }
        Any anyMessage = (Any)rawProtoMessage;
        try {
            rbacPerRoute = anyMessage.unpack(RBACPerRoute.class);
        }
        catch (InvalidProtocolBufferException e) {
            return ConfigOrError.fromError("Invalid proto: " + e);
        }
        if (rbacPerRoute.hasRbac()) {
            return RbacFilter.parseRbacConfig(rbacPerRoute.getRbac());
        }
        return ConfigOrError.fromConfig(RbacConfig.create(null));
    }

    @Override
    @Nullable
    public ServerInterceptor buildServerInterceptor(Filter.FilterConfig config, @Nullable Filter.FilterConfig overrideConfig) {
        GrpcAuthorizationEngine.AuthConfig authConfig;
        Preconditions.checkNotNull(config, "config");
        if (overrideConfig != null) {
            config = overrideConfig;
        }
        return (authConfig = ((RbacConfig)config).authConfig()) == null ? null : this.generateAuthorizationInterceptor(authConfig);
    }

    private ServerInterceptor generateAuthorizationInterceptor(GrpcAuthorizationEngine.AuthConfig config) {
        Preconditions.checkNotNull(config, "config");
        final GrpcAuthorizationEngine authEngine = new GrpcAuthorizationEngine(config);
        return new ServerInterceptor(){

            @Override
            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                GrpcAuthorizationEngine.AuthDecision authResult = authEngine.evaluate(headers, call);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Authorization result for serverCall {0}: {1}, matching policy: {2}.", new Object[]{call, authResult.decision(), authResult.matchingPolicyName()});
                }
                if (GrpcAuthorizationEngine.Action.DENY.equals((Object)authResult.decision())) {
                    Status status = Status.PERMISSION_DENIED.withDescription("Access Denied");
                    call.close(status, new Metadata());
                    return new ServerCall.Listener<ReqT>(){};
                }
                return next.startCall(call, headers);
            }
        };
    }

    private static GrpcAuthorizationEngine.OrMatcher parsePermissionList(List<Permission> permissions) {
        ArrayList<GrpcAuthorizationEngine.Matcher> anyMatch = new ArrayList<GrpcAuthorizationEngine.Matcher>();
        for (Permission permission : permissions) {
            anyMatch.add(RbacFilter.parsePermission(permission));
        }
        return GrpcAuthorizationEngine.OrMatcher.create(anyMatch);
    }

    private static GrpcAuthorizationEngine.Matcher parsePermission(Permission permission) {
        switch (permission.getRuleCase()) {
            case AND_RULES: {
                ArrayList<GrpcAuthorizationEngine.Matcher> andMatch = new ArrayList<GrpcAuthorizationEngine.Matcher>();
                for (Permission p : permission.getAndRules().getRulesList()) {
                    andMatch.add(RbacFilter.parsePermission(p));
                }
                return GrpcAuthorizationEngine.AndMatcher.create(andMatch);
            }
            case OR_RULES: {
                return RbacFilter.parsePermissionList(permission.getOrRules().getRulesList());
            }
            case ANY: {
                return GrpcAuthorizationEngine.AlwaysTrueMatcher.INSTANCE;
            }
            case HEADER: {
                return RbacFilter.parseHeaderMatcher(permission.getHeader());
            }
            case URL_PATH: {
                return RbacFilter.parsePathMatcher(permission.getUrlPath());
            }
            case DESTINATION_IP: {
                return RbacFilter.createDestinationIpMatcher(permission.getDestinationIp());
            }
            case DESTINATION_PORT: {
                return RbacFilter.createDestinationPortMatcher(permission.getDestinationPort());
            }
            case DESTINATION_PORT_RANGE: {
                return RbacFilter.parseDestinationPortRangeMatcher(permission.getDestinationPortRange());
            }
            case NOT_RULE: {
                return GrpcAuthorizationEngine.InvertMatcher.create(RbacFilter.parsePermission(permission.getNotRule()));
            }
            case METADATA: {
                return GrpcAuthorizationEngine.InvertMatcher.create(GrpcAuthorizationEngine.AlwaysTrueMatcher.INSTANCE);
            }
            case REQUESTED_SERVER_NAME: {
                return RbacFilter.parseRequestedServerNameMatcher(permission.getRequestedServerName());
            }
        }
        throw new IllegalArgumentException("Unknown permission rule case: " + permission.getRuleCase());
    }

    private static GrpcAuthorizationEngine.OrMatcher parsePrincipalList(List<Principal> principals) {
        ArrayList<GrpcAuthorizationEngine.Matcher> anyMatch = new ArrayList<GrpcAuthorizationEngine.Matcher>();
        for (Principal principal : principals) {
            anyMatch.add(RbacFilter.parsePrincipal(principal));
        }
        return GrpcAuthorizationEngine.OrMatcher.create(anyMatch);
    }

    private static GrpcAuthorizationEngine.Matcher parsePrincipal(Principal principal) {
        switch (principal.getIdentifierCase()) {
            case OR_IDS: {
                return RbacFilter.parsePrincipalList(principal.getOrIds().getIdsList());
            }
            case AND_IDS: {
                ArrayList<GrpcAuthorizationEngine.Matcher> nextMatchers = new ArrayList<GrpcAuthorizationEngine.Matcher>();
                for (Principal next : principal.getAndIds().getIdsList()) {
                    nextMatchers.add(RbacFilter.parsePrincipal(next));
                }
                return GrpcAuthorizationEngine.AndMatcher.create(nextMatchers);
            }
            case ANY: {
                return GrpcAuthorizationEngine.AlwaysTrueMatcher.INSTANCE;
            }
            case AUTHENTICATED: {
                return RbacFilter.parseAuthenticatedMatcher(principal.getAuthenticated());
            }
            case DIRECT_REMOTE_IP: {
                return RbacFilter.createSourceIpMatcher(principal.getDirectRemoteIp());
            }
            case REMOTE_IP: {
                return RbacFilter.createSourceIpMatcher(principal.getRemoteIp());
            }
            case SOURCE_IP: {
                return RbacFilter.createSourceIpMatcher(principal.getSourceIp());
            }
            case HEADER: {
                return RbacFilter.parseHeaderMatcher(principal.getHeader());
            }
            case NOT_ID: {
                return GrpcAuthorizationEngine.InvertMatcher.create(RbacFilter.parsePrincipal(principal.getNotId()));
            }
            case URL_PATH: {
                return RbacFilter.parsePathMatcher(principal.getUrlPath());
            }
            case METADATA: {
                return GrpcAuthorizationEngine.InvertMatcher.create(GrpcAuthorizationEngine.AlwaysTrueMatcher.INSTANCE);
            }
        }
        throw new IllegalArgumentException("Unknown principal identifier case: " + principal.getIdentifierCase());
    }

    private static GrpcAuthorizationEngine.PathMatcher parsePathMatcher(PathMatcher proto) {
        switch (proto.getRuleCase()) {
            case PATH: {
                return GrpcAuthorizationEngine.PathMatcher.create(MatcherParser.parseStringMatcher(proto.getPath()));
            }
        }
        throw new IllegalArgumentException("Unknown path matcher rule type: " + proto.getRuleCase());
    }

    private static GrpcAuthorizationEngine.RequestedServerNameMatcher parseRequestedServerNameMatcher(StringMatcher proto) {
        return GrpcAuthorizationEngine.RequestedServerNameMatcher.create(MatcherParser.parseStringMatcher(proto));
    }

    private static GrpcAuthorizationEngine.AuthHeaderMatcher parseHeaderMatcher(HeaderMatcher proto) {
        if (proto.getName().startsWith("grpc-")) {
            throw new IllegalArgumentException("Invalid header matcher config: [grpc-] prefixed header name is not allowed.");
        }
        if (":scheme".equals(proto.getName())) {
            throw new IllegalArgumentException("Invalid header matcher config: header name [:scheme] is not allowed.");
        }
        return GrpcAuthorizationEngine.AuthHeaderMatcher.create(MatcherParser.parseHeaderMatcher(proto));
    }

    private static GrpcAuthorizationEngine.AuthenticatedMatcher parseAuthenticatedMatcher(Principal.Authenticated proto) {
        Matchers.StringMatcher matcher = MatcherParser.parseStringMatcher(proto.getPrincipalName());
        return GrpcAuthorizationEngine.AuthenticatedMatcher.create(matcher);
    }

    private static GrpcAuthorizationEngine.DestinationPortMatcher createDestinationPortMatcher(int port) {
        return GrpcAuthorizationEngine.DestinationPortMatcher.create(port);
    }

    private static GrpcAuthorizationEngine.DestinationPortRangeMatcher parseDestinationPortRangeMatcher(Int32Range range) {
        return GrpcAuthorizationEngine.DestinationPortRangeMatcher.create(range.getStart(), range.getEnd());
    }

    private static GrpcAuthorizationEngine.DestinationIpMatcher createDestinationIpMatcher(CidrRange cidrRange) {
        return GrpcAuthorizationEngine.DestinationIpMatcher.create(Matchers.CidrMatcher.create(RbacFilter.resolve(cidrRange), cidrRange.getPrefixLen().getValue()));
    }

    private static GrpcAuthorizationEngine.SourceIpMatcher createSourceIpMatcher(CidrRange cidrRange) {
        return GrpcAuthorizationEngine.SourceIpMatcher.create(Matchers.CidrMatcher.create(RbacFilter.resolve(cidrRange), cidrRange.getPrefixLen().getValue()));
    }

    private static InetAddress resolve(CidrRange cidrRange) {
        try {
            return InetAddress.getByName(cidrRange.getAddressPrefix());
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("IP address can not be found: " + ex);
        }
    }
}

