/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import io.grpc.Metadata;
import io.grpc.rls.RlsProtoData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.gcp.shaded.com.google.errorprone.annotations.CheckReturnValue;

final class RlsRequestFactory {
    private final String target;
    private final Map<String, RlsProtoData.GrpcKeyBuilder> keyBuilderTable;

    RlsRequestFactory(RlsProtoData.RouteLookupConfig rlsConfig, String target) {
        Preconditions.checkNotNull(rlsConfig, "rlsConfig");
        this.target = Preconditions.checkNotNull(target, "target");
        this.keyBuilderTable = RlsRequestFactory.createKeyBuilderTable(rlsConfig);
    }

    private static Map<String, RlsProtoData.GrpcKeyBuilder> createKeyBuilderTable(RlsProtoData.RouteLookupConfig config) {
        HashMap<String, RlsProtoData.GrpcKeyBuilder> table = new HashMap<String, RlsProtoData.GrpcKeyBuilder>();
        for (RlsProtoData.GrpcKeyBuilder grpcKeyBuilder : config.grpcKeybuilders()) {
            for (RlsProtoData.GrpcKeyBuilder.Name name : grpcKeyBuilder.names()) {
                boolean noMethod = name.method() == null || name.method().isEmpty();
                String method = noMethod ? "*" : name.method();
                String path = "/" + name.service() + "/" + method;
                table.put(path, grpcKeyBuilder);
            }
        }
        return table;
    }

    @CheckReturnValue
    RlsProtoData.RouteLookupRequest create(String service, String method, Metadata metadata) {
        Preconditions.checkNotNull(service, "service");
        Preconditions.checkNotNull(method, "method");
        String path = "/" + service + "/" + method;
        RlsProtoData.GrpcKeyBuilder grpcKeyBuilder = this.keyBuilderTable.get(path);
        if (grpcKeyBuilder == null) {
            grpcKeyBuilder = this.keyBuilderTable.get("/" + service + "/*");
        }
        if (grpcKeyBuilder == null) {
            return RlsProtoData.RouteLookupRequest.create(ImmutableMap.of());
        }
        ImmutableMap.Builder<String, String> rlsRequestHeaders = this.createRequestHeaders(metadata, grpcKeyBuilder.headers());
        RlsProtoData.ExtraKeys extraKeys = grpcKeyBuilder.extraKeys();
        ImmutableMap<String, String> constantKeys = grpcKeyBuilder.constantKeys();
        if (extraKeys.host() != null) {
            rlsRequestHeaders.put(extraKeys.host(), this.target);
        }
        if (extraKeys.service() != null) {
            rlsRequestHeaders.put(extraKeys.service(), service);
        }
        if (extraKeys.method() != null) {
            rlsRequestHeaders.put(extraKeys.method(), method);
        }
        rlsRequestHeaders.putAll(constantKeys);
        return RlsProtoData.RouteLookupRequest.create(rlsRequestHeaders.buildOrThrow());
    }

    private ImmutableMap.Builder<String, String> createRequestHeaders(Metadata metadata, List<RlsProtoData.NameMatcher> keyBuilder) {
        ImmutableMap.Builder<String, String> rlsRequestHeaders = ImmutableMap.builder();
        for (RlsProtoData.NameMatcher nameMatcher : keyBuilder) {
            String requestHeaderName;
            String value = null;
            Iterator iterator = nameMatcher.names().iterator();
            while (iterator.hasNext() && (value = metadata.get(Metadata.Key.of(requestHeaderName = (String)iterator.next(), Metadata.ASCII_STRING_MARSHALLER))) == null) {
            }
            if (value == null) continue;
            rlsRequestHeaders.put(nameMatcher.key(), value);
        }
        return rlsRequestHeaders;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("target", this.target).add("keyBuilderTable", this.keyBuilderTable).toString();
    }
}

