/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.services;

import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.gcp.shaded.com.google.errorprone.annotations.concurrent.GuardedBy;

final class HealthServiceImpl
extends HealthGrpc.HealthImplBase {
    private static final Logger logger = Logger.getLogger(HealthServiceImpl.class.getName());
    private final Map<String, HealthCheckResponse.ServingStatus> statusMap = new ConcurrentHashMap<String, HealthCheckResponse.ServingStatus>();
    private final Object watchLock = new Object();
    @GuardedBy(value="watchLock")
    private boolean terminal;
    @GuardedBy(value="watchLock")
    private final HashMap<String, IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean>> watchers = new HashMap();

    HealthServiceImpl() {
        this.statusMap.put("", HealthCheckResponse.ServingStatus.SERVING);
    }

    @Override
    public void check(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        HealthCheckResponse.ServingStatus status = this.statusMap.get(request.getService());
        if (status == null) {
            responseObserver.onError(new StatusException(Status.NOT_FOUND.withDescription("unknown service " + request.getService())));
        } else {
            HealthCheckResponse response = HealthCheckResponse.newBuilder().setStatus(status).build();
            responseObserver.onNext(response);
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watch(HealthCheckRequest request, final StreamObserver<HealthCheckResponse> responseObserver) {
        final String service = request.getService();
        Object object = this.watchLock;
        synchronized (object) {
            HealthCheckResponse.ServingStatus status = this.statusMap.get(service);
            responseObserver.onNext(HealthServiceImpl.getResponseForWatch(status));
            IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
            if (serviceWatchers == null) {
                serviceWatchers = new IdentityHashMap();
                this.watchers.put(service, serviceWatchers);
            }
            serviceWatchers.put(responseObserver, Boolean.TRUE);
        }
        Context.current().addListener(new Context.CancellationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelled(Context context) {
                Object object = HealthServiceImpl.this.watchLock;
                synchronized (object) {
                    IdentityHashMap serviceWatchers = (IdentityHashMap)HealthServiceImpl.this.watchers.get(service);
                    if (serviceWatchers != null) {
                        serviceWatchers.remove(responseObserver);
                        if (serviceWatchers.isEmpty()) {
                            HealthServiceImpl.this.watchers.remove(service);
                        }
                    }
                }
            }
        }, MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatus(String service, HealthCheckResponse.ServingStatus status) {
        Object object = this.watchLock;
        synchronized (object) {
            if (this.terminal) {
                logger.log(Level.FINE, "Ignoring status {} for {}", new Object[]{status, service});
                return;
            }
            this.setStatusInternal(service, status);
        }
    }

    @GuardedBy(value="watchLock")
    private void setStatusInternal(String service, HealthCheckResponse.ServingStatus status) {
        HealthCheckResponse.ServingStatus prevStatus = this.statusMap.put(service, status);
        if (prevStatus != status) {
            this.notifyWatchers(service, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStatus(String service) {
        Object object = this.watchLock;
        synchronized (object) {
            if (this.terminal) {
                logger.log(Level.FINE, "Ignoring status clearing for {}", new Object[]{service});
                return;
            }
            HealthCheckResponse.ServingStatus prevStatus = this.statusMap.remove(service);
            if (prevStatus != null) {
                this.notifyWatchers(service, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterTerminalState() {
        Object object = this.watchLock;
        synchronized (object) {
            if (this.terminal) {
                logger.log(Level.WARNING, "Already terminating", new RuntimeException());
                return;
            }
            this.terminal = true;
            for (String service : this.statusMap.keySet()) {
                this.setStatusInternal(service, HealthCheckResponse.ServingStatus.NOT_SERVING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int numWatchersForTest(String service) {
        Object object = this.watchLock;
        synchronized (object) {
            IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
            if (serviceWatchers == null) {
                return 0;
            }
            return serviceWatchers.size();
        }
    }

    @GuardedBy(value="watchLock")
    private void notifyWatchers(String service, @Nullable HealthCheckResponse.ServingStatus status) {
        HealthCheckResponse response = HealthServiceImpl.getResponseForWatch(status);
        IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
        if (serviceWatchers != null) {
            for (StreamObserver<HealthCheckResponse> responseObserver : serviceWatchers.keySet()) {
                responseObserver.onNext(response);
            }
        }
    }

    private static HealthCheckResponse getResponseForWatch(@Nullable HealthCheckResponse.ServingStatus recordedStatus) {
        return HealthCheckResponse.newBuilder().setStatus(recordedStatus == null ? HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN : recordedStatus).build();
    }
}

