/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.ZeroCopySupport;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.ByteString;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ResponseContentLifecycleHandle<Response>
implements Closeable {
    private final Response response;
    private final @Nullable Closeable dispose;
    private final AtomicBoolean open;
    private final AtomicInteger refs;

    private ResponseContentLifecycleHandle(Response response, @Nullable Closeable dispose) {
        this.response = response;
        this.dispose = dispose;
        this.open = new AtomicBoolean(true);
        this.refs = new AtomicInteger(1);
    }

    static <Response> ResponseContentLifecycleHandle<Response> create(Response response, @Nullable Closeable dispose) {
        return new ResponseContentLifecycleHandle<Response>(response, dispose);
    }

    ChildRef borrow(Function<Response, ByteString> toByteStringFunction) {
        Preconditions.checkState(this.open.get(), "only able to borrow when open");
        Preconditions.checkNotNull(toByteStringFunction);
        ChildRef childRef = new ChildRef(toByteStringFunction);
        this.refs.incrementAndGet();
        return childRef;
    }

    @Override
    public void close() throws IOException {
        int newCount;
        if (this.open.getAndSet(false) && (newCount = this.refs.decrementAndGet()) == 0) {
            this.dispose();
        }
    }

    private void dispose() throws IOException {
        if (this.dispose != null) {
            this.dispose.close();
        }
    }

    final class ChildRef
    implements Closeable,
    ZeroCopySupport.DisposableByteString {
        private final Function<Response, ByteString> toByteStringFunction;

        private ChildRef(Function<Response, ByteString> toByteStringFunction) {
            this.toByteStringFunction = toByteStringFunction;
        }

        @Override
        public ByteString byteString() {
            return this.toByteStringFunction.apply(ResponseContentLifecycleHandle.this.response);
        }

        @Override
        public void close() throws IOException {
            int newCount = ResponseContentLifecycleHandle.this.refs.decrementAndGet();
            if (newCount == 0) {
                ResponseContentLifecycleHandle.this.dispose();
            }
        }
    }
}

