/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.cloud.storage.BaseObjectReadSessionStreamRead;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.ObjectReadSessionStreamRead;
import com.google.cloud.storage.RangeSpec;
import com.google.cloud.storage.ReadProjectionConfigs;
import com.google.cloud.storage.RetryContext;
import com.google.cloud.storage.ZeroCopySupport;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;

@BetaApi
@Immutable
public final class ReadAsFutureByteString
extends ReadProjectionConfigs.BaseConfig<ApiFuture<ZeroCopySupport.DisposableByteString>, BaseObjectReadSessionStreamRead.AccumulatingRead<ZeroCopySupport.DisposableByteString>> {
    static final ReadAsFutureByteString INSTANCE = new ReadAsFutureByteString(RangeSpec.all(), Hasher.enabled());
    private final RangeSpec range;
    private final Hasher hasher;

    private ReadAsFutureByteString(RangeSpec range, Hasher hasher) {
        this.range = range;
        this.hasher = hasher;
    }

    @BetaApi
    public RangeSpec getRange() {
        return this.range;
    }

    @BetaApi
    public ReadAsFutureByteString withRangeSpec(RangeSpec range) {
        Objects.requireNonNull(range, "range must be non null");
        if (this.range.equals(range)) {
            return this;
        }
        return new ReadAsFutureByteString(range, this.hasher);
    }

    @BetaApi
    boolean getCrc32cValidationEnabled() {
        return Hasher.enabled().equals(this.hasher);
    }

    @BetaApi
    ReadAsFutureByteString withCrc32cValidationEnabled(boolean enabled) {
        if (enabled && Hasher.enabled().equals(this.hasher)) {
            return this;
        }
        if (!enabled && Hasher.noop().equals(this.hasher)) {
            return this;
        }
        return new ReadAsFutureByteString(this.range, enabled ? Hasher.enabled() : Hasher.noop());
    }

    @Override
    ReadProjectionConfigs.BaseConfig<ApiFuture<ZeroCopySupport.DisposableByteString>, ?> cast() {
        return this;
    }

    @Override
    BaseObjectReadSessionStreamRead.AccumulatingRead<ZeroCopySupport.DisposableByteString> newRead(long readId, RetryContext retryContext) {
        return ObjectReadSessionStreamRead.createZeroCopyByteStringAccumulatingRead(readId, this.range, this.hasher, retryContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReadAsFutureByteString)) {
            return false;
        }
        ReadAsFutureByteString that = (ReadAsFutureByteString)o;
        return Objects.equals(this.range, that.range) && Objects.equals(this.hasher, that.hasher);
    }

    public int hashCode() {
        return Objects.hash(this.range, this.hasher);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("range", this.range).add("crc32cValidationEnabled", this.getCrc32cValidationEnabled()).toString();
    }
}

