/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobAppendableUpload;
import com.google.cloud.storage.BlobAppendableUploadConfig;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobReadSession;
import com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.IOAutoCloseable;
import com.google.cloud.storage.Notification;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.ObjectReadSession;
import com.google.cloud.storage.ObjectReadSessionStreamRead;
import com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.storage.ReadProjectionConfig;
import com.google.cloud.storage.ReadProjectionConfigs;
import com.google.cloud.storage.ResponseContentLifecycleHandle;
import com.google.cloud.storage.RetryContext;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.TransportCompatibility;
import com.google.storage.v2.ReadRange;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class OtelStorageDecorator
implements Storage {
    private static final String OTEL_SCOPE_NAME = "cloud.google.com/java/storage";
    @VisibleForTesting
    final Storage delegate;
    private final OpenTelemetry otel;
    private final Attributes baseAttributes;
    private final Tracer tracer;

    private OtelStorageDecorator(Storage delegate, OpenTelemetry otel, Attributes baseAttributes) {
        this.delegate = delegate;
        this.otel = otel;
        this.baseAttributes = baseAttributes;
        this.tracer = TracerDecorator.decorate(null, otel, baseAttributes, Storage.class.getName() + "/");
    }

    @Override
    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucketInfo.getName())).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Bucket bucket = this.delegate.create(bucketInfo, options);
                if (ignore != null) {
                    ignore.close();
                }
                return bucket;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.create(blobInfo, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.create(blobInfo, content, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.create(blobInfo, content, offset, length, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    @Deprecated
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        Span span = this.tracer.spanBuilder("create").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.create(blobInfo, content, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, Storage.BlobWriteOption ... options) throws IOException {
        Span span = this.tracer.spanBuilder("createFrom").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.createFrom(blobInfo, path, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        Span span = this.tracer.spanBuilder("createFrom").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.createFrom(blobInfo, path, bufferSize, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) throws IOException {
        Span span = this.tracer.spanBuilder("createFrom").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.createFrom(blobInfo, content, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        Span span = this.tracer.spanBuilder("createFrom").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.createFrom(blobInfo, content, bufferSize, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        Span span = this.tracer.spanBuilder("get").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Bucket bucket2 = this.delegate.get(bucket, options);
                if (ignore != null) {
                    ignore.close();
                }
                return bucket2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Bucket lockRetentionPolicy(BucketInfo bucket, Storage.BucketTargetOption ... options) {
        Span span = this.tracer.spanBuilder("lockRetentionPolicy").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket.getName())).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Bucket bucket2 = this.delegate.lockRetentionPolicy(bucket, options);
                if (ignore != null) {
                    ignore.close();
                }
                return bucket2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        Span span = this.tracer.spanBuilder("get").setAttribute("gsutil.uri", String.format(Locale.US, "gs://%s/%s", bucket, blob)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob2 = this.delegate.get(bucket, blob, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob get(BlobId blob, Storage.BlobGetOption ... options) {
        Span span = this.tracer.spanBuilder("get").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob2 = this.delegate.get(blob, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob get(BlobId blob) {
        Span span = this.tracer.spanBuilder("get").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob2 = this.delegate.get(blob);
                if (ignore != null) {
                    ignore.close();
                }
                return blob2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob restore(BlobId blob, Storage.BlobRestoreOption ... options) {
        Span span = this.tracer.spanBuilder("restore").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob2 = this.delegate.restore(blob, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Page<Bucket> list(Storage.BucketListOption ... options) {
        Span span = this.tracer.spanBuilder("list").setAttribute("gsutil.uri", "gs://").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Page<Bucket> page = this.delegate.list(options);
                if (ignore != null) {
                    ignore.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        Span span = this.tracer.spanBuilder("list").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Page<Blob> page = this.delegate.list(bucket, options);
                if (ignore != null) {
                    ignore.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        Span span = this.tracer.spanBuilder("update").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucketInfo.getName())).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Bucket bucket = this.delegate.update(bucketInfo, options);
                if (ignore != null) {
                    ignore.close();
                }
                return bucket;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        Span span = this.tracer.spanBuilder("update").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.update(blobInfo, options);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob update(BlobInfo blobInfo) {
        Span span = this.tracer.spanBuilder("update").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.update(blobInfo);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("delete").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                boolean bl = this.delegate.delete(bucket, options);
                if (ignore != null) {
                    ignore.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("delete").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                boolean bl = this.delegate.delete(bucket, blob, options);
                if (ignore != null) {
                    ignore.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean delete(BlobId blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("delete").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                boolean bl = this.delegate.delete(blob, options);
                if (ignore != null) {
                    ignore.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean delete(BlobId blob) {
        Span span = this.tracer.spanBuilder("delete").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                boolean bl = this.delegate.delete(blob);
                if (ignore != null) {
                    ignore.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Blob compose(Storage.ComposeRequest composeRequest) {
        Span span = this.tracer.spanBuilder("compose").setAttribute("gsutil.uri", composeRequest.getTarget().getBlobId().toGsUtilUri()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.compose(composeRequest);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public CopyWriter copy(Storage.CopyRequest copyRequest) {
        Span span = this.tracer.spanBuilder("copy").setAttribute("gsutil.uri", copyRequest.getTarget().getBlobId().toGsUtilUri()).startSpan();
        Scope ignore = span.makeCurrent();
        try {
            CopyWriter copyWriter = this.delegate.copy(copyRequest);
            OtelDecoratedCopyWriter otelDecoratedCopyWriter = new OtelDecoratedCopyWriter(copyWriter, span);
            if (ignore != null) {
                ignore.close();
            }
            return otelDecoratedCopyWriter;
        }
        catch (Throwable throwable) {
            try {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t2) {
                span.recordException(t2);
                span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                span.end();
                throw t2;
            }
        }
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("readAllBytes").setAttribute("gsutil.uri", BlobId.of(bucket, blob).toGsUtilUri()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                byte[] byArray = this.delegate.readAllBytes(bucket, blob, options);
                if (ignore != null) {
                    ignore.close();
                }
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("readAllBytes").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                byte[] byArray = this.delegate.readAllBytes(blob, options);
                if (ignore != null) {
                    ignore.close();
                }
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public StorageBatch batch() {
        return this.delegate.batch();
    }

    @Override
    public ReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("reader").setAttribute("gsutil.uri", BlobId.of(bucket, blob).toGsUtilUriWithGeneration()).startSpan();
        Scope ignore = span.makeCurrent();
        try {
            ReadChannel reader = this.delegate.reader(bucket, blob, options);
            OtelDecoratedReadChannel otelDecoratedReadChannel = new OtelDecoratedReadChannel(reader, span);
            if (ignore != null) {
                ignore.close();
            }
            return otelDecoratedReadChannel;
        }
        catch (Throwable throwable) {
            try {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t2) {
                span.recordException(t2);
                span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                span.end();
                throw t2;
            }
        }
    }

    @Override
    public ReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("reader").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        Scope ignore = span.makeCurrent();
        try {
            ReadChannel reader = this.delegate.reader(blob, options);
            OtelDecoratedReadChannel otelDecoratedReadChannel = new OtelDecoratedReadChannel(reader, span);
            if (ignore != null) {
                ignore.close();
            }
            return otelDecoratedReadChannel;
        }
        catch (Throwable throwable) {
            try {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t2) {
                span.recordException(t2);
                span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                span.end();
                throw t2;
            }
        }
    }

    @Override
    public void downloadTo(BlobId blob, Path path, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("downloadTo").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try (Scope ignore = span.makeCurrent();){
            this.delegate.downloadTo(blob, path, options);
        }
        catch (Throwable t2) {
            span.recordException(t2);
            span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
            throw t2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public void downloadTo(BlobId blob, OutputStream outputStream, Storage.BlobSourceOption ... options) {
        Span span = this.tracer.spanBuilder("downloadTo").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try (Scope ignore = span.makeCurrent();){
            this.delegate.downloadTo(blob, outputStream, options);
        }
        catch (Throwable t2) {
            span.recordException(t2);
            span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
            throw t2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public WriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        Span sessionSpan = this.tracer.spanBuilder("writer").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        Scope ignore = sessionSpan.makeCurrent();
        try {
            WriteChannel writer = this.delegate.writer(blobInfo, options);
            OtelDecoratedWriteChannel otelDecoratedWriteChannel = new OtelDecoratedWriteChannel(writer, sessionSpan);
            if (ignore != null) {
                ignore.close();
            }
            return otelDecoratedWriteChannel;
        }
        catch (Throwable throwable) {
            try {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t2) {
                sessionSpan.recordException(t2);
                sessionSpan.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                sessionSpan.end();
                throw t2;
            }
        }
    }

    @Override
    public WriteChannel writer(URL signedURL) {
        Span sessionSpan = this.tracer.spanBuilder("writer").startSpan();
        Scope ignore = sessionSpan.makeCurrent();
        try {
            WriteChannel writer = this.delegate.writer(signedURL);
            OtelDecoratedWriteChannel otelDecoratedWriteChannel = new OtelDecoratedWriteChannel(writer, sessionSpan);
            if (ignore != null) {
                ignore.close();
            }
            return otelDecoratedWriteChannel;
        }
        catch (Throwable throwable) {
            try {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t2) {
                sessionSpan.recordException(t2);
                sessionSpan.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                sessionSpan.end();
                throw t2;
            }
        }
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        Span span = this.tracer.spanBuilder("signUrl").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                URL uRL = this.delegate.signUrl(blobInfo, duration, unit, options);
                if (ignore != null) {
                    ignore.close();
                }
                return uRL;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        Span span = this.tracer.spanBuilder("generateSignedPostPolicyV4").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                PostPolicyV4 postPolicyV4 = this.delegate.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, conditions, options);
                if (ignore != null) {
                    ignore.close();
                }
                return postPolicyV4;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, Storage.PostPolicyV4Option ... options) {
        Span span = this.tracer.spanBuilder("generateSignedPostPolicyV4").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                PostPolicyV4 postPolicyV4 = this.delegate.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, options);
                if (ignore != null) {
                    ignore.close();
                }
                return postPolicyV4;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        Span span = this.tracer.spanBuilder("generateSignedPostPolicyV4").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                PostPolicyV4 postPolicyV4 = this.delegate.generateSignedPostPolicyV4(blobInfo, duration, unit, conditions, options);
                if (ignore != null) {
                    ignore.close();
                }
                return postPolicyV4;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.PostPolicyV4Option ... options) {
        Span span = this.tracer.spanBuilder("generateSignedPostPolicyV4").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                PostPolicyV4 postPolicyV4 = this.delegate.generateSignedPostPolicyV4(blobInfo, duration, unit, options);
                if (ignore != null) {
                    ignore.close();
                }
                return postPolicyV4;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Blob> get(BlobId ... blobIds) {
        Span span = this.tracer.spanBuilder("get").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Blob> list = this.delegate.get(blobIds);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Blob> get(Iterable<BlobId> blobIds) {
        Span span = this.tracer.spanBuilder("get").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Blob> list = this.delegate.get(blobIds);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Blob> update(BlobInfo ... blobInfos) {
        Span span = this.tracer.spanBuilder("update").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Blob> list = this.delegate.update(blobInfos);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        Span span = this.tracer.spanBuilder("update").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Blob> list = this.delegate.update(blobInfos);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        Span span = this.tracer.spanBuilder("delete").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Boolean> list = this.delegate.delete(blobIds);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        Span span = this.tracer.spanBuilder("delete").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Boolean> list = this.delegate.delete(blobIds);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("getAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl = this.delegate.getAcl(bucket, entity, options);
                if (ignore != null) {
                    ignore.close();
                }
                return acl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("getAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl = this.delegate.getAcl(bucket, entity);
                if (ignore != null) {
                    ignore.close();
                }
                return acl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("deleteAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                boolean bl = this.delegate.deleteAcl(bucket, entity, options);
                if (ignore != null) {
                    ignore.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("deleteAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                boolean bl = this.delegate.deleteAcl(bucket, entity);
                if (ignore != null) {
                    ignore.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl createAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("createAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl2 = this.delegate.createAcl(bucket, acl, options);
                if (ignore != null) {
                    ignore.close();
                }
                return acl2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl createAcl(String bucket, Acl acl) {
        Span span = this.tracer.spanBuilder("createAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl2 = this.delegate.createAcl(bucket, acl);
                if (ignore != null) {
                    ignore.close();
                }
                return acl2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("updateAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl2 = this.delegate.updateAcl(bucket, acl, options);
                if (ignore != null) {
                    ignore.close();
                }
                return acl2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl) {
        Span span = this.tracer.spanBuilder("updateAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl2 = this.delegate.updateAcl(bucket, acl);
                if (ignore != null) {
                    ignore.close();
                }
                return acl2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Acl> listAcls(String bucket, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("listAcls").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Acl> list = this.delegate.listAcls(bucket, options);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Acl> listAcls(String bucket) {
        Span span = this.tracer.spanBuilder("listAcls").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Acl> list = this.delegate.listAcls(bucket);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl getDefaultAcl(String bucket, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("getDefaultAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl = this.delegate.getDefaultAcl(bucket, entity);
                if (ignore != null) {
                    ignore.close();
                }
                return acl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteDefaultAcl(String bucket, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("deleteDefaultAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                boolean bl = this.delegate.deleteDefaultAcl(bucket, entity);
                if (ignore != null) {
                    ignore.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl createDefaultAcl(String bucket, Acl acl) {
        Span span = this.tracer.spanBuilder("createDefaultAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl2 = this.delegate.createDefaultAcl(bucket, acl);
                if (ignore != null) {
                    ignore.close();
                }
                return acl2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl updateDefaultAcl(String bucket, Acl acl) {
        Span span = this.tracer.spanBuilder("updateDefaultAcl").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl2 = this.delegate.updateDefaultAcl(bucket, acl);
                if (ignore != null) {
                    ignore.close();
                }
                return acl2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Acl> listDefaultAcls(String bucket) {
        Span span = this.tracer.spanBuilder("listDefaultAcls").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Acl> list = this.delegate.listDefaultAcls(bucket);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl getAcl(BlobId blob, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("getAcl").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl = this.delegate.getAcl(blob, entity);
                if (ignore != null) {
                    ignore.close();
                }
                return acl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteAcl(BlobId blob, Acl.Entity entity) {
        Span span = this.tracer.spanBuilder("deleteAcl").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                boolean bl = this.delegate.deleteAcl(blob, entity);
                if (ignore != null) {
                    ignore.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl createAcl(BlobId blob, Acl acl) {
        Span span = this.tracer.spanBuilder("createAcl").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl2 = this.delegate.createAcl(blob, acl);
                if (ignore != null) {
                    ignore.close();
                }
                return acl2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Acl updateAcl(BlobId blob, Acl acl) {
        Span span = this.tracer.spanBuilder("updateAcl").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Acl acl2 = this.delegate.updateAcl(blob, acl);
                if (ignore != null) {
                    ignore.close();
                }
                return acl2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Acl> listAcls(BlobId blob) {
        Span span = this.tracer.spanBuilder("listAcls").setAttribute("gsutil.uri", blob.toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Acl> list = this.delegate.listAcls(blob);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public HmacKey createHmacKey(ServiceAccount serviceAccount, Storage.CreateHmacKeyOption ... options) {
        Span span = this.tracer.spanBuilder("createHmacKey").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                HmacKey hmacKey = this.delegate.createHmacKey(serviceAccount, options);
                if (ignore != null) {
                    ignore.close();
                }
                return hmacKey;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(Storage.ListHmacKeysOption ... options) {
        Span span = this.tracer.spanBuilder("listHmacKeys").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Page<HmacKey.HmacKeyMetadata> page = this.delegate.listHmacKeys(options);
                if (ignore != null) {
                    ignore.close();
                }
                return page;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public HmacKey.HmacKeyMetadata getHmacKey(String accessId, Storage.GetHmacKeyOption ... options) {
        Span span = this.tracer.spanBuilder("getHmacKey").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                HmacKey.HmacKeyMetadata hmacKeyMetadata = this.delegate.getHmacKey(accessId, options);
                if (ignore != null) {
                    ignore.close();
                }
                return hmacKeyMetadata;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public void deleteHmacKey(HmacKey.HmacKeyMetadata hmacKeyMetadata, Storage.DeleteHmacKeyOption ... options) {
        Span span = this.tracer.spanBuilder("deleteHmacKey").startSpan();
        try (Scope ignore = span.makeCurrent();){
            this.delegate.deleteHmacKey(hmacKeyMetadata, options);
        }
        catch (Throwable t2) {
            span.recordException(t2);
            span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
            throw t2;
        }
        finally {
            span.end();
        }
    }

    @Override
    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata hmacKeyMetadata, HmacKey.HmacKeyState state, Storage.UpdateHmacKeyOption ... options) {
        Span span = this.tracer.spanBuilder("updateHmacKeyState").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                HmacKey.HmacKeyMetadata hmacKeyMetadata2 = this.delegate.updateHmacKeyState(hmacKeyMetadata, state, options);
                if (ignore != null) {
                    ignore.close();
                }
                return hmacKeyMetadata2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Policy getIamPolicy(String bucket, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("getIamPolicy").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Policy policy = this.delegate.getIamPolicy(bucket, options);
                if (ignore != null) {
                    ignore.close();
                }
                return policy;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Policy setIamPolicy(String bucket, Policy policy, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("setIamPolicy").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Policy policy2 = this.delegate.setIamPolicy(bucket, policy, options);
                if (ignore != null) {
                    ignore.close();
                }
                return policy2;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Boolean> testIamPermissions(String bucket, List<String> permissions, Storage.BucketSourceOption ... options) {
        Span span = this.tracer.spanBuilder("testIamPermissions").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Boolean> list = this.delegate.testIamPermissions(bucket, permissions, options);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public ServiceAccount getServiceAccount(String projectId) {
        Span span = this.tracer.spanBuilder("getServiceAccount").startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                ServiceAccount serviceAccount = this.delegate.getServiceAccount(projectId);
                if (ignore != null) {
                    ignore.close();
                }
                return serviceAccount;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Notification createNotification(String bucket, NotificationInfo notificationInfo) {
        Span span = this.tracer.spanBuilder("createNotification").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Notification notification = this.delegate.createNotification(bucket, notificationInfo);
                if (ignore != null) {
                    ignore.close();
                }
                return notification;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public Notification getNotification(String bucket, String notificationId) {
        Span span = this.tracer.spanBuilder("getNotification").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Notification notification = this.delegate.getNotification(bucket, notificationId);
                if (ignore != null) {
                    ignore.close();
                }
                return notification;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public List<Notification> listNotifications(String bucket) {
        Span span = this.tracer.spanBuilder("listNotifications").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                List<Notification> list = this.delegate.listNotifications(bucket);
                if (ignore != null) {
                    ignore.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean deleteNotification(String bucket, String notificationId) {
        Span span = this.tracer.spanBuilder("deleteNotification").setAttribute("gsutil.uri", OtelStorageDecorator.fmtBucket(bucket)).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                boolean bl = this.delegate.deleteNotification(bucket, notificationId);
                if (ignore != null) {
                    ignore.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    @BetaApi
    public BlobWriteSession blobWriteSession(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        Span sessionSpan = this.tracer.spanBuilder("blobWriteSession").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = sessionSpan.makeCurrent();
            try {
                BlobWriteSession session = this.delegate.blobWriteSession(blobInfo, options);
                OtelDecoratedBlobWriteSession otelDecoratedBlobWriteSession = new OtelDecoratedBlobWriteSession(session);
                if (ignore != null) {
                    ignore.close();
                }
                return otelDecoratedBlobWriteSession;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    sessionSpan.recordException(t2);
                    sessionSpan.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            sessionSpan.end();
        }
    }

    @Override
    public Blob moveBlob(Storage.MoveBlobRequest request) {
        Span span = this.tracer.spanBuilder("moveBlob").setAttribute("gsutil.uri.source", request.getSource().toGsUtilUriWithGeneration()).setAttribute("gsutil.uri.target", request.getTarget().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                Blob blob = this.delegate.moveBlob(request);
                if (ignore != null) {
                    ignore.close();
                }
                return blob;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public ApiFuture<BlobReadSession> blobReadSession(BlobId id, Storage.BlobSourceOption ... options) {
        Span blobReadSessionSpan = this.tracer.spanBuilder("blobReadSession").setAttribute("gsutil.uri", id.toGsUtilUriWithGeneration()).startSpan();
        Scope ignore1 = blobReadSessionSpan.makeCurrent();
        try {
            Context blobReadSessionContext = Context.current();
            Span ready = this.tracer.spanBuilder("blobReadSession/ready").startSpan();
            ApiFuture<BlobReadSession> blobReadSessionApiFuture = this.delegate.blobReadSession(id, options);
            ApiFuture<BlobReadSession> futureDecorated = ApiFutures.transform(blobReadSessionApiFuture, delegate -> {
                ready.end();
                return new OtelDecoratingBlobReadSession((BlobReadSession)delegate, id, blobReadSessionContext, blobReadSessionSpan);
            }, MoreExecutors.directExecutor());
            ApiFutures.addCallback(futureDecorated, t2 -> {
                blobReadSessionSpan.recordException(t2);
                blobReadSessionSpan.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                blobReadSessionSpan.end();
                ready.recordException(t2);
                ready.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                ready.end();
            }, MoreExecutors.directExecutor());
            ApiFuture<BlobReadSession> apiFuture = futureDecorated;
            if (ignore1 != null) {
                ignore1.close();
            }
            return apiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignore1 != null) {
                    try {
                        ignore1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t3) {
                blobReadSessionSpan.recordException(t3);
                blobReadSessionSpan.setStatus(StatusCode.ERROR, t3.getClass().getSimpleName());
                blobReadSessionSpan.end();
                throw t3;
            }
        }
    }

    @Override
    public BlobAppendableUpload blobAppendableUpload(BlobInfo blobInfo, BlobAppendableUploadConfig uploadConfig, Storage.BlobWriteOption ... options) {
        Span span = this.tracer.spanBuilder("appendableBlobUpload").setAttribute("gsutil.uri", blobInfo.getBlobId().toGsUtilUriWithGeneration()).startSpan();
        try {
            Scope ignore = span.makeCurrent();
            try {
                OtelDecoratingBlobAppendableUpload otelDecoratingBlobAppendableUpload = new OtelDecoratingBlobAppendableUpload(this.delegate.blobAppendableUpload(blobInfo, uploadConfig, options));
                if (ignore != null) {
                    ignore.close();
                }
                return otelDecoratingBlobAppendableUpload;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    span.recordException(t2);
                    span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }
        finally {
            span.end();
        }
    }

    @Override
    public StorageOptions getOptions() {
        return (StorageOptions)this.delegate.getOptions();
    }

    static Storage decorate(Storage delegate, OpenTelemetry otel, TransportCompatibility.Transport transport) {
        Objects.requireNonNull(delegate, "delegate must be non null");
        Objects.requireNonNull(otel, "otel must be non null");
        if (otel == OpenTelemetry.noop()) {
            return delegate;
        }
        Attributes baseAttributes = Attributes.builder().put("gcp.client.service", "Storage").put("gcp.client.version", StorageOptions.getDefaultInstance().getLibraryVersion()).put("gcp.client.repo", "googleapis/java-storage").put("gcp.client.artifact", "com.google.cloud:google-cloud-storage").put("rpc.system", transport.toString().toLowerCase(Locale.ROOT)).put("service.name", "storage.googleapis.com").build();
        return new OtelStorageDecorator(delegate, otel, baseAttributes);
    }

    static UnaryOperator<RetryContext> retryContextDecorator(OpenTelemetry otel) {
        Objects.requireNonNull(otel, "otel must be non null");
        if (otel == OpenTelemetry.noop()) {
            return UnaryOperator.identity();
        }
        return ctx -> new OtelRetryContextDecorator((RetryContext)ctx, Span.current());
    }

    private static @NonNull String fmtBucket(String bucket) {
        return String.format(Locale.US, "gs://%s/", bucket);
    }

    private static final class TracerDecorator
    implements Tracer {
        private final @Nullable Context parentContextOverride;
        private final Tracer delegate;
        private final Attributes baseAttributes;
        private final String spanNamePrefix;

        private TracerDecorator(@Nullable Context parentContextOverride, Tracer delegate, Attributes baseAttributes, String spanNamePrefix) {
            this.parentContextOverride = parentContextOverride;
            this.delegate = delegate;
            this.baseAttributes = baseAttributes;
            this.spanNamePrefix = spanNamePrefix;
        }

        private static TracerDecorator decorate(@Nullable Context parentContextOverride, OpenTelemetry otel, Attributes baseAttributes, String spanNamePrefix) {
            Objects.requireNonNull(otel, "otel must be non null");
            Objects.requireNonNull(baseAttributes, "baseAttributes must be non null");
            Objects.requireNonNull(spanNamePrefix, "spanNamePrefix must be non null");
            Tracer tracer = otel.getTracer(OtelStorageDecorator.OTEL_SCOPE_NAME, StorageOptions.getDefaultInstance().getLibraryVersion());
            return new TracerDecorator(parentContextOverride, tracer, baseAttributes, spanNamePrefix);
        }

        @Override
        public SpanBuilder spanBuilder(String spanName) {
            SpanBuilder spanBuilder = this.delegate.spanBuilder(this.spanNamePrefix + spanName).setAllAttributes(this.baseAttributes);
            if (this.parentContextOverride != null) {
                spanBuilder.setParent(this.parentContextOverride);
            }
            return spanBuilder;
        }
    }

    private final class OtelDecoratedCopyWriter
    extends CopyWriter {
        private final CopyWriter copyWriter;
        private final Span span;
        private final Context parentContext;
        private final Tracer tracer;

        public OtelDecoratedCopyWriter(CopyWriter copyWriter, Span span) {
            this.copyWriter = copyWriter;
            this.span = span;
            this.parentContext = Context.current();
            this.tracer = TracerDecorator.decorate(Context.current(), OtelStorageDecorator.this.otel, OtelStorageDecorator.this.baseAttributes, CopyWriter.class.getName() + "/");
        }

        @Override
        public Blob getResult() {
            try {
                Blob blob = this.copyWriter.getResult();
                return blob;
            }
            catch (Throwable t2) {
                this.span.recordException(t2);
                this.span.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                throw t2;
            }
            finally {
                this.span.end();
            }
        }

        @Override
        public long getBlobSize() {
            return this.copyWriter.getBlobSize();
        }

        @Override
        public boolean isDone() {
            boolean done = this.copyWriter.isDone();
            if (done) {
                this.span.end();
            }
            return done;
        }

        @Override
        public long getTotalBytesCopied() {
            return this.copyWriter.getTotalBytesCopied();
        }

        @Override
        public RestorableState<CopyWriter> capture() {
            return this.copyWriter.capture();
        }

        @Override
        public void copyChunk() {
            Span copyChunkSpan = this.tracer.spanBuilder("copyChunk").setParent(this.parentContext).startSpan();
            try (Scope ignore = copyChunkSpan.makeCurrent();){
                this.copyWriter.copyChunk();
            }
            catch (Throwable t2) {
                copyChunkSpan.recordException(t2);
                copyChunkSpan.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                this.span.end();
                throw t2;
            }
            finally {
                copyChunkSpan.end();
            }
        }
    }

    @VisibleForTesting
    static final class OtelDecoratedReadChannel
    implements ReadChannel {
        @VisibleForTesting
        final ReadChannel reader;
        private final Span span;

        private OtelDecoratedReadChannel(ReadChannel reader, Span span) {
            this.reader = reader;
            this.span = span;
        }

        @Override
        public void seek(long position) throws IOException {
            this.reader.seek(position);
        }

        @Override
        public void setChunkSize(int chunkSize) {
            this.reader.setChunkSize(chunkSize);
        }

        @Override
        public RestorableState<ReadChannel> capture() {
            return this.reader.capture();
        }

        @Override
        public ReadChannel limit(long limit) {
            return this.reader.limit(limit);
        }

        @Override
        public long limit() {
            return this.reader.limit();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.reader.read(dst);
        }

        @Override
        public boolean isOpen() {
            return this.reader.isOpen();
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            finally {
                this.span.end();
            }
        }
    }

    @VisibleForTesting
    static final class OtelDecoratedWriteChannel
    implements WriteChannel {
        @VisibleForTesting
        final WriteChannel delegate;
        private final Span openSpan;

        private OtelDecoratedWriteChannel(WriteChannel delegate, Span openSpan) {
            this.delegate = delegate;
            this.openSpan = openSpan;
        }

        @Override
        public void setChunkSize(int chunkSize) {
            this.delegate.setChunkSize(chunkSize);
        }

        @Override
        public RestorableState<WriteChannel> capture() {
            return this.delegate.capture();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            catch (IOException | RuntimeException e) {
                this.openSpan.recordException(e);
                this.openSpan.setStatus(StatusCode.ERROR, e.getClass().getSimpleName());
                throw e;
            }
            finally {
                this.openSpan.end();
            }
        }
    }

    private final class OtelDecoratedBlobWriteSession
    implements BlobWriteSession {
        private final BlobWriteSession delegate;
        private final Tracer tracer;

        public OtelDecoratedBlobWriteSession(BlobWriteSession delegate) {
            this.delegate = delegate;
            this.tracer = TracerDecorator.decorate(Context.current(), OtelStorageDecorator.this.otel, OtelStorageDecorator.this.baseAttributes, BlobWriteSession.class.getName() + "/");
        }

        @Override
        public WritableByteChannel open() throws IOException {
            Span openSpan = this.tracer.spanBuilder("open").startSpan();
            Scope ignore = openSpan.makeCurrent();
            try {
                WritableByteChannel delegate = this.delegate.open();
                OtelDecoratingWritableByteChannel otelDecoratingWritableByteChannel = new OtelDecoratingWritableByteChannel(delegate, openSpan);
                if (ignore != null) {
                    ignore.close();
                }
                return otelDecoratingWritableByteChannel;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    openSpan.recordException(t2);
                    openSpan.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }

        @Override
        public ApiFuture<BlobInfo> getResult() {
            return this.delegate.getResult();
        }

        private class OtelDecoratingWritableByteChannel
        implements WritableByteChannel {
            private final WritableByteChannel delegate;
            private final Span openSpan;

            private OtelDecoratingWritableByteChannel(WritableByteChannel delegate, Span openSpan) {
                this.delegate = delegate;
                this.openSpan = openSpan;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return this.delegate.write(src);
            }

            @Override
            public boolean isOpen() {
                return this.delegate.isOpen();
            }

            @Override
            public void close() throws IOException {
                try {
                    this.delegate.close();
                }
                catch (IOException | RuntimeException e) {
                    this.openSpan.recordException(e);
                    this.openSpan.setStatus(StatusCode.ERROR, e.getClass().getSimpleName());
                    throw e;
                }
                finally {
                    this.openSpan.end();
                }
            }
        }
    }

    final class OtelDecoratingBlobAppendableUpload
    implements BlobAppendableUpload {
        private final BlobAppendableUpload delegate;
        private final Tracer tracer;

        private OtelDecoratingBlobAppendableUpload(BlobAppendableUpload delegate) {
            this.delegate = delegate;
            this.tracer = TracerDecorator.decorate(Context.current(), OtelStorageDecorator.this.otel, OtelStorageDecorator.this.baseAttributes, BlobAppendableUpload.class.getName() + "/");
        }

        @Override
        public BlobAppendableUpload.AppendableUploadWriteableByteChannel open() throws IOException {
            Span openSpan = this.tracer.spanBuilder("open").startSpan();
            Scope ignore = openSpan.makeCurrent();
            try {
                BlobAppendableUpload.AppendableUploadWriteableByteChannel delegate = this.delegate.open();
                OtelDecoratingAppendableUploadWriteableByteChannel otelDecoratingAppendableUploadWriteableByteChannel = new OtelDecoratingAppendableUploadWriteableByteChannel(delegate, openSpan);
                if (ignore != null) {
                    ignore.close();
                }
                return otelDecoratingAppendableUploadWriteableByteChannel;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    openSpan.recordException(t2);
                    openSpan.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                    throw t2;
                }
            }
        }

        @Override
        public ApiFuture<BlobInfo> getResult() {
            return this.delegate.getResult();
        }

        private final class OtelDecoratingAppendableUploadWriteableByteChannel
        implements BlobAppendableUpload.AppendableUploadWriteableByteChannel {
            private final BlobAppendableUpload.AppendableUploadWriteableByteChannel delegate;
            private final Span openSpan;

            private OtelDecoratingAppendableUploadWriteableByteChannel(BlobAppendableUpload.AppendableUploadWriteableByteChannel delegate, Span openSpan) {
                this.delegate = delegate;
                this.openSpan = openSpan;
            }

            @Override
            @BetaApi
            public void finalizeAndClose() throws IOException {
                try {
                    this.delegate.finalizeAndClose();
                }
                catch (IOException | RuntimeException e) {
                    this.openSpan.recordException(e);
                    this.openSpan.setStatus(StatusCode.ERROR, e.getClass().getSimpleName());
                    throw e;
                }
                finally {
                    this.openSpan.end();
                }
            }

            @Override
            @BetaApi
            public void closeWithoutFinalizing() throws IOException {
                try {
                    this.delegate.closeWithoutFinalizing();
                }
                catch (IOException | RuntimeException e) {
                    this.openSpan.recordException(e);
                    this.openSpan.setStatus(StatusCode.ERROR, e.getClass().getSimpleName());
                    throw e;
                }
                finally {
                    this.openSpan.end();
                }
            }

            @Override
            @BetaApi
            public void close() throws IOException {
                try {
                    this.delegate.close();
                }
                catch (IOException | RuntimeException e) {
                    this.openSpan.recordException(e);
                    this.openSpan.setStatus(StatusCode.ERROR, e.getClass().getSimpleName());
                    throw e;
                }
                finally {
                    this.openSpan.end();
                }
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return this.delegate.write(src);
            }

            @Override
            public boolean isOpen() {
                return this.delegate.isOpen();
            }
        }
    }

    private static final class OtelRetryContextDecorator
    implements RetryContext {
        private final RetryContext delegate;
        private final Span span;

        private OtelRetryContextDecorator(RetryContext delegate, Span span) {
            this.delegate = delegate;
            this.span = span;
        }

        @Override
        public boolean inBackoff() {
            return this.delegate.inBackoff();
        }

        @Override
        public void reset() {
            this.delegate.reset();
        }

        @Override
        public <T extends Throwable> void recordError(T t2, RetryContext.OnSuccess onSuccess, RetryContext.OnFailure<T> onFailure) {
            this.span.recordException(t2);
            this.delegate.recordError(t2, () -> {
                this.span.addEvent("retrying");
                onSuccess.onSuccess();
            }, tt -> {
                this.span.addEvent("terminal_failure");
                onFailure.onFailure(tt);
            });
        }
    }

    @VisibleForTesting
    class OtelDecoratingBlobReadSession
    implements BlobReadSession {
        @VisibleForTesting
        final BlobReadSession delegate;
        private final BlobId id;
        private final Context blobReadSessionContext;
        private final Span blobReadSessionSpan;

        private OtelDecoratingBlobReadSession(BlobReadSession delegate, BlobId id, Context blobReadSessionContext, Span blobReadSessionSpan) {
            this.delegate = delegate;
            this.id = id;
            this.blobReadSessionContext = blobReadSessionContext;
            this.blobReadSessionSpan = blobReadSessionSpan;
        }

        @Override
        public BlobInfo getBlobInfo() {
            return this.delegate.getBlobInfo();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <Projection> Projection readAs(ReadProjectionConfig<Projection> config) {
            Span readRangeSpan = OtelStorageDecorator.this.tracer.spanBuilder("readAs").setAttribute("gsutil.uri", this.id.toGsUtilUriWithGeneration()).setParent(this.blobReadSessionContext).startSpan();
            try (Scope ignore2 = readRangeSpan.makeCurrent();){
                OtelReadProjectionConfig c = new OtelReadProjectionConfig(config, readRangeSpan);
                Object Projection2 = this.delegate.readAs(c);
                return Projection2;
            }
            catch (Throwable t2) {
                readRangeSpan.recordException(t2);
                readRangeSpan.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                readRangeSpan.end();
                throw t2;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.blobReadSessionSpan.end();
            }
        }
    }

    @VisibleForTesting
    static final class OtelDecoratingObjectReadSessionStreamRead<Projection>
    implements ObjectReadSessionStreamRead<Projection> {
        private final ObjectReadSessionStreamRead<Projection> delegate;
        private final Span parentSpan;

        @VisibleForTesting
        OtelDecoratingObjectReadSessionStreamRead(ObjectReadSessionStreamRead<Projection> delegate, Span parentSpan) {
            this.delegate = delegate;
            this.parentSpan = parentSpan;
        }

        @Override
        public Projection project() {
            return this.delegate.project();
        }

        @Override
        public long readOffset() {
            return this.delegate.readOffset();
        }

        @Override
        public boolean acceptingBytes() {
            return this.delegate.acceptingBytes();
        }

        @Override
        public void accept(ResponseContentLifecycleHandle.ChildRef childRef) throws IOException {
            this.delegate.accept(childRef);
        }

        @Override
        public void eof() throws IOException {
            this.delegate.eof();
        }

        @Override
        public void preFail() {
            this.delegate.preFail();
        }

        @Override
        public ApiFuture<?> fail(Throwable t2) {
            ApiFuture<?> fail = this.delegate.fail(t2);
            ApiFutures.addCallback(fail, t1 -> {
                this.parentSpan.recordException(t1);
                this.parentSpan.setStatus(StatusCode.ERROR, t1.getClass().getSimpleName());
            }, MoreExecutors.directExecutor());
            return fail;
        }

        @Override
        public Hasher hasher() {
            return this.delegate.hasher();
        }

        @Override
        public ObjectReadSessionStreamRead<Projection> withNewReadId(long newReadId) {
            return new OtelDecoratingObjectReadSessionStreamRead<Projection>(this.delegate.withNewReadId(newReadId), this.parentSpan);
        }

        @Override
        public ReadRange makeReadRange() {
            return this.delegate.makeReadRange();
        }

        @Override
        public <T extends Throwable> void recordError(T t2, RetryContext.OnSuccess onSuccess, RetryContext.OnFailure<T> onFailure) {
            this.delegate.recordError(t2, onSuccess, onFailure);
        }

        @Override
        public boolean readyToSend() {
            return this.delegate.readyToSend();
        }

        @Override
        public boolean canShareStreamWith(ObjectReadSessionStreamRead<?> other) {
            if (other instanceof OtelDecoratingObjectReadSessionStreamRead) {
                OtelDecoratingObjectReadSessionStreamRead dec = (OtelDecoratingObjectReadSessionStreamRead)other;
                return this.delegate.canShareStreamWith(dec.delegate);
            }
            return this.delegate.canShareStreamWith(other);
        }

        @Override
        public void setOnCloseCallback(IOAutoCloseable onCloseCallback) {
            this.delegate.setOnCloseCallback(onCloseCallback);
        }

        @Override
        public void internalClose() throws IOException {
            this.delegate.internalClose();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("delegate", this.delegate).toString();
        }
    }

    private static final class OtelReadProjectionConfig<Projection>
    extends ReadProjectionConfig<Projection> {
        private final ReadProjectionConfig<Projection> delegate;
        private final Span parentSpan;

        private OtelReadProjectionConfig(ReadProjectionConfig<Projection> delegate, Span parentSpan) {
            this.delegate = delegate;
            this.parentSpan = parentSpan;
        }

        @Override
        ReadProjectionConfigs.BaseConfig<Projection, ?> cast() {
            return new OtelBaseConfigDecorator(this.delegate.cast());
        }

        @Override
        public ReadProjectionConfig.ProjectionType getType() {
            return this.delegate.getType();
        }

        @Override
        Projection project(ObjectReadSession session, IOAutoCloseable closeAlongWith) {
            try {
                return this.delegate.project(session, closeAlongWith.andThen(this.parentSpan::end));
            }
            catch (Throwable t2) {
                this.parentSpan.recordException(t2);
                this.parentSpan.setStatus(StatusCode.ERROR, t2.getClass().getSimpleName());
                this.parentSpan.end();
                throw t2;
            }
        }

        private class OtelBaseConfigDecorator
        extends ReadProjectionConfigs.BaseConfig<Projection, ObjectReadSessionStreamRead<Projection>> {
            private final ReadProjectionConfigs.BaseConfig<Projection, ?> delegate;

            private OtelBaseConfigDecorator(ReadProjectionConfigs.BaseConfig<Projection, ?> delegate) {
                this.delegate = delegate;
            }

            @Override
            ObjectReadSessionStreamRead<Projection> newRead(long readId, RetryContext retryContext) {
                OtelRetryContextDecorator otelRetryContext = new OtelRetryContextDecorator(retryContext, OtelReadProjectionConfig.this.parentSpan);
                Object read = this.delegate.newRead(readId, otelRetryContext);
                read.setOnCloseCallback(OtelReadProjectionConfig.this.parentSpan::end);
                return new OtelDecoratingObjectReadSessionStreamRead(read, OtelReadProjectionConfig.this.parentSpan);
            }

            @Override
            ReadProjectionConfigs.BaseConfig<Projection, ?> cast() {
                return this;
            }
        }
    }
}

