/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.IOAutoCloseable;
import com.google.cloud.storage.ObjectReadSession;
import com.google.cloud.storage.ObjectReadSessionState;
import com.google.cloud.storage.ObjectReadSessionStream;
import com.google.cloud.storage.ObjectReadSessionStreamRead;
import com.google.cloud.storage.ReadProjectionConfig;
import com.google.cloud.storage.RetryContext;
import com.google.storage.v2.BidiReadObjectRequest;
import com.google.storage.v2.BidiReadObjectResponse;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;

final class ObjectReadSessionImpl
implements ObjectReadSession {
    private final ScheduledExecutorService executor;
    private final GrpcUtils.ZeroCopyBidiStreamingCallable<BidiReadObjectRequest, BidiReadObjectResponse> callable;
    private final ObjectReadSessionStream stream;
    @VisibleForTesting
    final ObjectReadSessionState state;
    private final com.google.storage.v2.Object resource;
    private final RetryContext.RetryContextProvider retryContextProvider;
    private final ConcurrentIdentityMap<ObjectReadSessionStream, ObjectReadSessionState> children;
    private volatile boolean open;

    ObjectReadSessionImpl(ScheduledExecutorService executor, GrpcUtils.ZeroCopyBidiStreamingCallable<BidiReadObjectRequest, BidiReadObjectResponse> callable, ObjectReadSessionStream stream, ObjectReadSessionState state, RetryContext.RetryContextProvider retryContextProvider) {
        this.executor = executor;
        this.callable = callable;
        this.stream = stream;
        this.state = state;
        this.resource = state.getMetadata();
        this.retryContextProvider = retryContextProvider;
        this.children = new ConcurrentIdentityMap();
        this.open = true;
    }

    @Override
    public com.google.storage.v2.Object getResource() {
        return this.resource;
    }

    @Override
    public <Projection> Projection readAs(ReadProjectionConfig<Projection> config) {
        Preconditions.checkState(this.open, "Session already closed");
        switch (config.getType()) {
            case STREAM_READ: {
                long readId = this.state.newReadId();
                Object read = config.cast().newRead(readId, this.retryContextProvider.create());
                this.registerReadInState(readId, (ObjectReadSessionStreamRead<?>)read);
                return read.project();
            }
            case SESSION_USER: {
                return config.project(this, IOAutoCloseable.noOp());
            }
        }
        throw new IllegalStateException(String.format(Locale.US, "Broken java enum %s value=%s", ReadProjectionConfig.ProjectionType.class.getName(), config.getType().name()));
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.open) {
                return;
            }
            this.open = false;
            ArrayList<ApiFuture> closing = this.children.drainEntries((subStream, subStreamState) -> subStream.closeAsync());
            this.stream.close();
            ApiFutures.allAsList(closing).get();
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    private void registerReadInState(long readId, ObjectReadSessionStreamRead<?> read) {
        BidiReadObjectRequest request = BidiReadObjectRequest.newBuilder().addReadRanges(read.makeReadRange()).build();
        if (this.state.canHandleNewRead(read)) {
            this.state.putOutstandingRead(readId, read);
            this.stream.send(request);
        } else {
            ObjectReadSessionState child = this.state.forkChild();
            ObjectReadSessionStream newStream = ObjectReadSessionStream.create(this.executor, this.callable, child, this.retryContextProvider.create());
            this.children.put(newStream, child);
            read.setOnCloseCallback(() -> {
                this.children.remove(newStream);
                newStream.close();
            });
            child.putOutstandingRead(readId, read);
            newStream.send(request);
        }
    }

    @VisibleForTesting
    static final class ConcurrentIdentityMap<K, V> {
        private final ReentrantLock lock = new ReentrantLock();
        private final IdentityHashMap<K, V> children = new IdentityHashMap();

        @VisibleForTesting
        ConcurrentIdentityMap() {
        }

        public void put(K key, V value) {
            this.lock.lock();
            try {
                this.children.put(key, value);
            }
            finally {
                this.lock.unlock();
            }
        }

        public void remove(K key) {
            this.lock.lock();
            try {
                this.children.remove(key);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> ArrayList<R> drainEntries(BiFunction<K, V, R> f) {
            this.lock.lock();
            try {
                Iterator<Map.Entry<K, V>> it = this.children.entrySet().iterator();
                ArrayList<R> results = new ArrayList<R>(this.children.size());
                while (it.hasNext()) {
                    Map.Entry<K, V> entry = it.next();
                    K key = entry.getKey();
                    V value = entry.getValue();
                    it.remove();
                    R r = f.apply(key, value);
                    results.add(r);
                }
                ArrayList<R> arrayList = results;
                return arrayList;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

