/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Conversions;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MetadataField<T> {
    private static final Conversions.Codec<Long, String> CODEC_LONG = Conversions.Codec.of(String::valueOf, Long::parseLong).nullable();
    private static final Conversions.Codec<String, String> CODEC_STRING = Conversions.Codec.of((X s2) -> s2, (Y s2) -> s2).nullable();
    private final String key;
    private final Conversions.Codec<T, String> codec;

    private MetadataField(String key, Conversions.Codec<T, String> codec) {
        this.key = key;
        this.codec = codec;
    }

    void appendTo(@NonNull T t2, ImmutableMap.Builder<String, String> b) {
        b.put(this.key, (String)this.codec.encode(t2));
    }

    @Nullable T readFrom(BlobInfo info) {
        Map<String, String> map = info.getMetadata();
        if (map != null) {
            return this.readFrom(map);
        }
        return null;
    }

    @VisibleForTesting
    @Nullable T readFrom(Map<String, String> m4) {
        return (T)this.codec.decode(m4.get(this.key));
    }

    static MetadataField<Long> forLong(String key) {
        return MetadataField.of(key, CODEC_LONG);
    }

    static MetadataField<String> forString(String key) {
        return MetadataField.of(key, CODEC_STRING);
    }

    static MetadataField<PartRange> forPartRange(String key) {
        return MetadataField.of(key, PartRange.CODEC);
    }

    private static <T> MetadataField<T> of(String key, Conversions.Codec<T, String> codec) {
        return new MetadataField<T>(key, codec);
    }

    static final class PartRange {
        private static final Conversions.Codec<PartRange, String> CODEC = Conversions.Codec.of(PartRange::encode, PartRange::decode).nullable();
        static final Comparator<PartRange> COMP = Comparator.comparingLong(PartRange::getBegin).thenComparingLong(PartRange::getEnd);
        private final long begin;
        private final long end;

        private PartRange(long begin, long end) {
            this.begin = begin;
            this.end = end;
        }

        public long getBegin() {
            return this.begin;
        }

        public long getEnd() {
            return this.end;
        }

        String encode() {
            return String.format(Locale.US, "%04d-%04d", this.begin, this.end);
        }

        static PartRange decode(String s2) {
            int splitPoint = s2.indexOf("-");
            long being = Long.parseLong(s2.substring(0, splitPoint));
            long end = Long.parseLong(s2.substring(splitPoint + 1));
            return PartRange.of(being, end);
        }

        static PartRange of(long begin) {
            return PartRange.of(begin, begin);
        }

        static PartRange of(long begin, long end) {
            return new PartRange(begin, end);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PartRange)) {
                return false;
            }
            PartRange partRange = (PartRange)o;
            return this.begin == partRange.begin && this.end == partRange.end;
        }

        public int hashCode() {
            return Objects.hash(this.begin, this.end);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("begin", this.begin).add("end", this.end).toString();
        }
    }
}

