/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.ErrorDetails;
import com.google.api.gax.rpc.OutOfRangeException;
import com.google.cloud.storage.AsyncStorageTaskException;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.ResumableSessionFailureScenario;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.storage.WriteCtx;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ObjectChecksums;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.ByteString;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class GapicUnbufferedChunkedResumableWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final SettableApiFuture<WriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write;
    private final String bucketName;
    private final WriteCtx<ResumableWrite> writeCtx;
    private final Retrying.RetrierWithAlg retrier;
    private final Supplier<GrpcCallContext> baseContextSupplier;
    private volatile boolean open = true;
    private boolean finished = false;

    GapicUnbufferedChunkedResumableWritableByteChannel(SettableApiFuture<WriteObjectResponse> resultFuture, @NonNull ChunkSegmenter chunkSegmenter, ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, WriteCtx<ResumableWrite> writeCtx, Retrying.RetrierWithAlg retrier, Supplier<GrpcCallContext> baseContextSupplier) {
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        this.write = write;
        this.bucketName = writeCtx.getRequestFactory().bucketName();
        this.writeCtx = writeCtx;
        this.retrier = retrier;
        this.baseContextSupplier = baseContextSupplier;
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        return this.internalWrite(srcs, srcsOffset, srcsLength, false);
    }

    @Override
    public long writeAndClose(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        long write = this.internalWrite(srcs, srcsOffset, srcsLength, true);
        this.close();
        return write;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (this.open && !this.finished) {
            WriteObjectRequest message = this.finishMessage(true);
            try {
                this.flush(ImmutableList.of(message), null, true);
                this.finished = true;
            }
            catch (RuntimeException e) {
                this.resultFuture.setException(e);
                throw e;
            }
        }
        this.open = false;
    }

    private long internalWrite(ByteBuffer[] srcs, int srcsOffset, int srcsLength, boolean finalize) throws ClosedChannelException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        long begin = this.writeCtx.getConfirmedBytes().get();
        RewindableContent content = RewindableContent.of(srcs, srcsOffset, srcsLength);
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcsLength, finalize);
        if (data.length == 0) {
            return 0L;
        }
        ArrayList<WriteObjectRequest> messages = new ArrayList<WriteObjectRequest>();
        boolean first = true;
        for (ChunkSegmenter.ChunkSegment datum : data) {
            Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
            ByteString b = datum.getB();
            int contentSize = b.size();
            long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
            Crc32cValue.Crc32cLengthKnown cumulative = this.writeCtx.getCumulativeCrc32c().accumulateAndGet(crc32c, this.chunkSegmenter.getHasher()::nullSafeConcat);
            ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
            if (crc32c != null) {
                checksummedData.setCrc32C(crc32c.getValue());
            }
            WriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder().clearWriteObjectSpec().clearObjectChecksums().setWriteOffset(offset).setChecksummedData(checksummedData.build());
            if (!first) {
                builder.clearUploadId();
            }
            if (!datum.isOnlyFullBlocks()) {
                builder.setFinishWrite(true);
                if (cumulative != null) {
                    builder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(cumulative.getValue()).build());
                }
                this.finished = true;
            }
            WriteObjectRequest build = builder.build();
            first = false;
            messages.add(build);
        }
        if (finalize && !this.finished) {
            messages.add(this.finishMessage(first));
            this.finished = true;
        }
        try {
            this.flush(messages, content, finalize);
        }
        catch (RuntimeException e) {
            this.resultFuture.setException(e);
            throw e;
        }
        long end = this.writeCtx.getConfirmedBytes().get();
        long bytesConsumed = end - begin;
        return bytesConsumed;
    }

    private @NonNull WriteObjectRequest finishMessage(boolean first) {
        long offset = this.writeCtx.getTotalSentBytes().get();
        Crc32cValue.Crc32cLengthKnown crc32cValue = this.writeCtx.getCumulativeCrc32c().get();
        WriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder().setFinishWrite(true).setWriteOffset(offset);
        if (!first) {
            b.clearUploadId();
        }
        if (crc32cValue != null) {
            b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(crc32cValue.getValue()).build());
        }
        WriteObjectRequest message = b.build();
        return message;
    }

    private void flush(@NonNull List<WriteObjectRequest> segments, @Nullable RewindableContent content, boolean finalizing) {
        GrpcCallContext internalContext = GrpcUtils.contextWithBucketName(this.bucketName, this.baseContextSupplier.get());
        ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> callable = this.write.withDefaultCallContext(internalContext);
        this.retrier.run(() -> {
            Observer observer = new Observer(content, finalizing, segments, internalContext);
            ApiStreamObserver write = callable.clientStreamingCall(observer);
            for (WriteObjectRequest message : segments) {
                write.onNext(message);
            }
            write.onCompleted();
            try {
                observer.await();
            }
            catch (Throwable t2) {
                t2.addSuppressed(new AsyncStorageTaskException());
                throw t2;
            }
            return null;
        }, Conversions.Decoder.identity());
    }

    @VisibleForTesting
    WriteCtx<?> getWriteCtx() {
        return this.writeCtx;
    }

    class Observer
    implements ApiStreamObserver<WriteObjectResponse> {
        private final RewindableContent content;
        private final boolean finalizing;
        private final List<WriteObjectRequest> segments;
        private final GrpcCallContext context;
        private final SettableApiFuture<Void> invocationHandle;
        private volatile WriteObjectResponse last;

        Observer(RewindableContent content, @NonNull boolean finalizing, List<WriteObjectRequest> segments, GrpcCallContext context) {
            this.content = content;
            this.finalizing = finalizing;
            this.segments = segments;
            this.context = context;
            this.invocationHandle = SettableApiFuture.create();
        }

        @Override
        public void onNext(WriteObjectResponse value) {
            this.last = value;
        }

        @Override
        public void onError(Throwable t2) {
            if (t2 instanceof OutOfRangeException) {
                OutOfRangeException oore = (OutOfRangeException)t2;
                GapicUnbufferedChunkedResumableWritableByteChannel.this.open = false;
                ErrorDetails ed = oore.getErrorDetails();
                if (ed == null || ed.getErrorInfo() == null || !ed.getErrorInfo().getReason().equals("GRPC_MISMATCHED_UPLOAD_SIZE")) {
                    StorageException storageException = ResumableSessionFailureScenario.SCENARIO_5.toStorageException(this.segments, null, this.context, oore);
                    this.invocationHandle.setException(storageException);
                    return;
                }
            }
            if (t2 instanceof ApiException) {
                StorageException tmp = StorageException.asStorageException((ApiException)t2);
                StorageException storageException = ResumableSessionFailureScenario.toStorageException(tmp.getCode(), tmp.getMessage(), tmp.getReason(), this.segments, null, this.context, t2);
                this.invocationHandle.setException(storageException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            block15: {
                try {
                    if (this.last == null) {
                        throw new StorageException(0, "onComplete without preceding onNext, unable to determine success.");
                    }
                    if (!this.finalizing && this.last.hasPersistedSize()) {
                        long persistedSize;
                        long totalSentBytes = GapicUnbufferedChunkedResumableWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                        if (totalSentBytes == (persistedSize = this.last.getPersistedSize())) {
                            GapicUnbufferedChunkedResumableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                            break block15;
                        }
                        if (persistedSize < totalSentBytes) {
                            long delta = totalSentBytes - persistedSize;
                            this.content.rewindTo(delta);
                            GapicUnbufferedChunkedResumableWritableByteChannel.this.writeCtx.getTotalSentBytes().set(persistedSize);
                            GapicUnbufferedChunkedResumableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                            break block15;
                        }
                        throw ResumableSessionFailureScenario.SCENARIO_7.toStorageException(this.segments, this.last, this.context, null);
                    }
                    if (this.finalizing && this.last.hasResource()) {
                        long finalSize;
                        long totalSentBytes = GapicUnbufferedChunkedResumableWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                        if (totalSentBytes == (finalSize = this.last.getResource().getSize())) {
                            GapicUnbufferedChunkedResumableWritableByteChannel.this.writeCtx.getConfirmedBytes().set(finalSize);
                            GapicUnbufferedChunkedResumableWritableByteChannel.this.resultFuture.set(this.last);
                            break block15;
                        }
                        if (finalSize < totalSentBytes) {
                            throw ResumableSessionFailureScenario.SCENARIO_4_1.toStorageException(this.segments, this.last, this.context, null);
                        }
                        throw ResumableSessionFailureScenario.SCENARIO_4_2.toStorageException(this.segments, this.last, this.context, null);
                    }
                    if (!this.finalizing && this.last.hasResource()) {
                        throw ResumableSessionFailureScenario.SCENARIO_1.toStorageException(this.segments, this.last, this.context, null);
                    }
                    if (this.finalizing && this.last.hasPersistedSize()) {
                        long totalSentBytes = GapicUnbufferedChunkedResumableWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                        long persistedSize = this.last.getPersistedSize();
                        if (persistedSize < totalSentBytes) {
                            throw ResumableSessionFailureScenario.SCENARIO_3.toStorageException(this.segments, this.last, this.context, null);
                        }
                        throw ResumableSessionFailureScenario.SCENARIO_2.toStorageException(this.segments, this.last, this.context, null);
                    }
                    throw ResumableSessionFailureScenario.SCENARIO_0.toStorageException(this.segments, this.last, this.context, null);
                }
                catch (Throwable se) {
                    GapicUnbufferedChunkedResumableWritableByteChannel.this.open = false;
                    this.invocationHandle.setException(se);
                }
                finally {
                    this.invocationHandle.set(null);
                }
            }
        }

        void await() {
            try {
                this.invocationHandle.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
    }
}

