/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobReadSession;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.ObjectReadSession;
import com.google.cloud.storage.ReadProjectionConfig;
import com.google.cloud.storage.StorageException;
import java.io.IOException;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.MoreExecutors;

final class BlobReadSessionAdapter
implements BlobReadSession {
    @VisibleForTesting
    final ObjectReadSession session;

    BlobReadSessionAdapter(ObjectReadSession session) {
        this.session = session;
    }

    @Override
    public BlobInfo getBlobInfo() {
        return (BlobInfo)Conversions.grpc().blobInfo().decode(this.session.getResource());
    }

    @Override
    public <Projection> Projection readAs(ReadProjectionConfig<Projection> config) {
        Projection projection = this.session.readAs(config);
        if (projection instanceof ApiFuture) {
            ApiFuture apiFuture = (ApiFuture)projection;
            return (Projection)StorageException.coalesceAsync(apiFuture);
        }
        return projection;
    }

    @Override
    public void close() throws IOException {
        this.session.close();
    }

    static ApiFuture<BlobReadSession> wrap(ApiFuture<ObjectReadSession> session) {
        return ApiFutures.transform(StorageException.coalesceAsync(session), BlobReadSessionAdapter::new, MoreExecutors.directExecutor());
    }
}

