/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.LazyReadChannel;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageReadChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BaseStorageReadChannel<T>
implements StorageReadChannel {
    private final Conversions.Decoder<T, BlobInfo> objectDecoder;
    private final SettableApiFuture<T> result;
    private boolean open;
    private ByteRangeSpec byteRangeSpec;
    private int chunkSize = 0x200000;
    private BufferHandle bufferHandle;
    private LazyReadChannel<?, T> lazyReadChannel;
    protected final ReentrantLock lock;

    protected BaseStorageReadChannel(Conversions.Decoder<T, BlobInfo> objectDecoder) {
        this.objectDecoder = objectDecoder;
        this.result = SettableApiFuture.create();
        this.open = true;
        this.byteRangeSpec = ByteRangeSpec.nullRange();
        this.lock = new ReentrantLock();
    }

    @Override
    public final void setChunkSize(int chunkSize) {
        this.lock.lock();
        try {
            StorageException.wrapIOException(() -> this.maybeResetChannel(true));
            this.chunkSize = chunkSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final boolean isOpen() {
        this.lock.lock();
        try {
            boolean bl = this.open;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void close() {
        this.lock.lock();
        try {
            this.open = false;
            if (this.internalGetLazyChannel().isOpen()) {
                Object channel = this.internalGetLazyChannel().getChannel();
                StorageException.wrapIOException(() -> channel.close());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final StorageReadChannel setByteRangeSpec(ByteRangeSpec byteRangeSpec) {
        Objects.requireNonNull(byteRangeSpec, "byteRangeSpec must be non null");
        this.lock.lock();
        try {
            if (!this.byteRangeSpec.equals(byteRangeSpec)) {
                StorageException.wrapIOException(() -> this.maybeResetChannel(false));
                this.byteRangeSpec = byteRangeSpec;
            }
            BaseStorageReadChannel baseStorageReadChannel = this;
            return baseStorageReadChannel;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final ByteRangeSpec getByteRangeSpec() {
        return this.byteRangeSpec;
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        this.lock.lock();
        try {
            if (!this.open) {
                throw new ClosedChannelException();
            }
            long diff = this.byteRangeSpec.length();
            if (diff <= 0L && this.byteRangeSpec.beginOffset() >= 0L) {
                int n = -1;
                return n;
            }
            Object tmp = this.internalGetLazyChannel().getChannel();
            if (!tmp.isOpen()) {
                int n = -1;
                return n;
            }
            int read = tmp.read(dst);
            if (read != -1) {
                this.byteRangeSpec = this.byteRangeSpec.withShiftBeginOffset(read);
            }
            int n = read;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final ApiFuture<BlobInfo> getObject() {
        return ApiFutures.transform(this.result, this.objectDecoder::decode, MoreExecutors.directExecutor());
    }

    protected final BufferHandle getBufferHandle() {
        if (this.bufferHandle == null) {
            this.bufferHandle = BufferHandle.allocate(this.chunkSize);
        }
        return this.bufferHandle;
    }

    protected final int getChunkSize() {
        return this.chunkSize;
    }

    protected final @Nullable T getResolvedObject() {
        if (this.result.isDone()) {
            return StorageException.wrapFutureGet(this.result);
        }
        return null;
    }

    protected abstract LazyReadChannel<?, T> newLazyReadChannel();

    private void maybeResetChannel(boolean freeBuffer) throws IOException {
        if (this.lazyReadChannel != null) {
            if (this.lazyReadChannel.isOpen()) {
                this.lazyReadChannel.getChannel().close();
            }
            if (this.bufferHandle != null && !freeBuffer) {
                ((ByteBuffer)this.bufferHandle.get()).clear();
            } else if (freeBuffer) {
                this.bufferHandle = null;
            }
            this.lazyReadChannel = null;
        }
    }

    private LazyReadChannel<?, T> internalGetLazyChannel() {
        if (this.lazyReadChannel == null) {
            LazyReadChannel<?, T> tmp = this.newLazyReadChannel();
            ApiFuture<T> future = tmp.getSession().getResult();
            ApiFutures.addCallback(future, new ApiFutureCallback<T>(){

                @Override
                public void onFailure(Throwable t2) {
                    if (!BaseStorageReadChannel.this.result.isDone()) {
                        BaseStorageReadChannel.this.result.setException(t2);
                    }
                }

                @Override
                public void onSuccess(T t2) {
                    if (!BaseStorageReadChannel.this.result.isDone()) {
                        BaseStorageReadChannel.this.result.set(t2);
                    }
                }
            }, MoreExecutors.directExecutor());
            this.lazyReadChannel = tmp;
        }
        return this.lazyReadChannel;
    }
}

