/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.BaseServiceException;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.IOAutoCloseable;
import com.google.cloud.storage.ObjectReadSessionStreamRead;
import com.google.cloud.storage.RangeSpec;
import com.google.cloud.storage.ResponseContentLifecycleHandle;
import com.google.cloud.storage.RetryContext;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.storage.ZeroCopySupport;
import com.google.storage.v2.ReadRange;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.ByteString;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
@InternalExtensionOnly
abstract class BaseObjectReadSessionStreamRead<Projection>
implements ObjectReadSessionStreamRead<Projection> {
    protected final RangeSpec rangeSpec;
    protected final RetryContext retryContext;
    protected final AtomicLong readOffset;
    protected boolean closed;
    protected boolean tombstoned;
    protected IOAutoCloseable onCloseCallback;

    BaseObjectReadSessionStreamRead(RangeSpec rangeSpec, RetryContext retryContext, IOAutoCloseable onCloseCallback) {
        this(rangeSpec, new AtomicLong(rangeSpec.begin()), retryContext, onCloseCallback, false);
    }

    BaseObjectReadSessionStreamRead(RangeSpec rangeSpec, AtomicLong readOffset, RetryContext retryContext, IOAutoCloseable onCloseCallback, boolean closed) {
        this.rangeSpec = rangeSpec;
        this.retryContext = retryContext;
        this.readOffset = readOffset;
        this.closed = closed;
        this.tombstoned = false;
        this.onCloseCallback = onCloseCallback;
    }

    abstract long readId();

    @Override
    public long readOffset() {
        return this.readOffset.get();
    }

    @Override
    public final void preFail() {
        this.tombstoned = true;
    }

    @Override
    public final ReadRange makeReadRange() {
        long currentOffset = this.readOffset.get();
        ReadRange.Builder b = ReadRange.newBuilder().setReadId(this.readId()).setReadOffset(currentOffset);
        this.rangeSpec.maxLength().ifPresent(length -> {
            long readSoFar = currentOffset - this.rangeSpec.begin();
            b.setReadLength(length - readSoFar);
        });
        return b.build();
    }

    @Override
    public <T extends Throwable> void recordError(T t2, RetryContext.OnSuccess onSuccess, RetryContext.OnFailure<T> onFailure) {
        this.retryContext.recordError(t2, onSuccess, onFailure);
    }

    @Override
    public boolean readyToSend() {
        return !this.tombstoned && !this.retryContext.inBackoff();
    }

    @Override
    public boolean canShareStreamWith(ObjectReadSessionStreamRead<?> other) {
        return this.getClass() == other.getClass();
    }

    @Override
    public final void close() throws IOException {
        try {
            this.internalClose();
        }
        finally {
            this.onCloseCallback.close();
        }
    }

    @Override
    public void setOnCloseCallback(IOAutoCloseable onCloseCallback) {
        this.onCloseCallback = this.onCloseCallback.andThen(onCloseCallback);
    }

    static final class ZeroCopyByteStringAccumulatingRead
    extends AccumulatingRead<ZeroCopySupport.DisposableByteString>
    implements ZeroCopySupport.DisposableByteString {
        private volatile ByteString byteString;

        ZeroCopyByteStringAccumulatingRead(long readId, RangeSpec rangeSpec, Hasher hasher, RetryContext retryContext, IOAutoCloseable onCloseCallback) {
            super(readId, rangeSpec, hasher, retryContext, onCloseCallback);
        }

        public ZeroCopyByteStringAccumulatingRead(long readId, RangeSpec rangeSpec, Hasher hasher, List<ResponseContentLifecycleHandle.ChildRef> childRefs, AtomicLong readOffset, RetryContext retryContext, boolean closed, SettableApiFuture<ZeroCopySupport.DisposableByteString> complete, ByteString byteString, IOAutoCloseable onCloseCallback) {
            super(readId, rangeSpec, hasher, childRefs, readOffset, retryContext, closed, complete, onCloseCallback);
            this.byteString = byteString;
        }

        @Override
        public ApiFuture<ZeroCopySupport.DisposableByteString> project() {
            return this;
        }

        @Override
        public ByteString byteString() {
            return this.byteString;
        }

        @Override
        public void eof() throws IOException {
            this.retryContext.reset();
            ByteString base = ByteString.empty();
            for (ResponseContentLifecycleHandle.ChildRef ref : this.childRefs) {
                base = base.concat(ref.byteString());
            }
            this.byteString = base;
            this.complete.set(this);
        }

        public ZeroCopyByteStringAccumulatingRead withNewReadId(long newReadId) {
            this.tombstoned = true;
            return new ZeroCopyByteStringAccumulatingRead(newReadId, this.rangeSpec, this.hasher, (List<ResponseContentLifecycleHandle.ChildRef>)this.childRefs, this.readOffset, this.retryContext, this.closed, (SettableApiFuture<ZeroCopySupport.DisposableByteString>)this.complete, this.byteString, this.onCloseCallback);
        }
    }

    static final class ByteArrayAccumulatingRead
    extends AccumulatingRead<byte[]> {
        ByteArrayAccumulatingRead(long readId, RangeSpec rangeSpec, Hasher hasher, RetryContext retryContext, IOAutoCloseable onCloseCallback) {
            super(readId, rangeSpec, hasher, retryContext, onCloseCallback);
        }

        private ByteArrayAccumulatingRead(long readId, RangeSpec rangeSpec, Hasher hasher, List<ResponseContentLifecycleHandle.ChildRef> childRefs, RetryContext retryContext, AtomicLong readOffset, boolean closed, SettableApiFuture<byte[]> complete, IOAutoCloseable onCloseCallback) {
            super(readId, rangeSpec, hasher, childRefs, readOffset, retryContext, closed, complete, onCloseCallback);
        }

        @Override
        public ApiFuture<byte[]> project() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eof() throws IOException {
            this.retryContext.reset();
            try {
                ByteString base = ByteString.empty();
                for (ResponseContentLifecycleHandle.ChildRef ref : this.childRefs) {
                    base = base.concat(ref.byteString());
                }
                this.complete.set(base.toByteArray());
            }
            finally {
                this.close();
            }
        }

        public ByteArrayAccumulatingRead withNewReadId(long newReadId) {
            this.tombstoned = true;
            return new ByteArrayAccumulatingRead(newReadId, this.rangeSpec, this.hasher, this.childRefs, this.retryContext, this.readOffset, this.closed, this.complete, this.onCloseCallback);
        }
    }

    static class StreamingRead
    extends BaseObjectReadSessionStreamRead<ScatteringByteChannel>
    implements UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel {
        private final Hasher hasher;
        private final SettableApiFuture<Void> failFuture;
        private final BlockingQueue<Closeable> queue;
        private AtomicLong readId;
        private boolean complete;
        private @Nullable ChildRefHelper leftovers;

        StreamingRead(long readId, RangeSpec rangeSpec, Hasher hasher, RetryContext retryContext, IOAutoCloseable onCloseCallback) {
            super(rangeSpec, retryContext, onCloseCallback);
            this.readId = new AtomicLong(readId);
            this.hasher = hasher;
            this.closed = false;
            this.failFuture = SettableApiFuture.create();
            this.queue = new ArrayBlockingQueue<Closeable>(2);
            this.complete = false;
            this.leftovers = null;
        }

        @Override
        long readId() {
            return this.readId.get();
        }

        @Override
        public Hasher hasher() {
            return this.hasher;
        }

        @Override
        public boolean acceptingBytes() {
            return !this.closed && !this.tombstoned;
        }

        @Override
        public void accept(ResponseContentLifecycleHandle.ChildRef childRef) throws IOException {
            this.retryContext.reset();
            int size = childRef.byteString().size();
            this.offer(childRef);
            this.readOffset.addAndGet(size);
        }

        @Override
        public void eof() throws IOException {
            this.retryContext.reset();
            this.offer(EofMarker.INSTANCE);
        }

        @Override
        public ApiFuture<?> fail(Throwable t2) {
            try {
                this.offer(new SmuggledFailure(t2));
                this.failFuture.set(null);
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
                this.failFuture.setException(e);
            }
            return this.failFuture;
        }

        public StreamingRead withNewReadId(long newReadId) {
            this.readId.set(newReadId);
            return this;
        }

        @Override
        public boolean canShareStreamWith(ObjectReadSessionStreamRead<?> other) {
            return false;
        }

        @Override
        public void internalClose() throws IOException {
            if (!this.closed) {
                this.retryContext.reset();
                this.closed = true;
                if (this.leftovers != null) {
                    this.leftovers.ref.close();
                }
                GrpcUtils.closeAll(this.queue);
            }
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel project() {
            return this;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return Math.toIntExact(this.read(new ByteBuffer[]{dst}, 0, 1));
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            Object poll;
            if (this.closed) {
                throw new ClosedChannelException();
            }
            if (this.complete) {
                this.close();
                return -1L;
            }
            long read = 0L;
            long dstsRemaining = Buffers.totalRemaining(dsts, offset, length);
            if (this.leftovers != null) {
                read += this.leftovers.copy(dsts, offset, length);
                if (!this.leftovers.hasRemaining()) {
                    this.leftovers.ref.close();
                    this.leftovers = null;
                }
            }
            while (read < dstsRemaining && (poll = this.queue.poll()) != null) {
                if (poll instanceof ResponseContentLifecycleHandle.ChildRef) {
                    ChildRefHelper ref = new ChildRefHelper((ResponseContentLifecycleHandle.ChildRef)poll);
                    read += ref.copy(dsts, offset, length);
                    if (ref.hasRemaining()) {
                        this.leftovers = ref;
                        break;
                    }
                    ref.ref.close();
                    continue;
                }
                if (poll == EofMarker.INSTANCE) {
                    this.complete = true;
                    if (read != 0L) break;
                    this.close();
                    return -1L;
                }
                if (poll instanceof SmuggledFailure) {
                    SmuggledFailure throwable = (SmuggledFailure)poll;
                    this.close();
                    BaseServiceException coalesce = StorageException.coalesce(throwable.getSmuggled());
                    throw new IOException(coalesce);
                }
                Preconditions.checkState(false, "unhandled queue element type %s", (Object)poll.getClass().getName());
            }
            return read;
        }

        private void offer(Closeable offer) throws InterruptedIOException {
            try {
                this.queue.put(offer);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }

        static final class ChildRefHelper {
            private final ResponseContentLifecycleHandle.ChildRef ref;
            private final List<ByteBuffer> buffers;

            private ChildRefHelper(ResponseContentLifecycleHandle.ChildRef ref) {
                this.ref = ref;
                this.buffers = ref.byteString().asReadOnlyByteBufferList();
            }

            long copy(ByteBuffer[] dsts, int offset, int length) {
                long copied = 0L;
                for (ByteBuffer b : this.buffers) {
                    long copiedBytes = Buffers.copy(b, dsts, offset, length);
                    copied += copiedBytes;
                    if (!b.hasRemaining()) continue;
                    break;
                }
                return copied;
            }

            boolean hasRemaining() {
                for (ByteBuffer b : this.buffers) {
                    if (!b.hasRemaining()) continue;
                    return true;
                }
                return false;
            }
        }

        private static final class EofMarker
        implements Closeable {
            private static final EofMarker INSTANCE = new EofMarker();

            private EofMarker() {
            }

            @Override
            public void close() {
            }
        }

        static final class SmuggledFailure
        implements Closeable {
            private final Throwable smuggled;

            private SmuggledFailure(Throwable smuggled) {
                this.smuggled = smuggled;
            }

            Throwable getSmuggled() {
                return this.smuggled;
            }

            @Override
            public void close() throws IOException {
            }
        }
    }

    static abstract class AccumulatingRead<Result>
    extends BaseObjectReadSessionStreamRead<ApiFuture<Result>>
    implements ApiFuture<Result> {
        protected final List<ResponseContentLifecycleHandle.ChildRef> childRefs;
        protected final SettableApiFuture<Result> complete;
        protected final long readId;
        protected final Hasher hasher;

        private AccumulatingRead(long readId, RangeSpec rangeSpec, Hasher hasher, RetryContext retryContext, IOAutoCloseable onCloseCallback) {
            super(rangeSpec, retryContext, onCloseCallback);
            this.readId = readId;
            this.hasher = hasher;
            this.complete = SettableApiFuture.create();
            this.childRefs = Collections.synchronizedList(new ArrayList());
        }

        private AccumulatingRead(long readId, RangeSpec rangeSpec, Hasher hasher, List<ResponseContentLifecycleHandle.ChildRef> childRefs, AtomicLong readOffset, RetryContext retryContext, boolean closed, SettableApiFuture<Result> complete, IOAutoCloseable onCloseCallback) {
            super(rangeSpec, readOffset, retryContext, onCloseCallback, closed);
            this.readId = readId;
            this.childRefs = childRefs;
            this.complete = complete;
            this.hasher = hasher;
        }

        @Override
        long readId() {
            return this.readId;
        }

        @Override
        public boolean acceptingBytes() {
            return !this.complete.isDone() && !this.tombstoned;
        }

        @Override
        public void accept(ResponseContentLifecycleHandle.ChildRef childRef) throws IOException {
            this.retryContext.reset();
            int size = childRef.byteString().size();
            this.childRefs.add(childRef);
            this.readOffset.addAndGet(size);
        }

        @Override
        public ApiFuture<?> fail(Throwable t2) {
            try {
                this.tombstoned = true;
                this.close();
            }
            catch (IOException e) {
                t2.addSuppressed(e);
            }
            finally {
                this.complete.setException(t2);
            }
            return this.complete;
        }

        @Override
        public Hasher hasher() {
            return this.hasher;
        }

        @Override
        public void internalClose() throws IOException {
            if (!this.closed) {
                this.retryContext.reset();
                this.closed = true;
                GrpcUtils.closeAll(this.childRefs);
            }
        }

        @Override
        public void addListener(Runnable listener, Executor executor) {
            this.complete.addListener(listener, executor);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.complete.isCancelled()) {
                this.fail(new CancellationException());
            }
            return this.complete.cancel(mayInterruptIfRunning);
        }

        @Override
        public Result get() throws InterruptedException, ExecutionException {
            return (Result)this.complete.get();
        }

        @Override
        public Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (Result)this.complete.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.complete.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.complete.isDone();
        }

        @Override
        public boolean canShareStreamWith(ObjectReadSessionStreamRead<?> other) {
            return other instanceof AccumulatingRead;
        }
    }
}

