/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.v1.CreateEkmConnectionRequest;
import com.google.cloud.kms.v1.EkmConfig;
import com.google.cloud.kms.v1.EkmConnection;
import com.google.cloud.kms.v1.EkmServiceClient;
import com.google.cloud.kms.v1.GetEkmConfigRequest;
import com.google.cloud.kms.v1.GetEkmConnectionRequest;
import com.google.cloud.kms.v1.ListEkmConnectionsRequest;
import com.google.cloud.kms.v1.ListEkmConnectionsResponse;
import com.google.cloud.kms.v1.UpdateEkmConfigRequest;
import com.google.cloud.kms.v1.UpdateEkmConnectionRequest;
import com.google.cloud.kms.v1.VerifyConnectivityRequest;
import com.google.cloud.kms.v1.VerifyConnectivityResponse;
import com.google.cloud.kms.v1.stub.EkmServiceStub;
import com.google.cloud.kms.v1.stub.EkmServiceStubSettings;
import com.google.cloud.kms.v1.stub.GrpcEkmServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcEkmServiceStub
extends EkmServiceStub {
    private static final MethodDescriptor<ListEkmConnectionsRequest, ListEkmConnectionsResponse> listEkmConnectionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.EkmService/ListEkmConnections").setRequestMarshaller(ProtoUtils.marshaller(ListEkmConnectionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListEkmConnectionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEkmConnectionRequest, EkmConnection> getEkmConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.EkmService/GetEkmConnection").setRequestMarshaller(ProtoUtils.marshaller(GetEkmConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(EkmConnection.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateEkmConnectionRequest, EkmConnection> createEkmConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.EkmService/CreateEkmConnection").setRequestMarshaller(ProtoUtils.marshaller(CreateEkmConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(EkmConnection.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateEkmConnectionRequest, EkmConnection> updateEkmConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.EkmService/UpdateEkmConnection").setRequestMarshaller(ProtoUtils.marshaller(UpdateEkmConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(EkmConnection.getDefaultInstance())).build();
    private static final MethodDescriptor<GetEkmConfigRequest, EkmConfig> getEkmConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.EkmService/GetEkmConfig").setRequestMarshaller(ProtoUtils.marshaller(GetEkmConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(EkmConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateEkmConfigRequest, EkmConfig> updateEkmConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.EkmService/UpdateEkmConfig").setRequestMarshaller(ProtoUtils.marshaller(UpdateEkmConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(EkmConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<VerifyConnectivityRequest, VerifyConnectivityResponse> verifyConnectivityMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.kms.v1.EkmService/VerifyConnectivity").setRequestMarshaller(ProtoUtils.marshaller(VerifyConnectivityRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(VerifyConnectivityResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller(ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller(GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller(SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller(GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller(TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListEkmConnectionsRequest, ListEkmConnectionsResponse> listEkmConnectionsCallable;
    private final UnaryCallable<ListEkmConnectionsRequest, EkmServiceClient.ListEkmConnectionsPagedResponse> listEkmConnectionsPagedCallable;
    private final UnaryCallable<GetEkmConnectionRequest, EkmConnection> getEkmConnectionCallable;
    private final UnaryCallable<CreateEkmConnectionRequest, EkmConnection> createEkmConnectionCallable;
    private final UnaryCallable<UpdateEkmConnectionRequest, EkmConnection> updateEkmConnectionCallable;
    private final UnaryCallable<GetEkmConfigRequest, EkmConfig> getEkmConfigCallable;
    private final UnaryCallable<UpdateEkmConfigRequest, EkmConfig> updateEkmConfigCallable;
    private final UnaryCallable<VerifyConnectivityRequest, VerifyConnectivityResponse> verifyConnectivityCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, EkmServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEkmServiceStub create(EkmServiceStubSettings settings) throws IOException {
        return new GrpcEkmServiceStub(settings, ClientContext.create(settings));
    }

    public static final GrpcEkmServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcEkmServiceStub(EkmServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEkmServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEkmServiceStub(EkmServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEkmServiceStub(EkmServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEkmServiceCallableFactory());
    }

    protected GrpcEkmServiceStub(EkmServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<ListEkmConnectionsRequest, ListEkmConnectionsResponse> listEkmConnectionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEkmConnectionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetEkmConnectionRequest, EkmConnection> getEkmConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEkmConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<CreateEkmConnectionRequest, EkmConnection> createEkmConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEkmConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<UpdateEkmConnectionRequest, EkmConnection> updateEkmConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateEkmConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("ekm_connection.name", String.valueOf(request.getEkmConnection().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetEkmConfigRequest, EkmConfig> getEkmConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEkmConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<UpdateEkmConfigRequest, EkmConfig> updateEkmConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateEkmConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("ekm_config.name", String.valueOf(request.getEkmConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<VerifyConnectivityRequest, VerifyConnectivityResponse> verifyConnectivityTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(verifyConnectivityMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListLocationsRequest, ListLocationsResponse> listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetLocationRequest, Location> getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<SetIamPolicyRequest, Policy> setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetIamPolicyRequest, Policy> getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listEkmConnectionsCallable = callableFactory.createUnaryCallable(listEkmConnectionsTransportSettings, settings.listEkmConnectionsSettings(), clientContext);
        this.listEkmConnectionsPagedCallable = callableFactory.createPagedCallable(listEkmConnectionsTransportSettings, settings.listEkmConnectionsSettings(), clientContext);
        this.getEkmConnectionCallable = callableFactory.createUnaryCallable(getEkmConnectionTransportSettings, settings.getEkmConnectionSettings(), clientContext);
        this.createEkmConnectionCallable = callableFactory.createUnaryCallable(createEkmConnectionTransportSettings, settings.createEkmConnectionSettings(), clientContext);
        this.updateEkmConnectionCallable = callableFactory.createUnaryCallable(updateEkmConnectionTransportSettings, settings.updateEkmConnectionSettings(), clientContext);
        this.getEkmConfigCallable = callableFactory.createUnaryCallable(getEkmConfigTransportSettings, settings.getEkmConfigSettings(), clientContext);
        this.updateEkmConfigCallable = callableFactory.createUnaryCallable(updateEkmConfigTransportSettings, settings.updateEkmConfigSettings(), clientContext);
        this.verifyConnectivityCallable = callableFactory.createUnaryCallable(verifyConnectivityTransportSettings, settings.verifyConnectivitySettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListEkmConnectionsRequest, ListEkmConnectionsResponse> listEkmConnectionsCallable() {
        return this.listEkmConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListEkmConnectionsRequest, EkmServiceClient.ListEkmConnectionsPagedResponse> listEkmConnectionsPagedCallable() {
        return this.listEkmConnectionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEkmConnectionRequest, EkmConnection> getEkmConnectionCallable() {
        return this.getEkmConnectionCallable;
    }

    @Override
    public UnaryCallable<CreateEkmConnectionRequest, EkmConnection> createEkmConnectionCallable() {
        return this.createEkmConnectionCallable;
    }

    @Override
    public UnaryCallable<UpdateEkmConnectionRequest, EkmConnection> updateEkmConnectionCallable() {
        return this.updateEkmConnectionCallable;
    }

    @Override
    public UnaryCallable<GetEkmConfigRequest, EkmConfig> getEkmConfigCallable() {
        return this.getEkmConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateEkmConfigRequest, EkmConfig> updateEkmConfigCallable() {
        return this.updateEkmConfigCallable;
    }

    @Override
    public UnaryCallable<VerifyConnectivityRequest, VerifyConnectivityResponse> verifyConnectivityCallable() {
        return this.verifyConnectivityCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, EkmServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

