/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.cloud.kms.v1.ChecksummedData;
import com.google.cloud.kms.v1.ChecksummedDataOrBuilder;
import com.google.cloud.kms.v1.CryptoKeyVersion;
import com.google.cloud.kms.v1.KmsResourcesProto;
import com.google.cloud.kms.v1.ProtectionLevel;
import com.google.cloud.kms.v1.PublicKeyOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.AbstractParser;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.ByteString;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.CodedInputStream;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Descriptors;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.ExtensionRegistryLite;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.GeneratedMessageV3;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Int64Value;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Int64ValueOrBuilder;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Internal;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Message;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Parser;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.ProtocolMessageEnum;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.SingleFieldBuilderV3;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.UninitializedMessageException;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.UnknownFieldSet;

public final class PublicKey
extends GeneratedMessageV3
implements PublicKeyOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int PEM_FIELD_NUMBER = 1;
    private volatile Object pem_ = "";
    public static final int ALGORITHM_FIELD_NUMBER = 2;
    private int algorithm_ = 0;
    public static final int PEM_CRC32C_FIELD_NUMBER = 3;
    private Int64Value pemCrc32C_;
    public static final int NAME_FIELD_NUMBER = 4;
    private volatile Object name_ = "";
    public static final int PROTECTION_LEVEL_FIELD_NUMBER = 5;
    private int protectionLevel_ = 0;
    public static final int PUBLIC_KEY_FORMAT_FIELD_NUMBER = 7;
    private int publicKeyFormat_ = 0;
    public static final int PUBLIC_KEY_FIELD_NUMBER = 8;
    private ChecksummedData publicKey_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final PublicKey DEFAULT_INSTANCE = new PublicKey();
    private static final Parser<PublicKey> PARSER = new AbstractParser<PublicKey>(){

        @Override
        public PublicKey parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = PublicKey.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private PublicKey(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private PublicKey() {
        this.pem_ = "";
        this.algorithm_ = 0;
        this.name_ = "";
        this.protectionLevel_ = 0;
        this.publicKeyFormat_ = 0;
    }

    @Override
    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new PublicKey();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_descriptor;
    }

    @Override
    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_fieldAccessorTable.ensureFieldAccessorsInitialized(PublicKey.class, Builder.class);
    }

    @Override
    public String getPem() {
        Object ref = this.pem_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s2 = bs.toStringUtf8();
        this.pem_ = s2;
        return s2;
    }

    @Override
    public ByteString getPemBytes() {
        Object ref = this.pem_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.pem_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getAlgorithmValue() {
        return this.algorithm_;
    }

    @Override
    public CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
        CryptoKeyVersion.CryptoKeyVersionAlgorithm result = CryptoKeyVersion.CryptoKeyVersionAlgorithm.forNumber(this.algorithm_);
        return result == null ? CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasPemCrc32C() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Int64Value getPemCrc32C() {
        return this.pemCrc32C_ == null ? Int64Value.getDefaultInstance() : this.pemCrc32C_;
    }

    @Override
    public Int64ValueOrBuilder getPemCrc32COrBuilder() {
        return this.pemCrc32C_ == null ? Int64Value.getDefaultInstance() : this.pemCrc32C_;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s2 = bs.toStringUtf8();
        this.name_ = s2;
        return s2;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getProtectionLevelValue() {
        return this.protectionLevel_;
    }

    @Override
    public ProtectionLevel getProtectionLevel() {
        ProtectionLevel result = ProtectionLevel.forNumber(this.protectionLevel_);
        return result == null ? ProtectionLevel.UNRECOGNIZED : result;
    }

    @Override
    public int getPublicKeyFormatValue() {
        return this.publicKeyFormat_;
    }

    @Override
    public PublicKeyFormat getPublicKeyFormat() {
        PublicKeyFormat result = PublicKeyFormat.forNumber(this.publicKeyFormat_);
        return result == null ? PublicKeyFormat.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasPublicKey() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public ChecksummedData getPublicKey() {
        return this.publicKey_ == null ? ChecksummedData.getDefaultInstance() : this.publicKey_;
    }

    @Override
    public ChecksummedDataOrBuilder getPublicKeyOrBuilder() {
        return this.publicKey_ == null ? ChecksummedData.getDefaultInstance() : this.publicKey_;
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty(this.pem_)) {
            GeneratedMessageV3.writeString(output, 1, this.pem_);
        }
        if (this.algorithm_ != CryptoKeyVersion.CryptoKeyVersionAlgorithm.CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.algorithm_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(3, this.getPemCrc32C());
        }
        if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
            GeneratedMessageV3.writeString(output, 4, this.name_);
        }
        if (this.protectionLevel_ != ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.protectionLevel_);
        }
        if (this.publicKeyFormat_ != PublicKeyFormat.PUBLIC_KEY_FORMAT_UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.publicKeyFormat_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(8, this.getPublicKey());
        }
        this.getUnknownFields().writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty(this.pem_)) {
            size += GeneratedMessageV3.computeStringSize(1, this.pem_);
        }
        if (this.algorithm_ != CryptoKeyVersion.CryptoKeyVersionAlgorithm.CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(2, this.algorithm_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize(3, this.getPemCrc32C());
        }
        if (!GeneratedMessageV3.isStringEmpty(this.name_)) {
            size += GeneratedMessageV3.computeStringSize(4, this.name_);
        }
        if (this.protectionLevel_ != ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(5, this.protectionLevel_);
        }
        if (this.publicKeyFormat_ != PublicKeyFormat.PUBLIC_KEY_FORMAT_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize(7, this.publicKeyFormat_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize(8, this.getPublicKey());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PublicKey)) {
            return super.equals(obj);
        }
        PublicKey other = (PublicKey)obj;
        if (!this.getPem().equals(other.getPem())) {
            return false;
        }
        if (this.algorithm_ != other.algorithm_) {
            return false;
        }
        if (this.hasPemCrc32C() != other.hasPemCrc32C()) {
            return false;
        }
        if (this.hasPemCrc32C() && !this.getPemCrc32C().equals(other.getPemCrc32C())) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.protectionLevel_ != other.protectionLevel_) {
            return false;
        }
        if (this.publicKeyFormat_ != other.publicKeyFormat_) {
            return false;
        }
        if (this.hasPublicKey() != other.hasPublicKey()) {
            return false;
        }
        if (this.hasPublicKey() && !this.getPublicKey().equals(other.getPublicKey())) {
            return false;
        }
        return this.getUnknownFields().equals(other.getUnknownFields());
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + PublicKey.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getPem().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.algorithm_;
        if (this.hasPemCrc32C()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getPemCrc32C().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.protectionLevel_;
        hash = 37 * hash + 7;
        hash = 53 * hash + this.publicKeyFormat_;
        if (this.hasPublicKey()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getPublicKey().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static PublicKey parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static PublicKey parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static PublicKey parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static PublicKey parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static PublicKey parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static PublicKey parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static PublicKey parseFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static PublicKey parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static PublicKey parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static PublicKey parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static PublicKey parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static PublicKey parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return PublicKey.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(PublicKey prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static PublicKey getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<PublicKey> parser() {
        return PARSER;
    }

    public Parser<PublicKey> getParserForType() {
        return PARSER;
    }

    @Override
    public PublicKey getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements PublicKeyOrBuilder {
        private int bitField0_;
        private Object pem_ = "";
        private int algorithm_ = 0;
        private Int64Value pemCrc32C_;
        private SingleFieldBuilderV3<Int64Value, Int64Value.Builder, Int64ValueOrBuilder> pemCrc32CBuilder_;
        private Object name_ = "";
        private int protectionLevel_ = 0;
        private int publicKeyFormat_ = 0;
        private ChecksummedData publicKey_;
        private SingleFieldBuilderV3<ChecksummedData, ChecksummedData.Builder, ChecksummedDataOrBuilder> publicKeyBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_fieldAccessorTable.ensureFieldAccessorsInitialized(PublicKey.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getPemCrc32CFieldBuilder();
                this.getPublicKeyFieldBuilder();
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.pem_ = "";
            this.algorithm_ = 0;
            this.pemCrc32C_ = null;
            if (this.pemCrc32CBuilder_ != null) {
                this.pemCrc32CBuilder_.dispose();
                this.pemCrc32CBuilder_ = null;
            }
            this.name_ = "";
            this.protectionLevel_ = 0;
            this.publicKeyFormat_ = 0;
            this.publicKey_ = null;
            if (this.publicKeyBuilder_ != null) {
                this.publicKeyBuilder_.dispose();
                this.publicKeyBuilder_ = null;
            }
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return KmsResourcesProto.internal_static_google_cloud_kms_v1_PublicKey_descriptor;
        }

        @Override
        public PublicKey getDefaultInstanceForType() {
            return PublicKey.getDefaultInstance();
        }

        @Override
        public PublicKey build() {
            PublicKey result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public PublicKey buildPartial() {
            PublicKey result = new PublicKey(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(PublicKey result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.pem_ = this.pem_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.algorithm_ = this.algorithm_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.pemCrc32C_ = this.pemCrc32CBuilder_ == null ? this.pemCrc32C_ : this.pemCrc32CBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.protectionLevel_ = this.protectionLevel_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.publicKeyFormat_ = this.publicKeyFormat_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.publicKey_ = this.publicKeyBuilder_ == null ? this.publicKey_ : this.publicKeyBuilder_.build();
                to_bitField0_ |= 2;
            }
            PublicKey publicKey = result;
            publicKey.bitField0_ = publicKey.bitField0_ | to_bitField0_;
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }

        @Override
        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        @Override
        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        @Override
        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        @Override
        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        @Override
        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof PublicKey) {
                return this.mergeFrom((PublicKey)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(PublicKey other) {
            if (other == PublicKey.getDefaultInstance()) {
                return this;
            }
            if (!other.getPem().isEmpty()) {
                this.pem_ = other.pem_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.algorithm_ != 0) {
                this.setAlgorithmValue(other.getAlgorithmValue());
            }
            if (other.hasPemCrc32C()) {
                this.mergePemCrc32C(other.getPemCrc32C());
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (other.protectionLevel_ != 0) {
                this.setProtectionLevelValue(other.getProtectionLevelValue());
            }
            if (other.publicKeyFormat_ != 0) {
                this.setPublicKeyFormatValue(other.getPublicKeyFormatValue());
            }
            if (other.hasPublicKey()) {
                this.mergePublicKey(other.getPublicKey());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block15: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block15;
                        }
                        case 10: {
                            this.pem_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block15;
                        }
                        case 16: {
                            this.algorithm_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block15;
                        }
                        case 26: {
                            input.readMessage(this.getPemCrc32CFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block15;
                        }
                        case 34: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block15;
                        }
                        case 40: {
                            this.protectionLevel_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block15;
                        }
                        case 56: {
                            this.publicKeyFormat_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block15;
                        }
                        case 66: {
                            input.readMessage(this.getPublicKeyFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block15;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getPem() {
            Object ref = this.pem_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.pem_ = s2;
                return s2;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPemBytes() {
            Object ref = this.pem_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.pem_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPem(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.pem_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearPem() {
            this.pem_ = PublicKey.getDefaultInstance().getPem();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setPemBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            PublicKey.checkByteStringIsUtf8(value);
            this.pem_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getAlgorithmValue() {
            return this.algorithm_;
        }

        public Builder setAlgorithmValue(int value) {
            this.algorithm_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
            CryptoKeyVersion.CryptoKeyVersionAlgorithm result = CryptoKeyVersion.CryptoKeyVersionAlgorithm.forNumber(this.algorithm_);
            return result == null ? CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED : result;
        }

        public Builder setAlgorithm(CryptoKeyVersion.CryptoKeyVersionAlgorithm value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.algorithm_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAlgorithm() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.algorithm_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPemCrc32C() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Int64Value getPemCrc32C() {
            if (this.pemCrc32CBuilder_ == null) {
                return this.pemCrc32C_ == null ? Int64Value.getDefaultInstance() : this.pemCrc32C_;
            }
            return this.pemCrc32CBuilder_.getMessage();
        }

        public Builder setPemCrc32C(Int64Value value) {
            if (this.pemCrc32CBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.pemCrc32C_ = value;
            } else {
                this.pemCrc32CBuilder_.setMessage(value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setPemCrc32C(Int64Value.Builder builderForValue) {
            if (this.pemCrc32CBuilder_ == null) {
                this.pemCrc32C_ = builderForValue.build();
            } else {
                this.pemCrc32CBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergePemCrc32C(Int64Value value) {
            if (this.pemCrc32CBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.pemCrc32C_ != null && this.pemCrc32C_ != Int64Value.getDefaultInstance()) {
                    this.getPemCrc32CBuilder().mergeFrom(value);
                } else {
                    this.pemCrc32C_ = value;
                }
            } else {
                this.pemCrc32CBuilder_.mergeFrom(value);
            }
            if (this.pemCrc32C_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPemCrc32C() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.pemCrc32C_ = null;
            if (this.pemCrc32CBuilder_ != null) {
                this.pemCrc32CBuilder_.dispose();
                this.pemCrc32CBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Int64Value.Builder getPemCrc32CBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return this.getPemCrc32CFieldBuilder().getBuilder();
        }

        @Override
        public Int64ValueOrBuilder getPemCrc32COrBuilder() {
            if (this.pemCrc32CBuilder_ != null) {
                return this.pemCrc32CBuilder_.getMessageOrBuilder();
            }
            return this.pemCrc32C_ == null ? Int64Value.getDefaultInstance() : this.pemCrc32C_;
        }

        private SingleFieldBuilderV3<Int64Value, Int64Value.Builder, Int64ValueOrBuilder> getPemCrc32CFieldBuilder() {
            if (this.pemCrc32CBuilder_ == null) {
                this.pemCrc32CBuilder_ = new SingleFieldBuilderV3(this.getPemCrc32C(), this.getParentForChildren(), this.isClean());
                this.pemCrc32C_ = null;
            }
            return this.pemCrc32CBuilder_;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s2 = bs.toStringUtf8();
                this.name_ = s2;
                return s2;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = PublicKey.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            PublicKey.checkByteStringIsUtf8(value);
            this.name_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public int getProtectionLevelValue() {
            return this.protectionLevel_;
        }

        public Builder setProtectionLevelValue(int value) {
            this.protectionLevel_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public ProtectionLevel getProtectionLevel() {
            ProtectionLevel result = ProtectionLevel.forNumber(this.protectionLevel_);
            return result == null ? ProtectionLevel.UNRECOGNIZED : result;
        }

        public Builder setProtectionLevel(ProtectionLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.protectionLevel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearProtectionLevel() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.protectionLevel_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getPublicKeyFormatValue() {
            return this.publicKeyFormat_;
        }

        public Builder setPublicKeyFormatValue(int value) {
            this.publicKeyFormat_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public PublicKeyFormat getPublicKeyFormat() {
            PublicKeyFormat result = PublicKeyFormat.forNumber(this.publicKeyFormat_);
            return result == null ? PublicKeyFormat.UNRECOGNIZED : result;
        }

        public Builder setPublicKeyFormat(PublicKeyFormat value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.publicKeyFormat_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPublicKeyFormat() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.publicKeyFormat_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPublicKey() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public ChecksummedData getPublicKey() {
            if (this.publicKeyBuilder_ == null) {
                return this.publicKey_ == null ? ChecksummedData.getDefaultInstance() : this.publicKey_;
            }
            return this.publicKeyBuilder_.getMessage();
        }

        public Builder setPublicKey(ChecksummedData value) {
            if (this.publicKeyBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.publicKey_ = value;
            } else {
                this.publicKeyBuilder_.setMessage(value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setPublicKey(ChecksummedData.Builder builderForValue) {
            if (this.publicKeyBuilder_ == null) {
                this.publicKey_ = builderForValue.build();
            } else {
                this.publicKeyBuilder_.setMessage(builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergePublicKey(ChecksummedData value) {
            if (this.publicKeyBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.publicKey_ != null && this.publicKey_ != ChecksummedData.getDefaultInstance()) {
                    this.getPublicKeyBuilder().mergeFrom(value);
                } else {
                    this.publicKey_ = value;
                }
            } else {
                this.publicKeyBuilder_.mergeFrom(value);
            }
            if (this.publicKey_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPublicKey() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.publicKey_ = null;
            if (this.publicKeyBuilder_ != null) {
                this.publicKeyBuilder_.dispose();
                this.publicKeyBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ChecksummedData.Builder getPublicKeyBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this.getPublicKeyFieldBuilder().getBuilder();
        }

        @Override
        public ChecksummedDataOrBuilder getPublicKeyOrBuilder() {
            if (this.publicKeyBuilder_ != null) {
                return this.publicKeyBuilder_.getMessageOrBuilder();
            }
            return this.publicKey_ == null ? ChecksummedData.getDefaultInstance() : this.publicKey_;
        }

        private SingleFieldBuilderV3<ChecksummedData, ChecksummedData.Builder, ChecksummedDataOrBuilder> getPublicKeyFieldBuilder() {
            if (this.publicKeyBuilder_ == null) {
                this.publicKeyBuilder_ = new SingleFieldBuilderV3(this.getPublicKey(), this.getParentForChildren(), this.isClean());
                this.publicKey_ = null;
            }
            return this.publicKeyBuilder_;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        @Override
        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum PublicKeyFormat implements ProtocolMessageEnum
    {
        PUBLIC_KEY_FORMAT_UNSPECIFIED(0),
        PEM(1),
        NIST_PQC(3),
        UNRECOGNIZED(-1);

        public static final int PUBLIC_KEY_FORMAT_UNSPECIFIED_VALUE = 0;
        public static final int PEM_VALUE = 1;
        public static final int NIST_PQC_VALUE = 3;
        private static final Internal.EnumLiteMap<PublicKeyFormat> internalValueMap;
        private static final PublicKeyFormat[] VALUES;
        private final int value;

        @Override
        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static PublicKeyFormat valueOf(int value) {
            return PublicKeyFormat.forNumber(value);
        }

        public static PublicKeyFormat forNumber(int value) {
            switch (value) {
                case 0: {
                    return PUBLIC_KEY_FORMAT_UNSPECIFIED;
                }
                case 1: {
                    return PEM;
                }
                case 3: {
                    return NIST_PQC;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<PublicKeyFormat> internalGetValueMap() {
            return internalValueMap;
        }

        @Override
        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return PublicKeyFormat.getDescriptor().getValues().get(this.ordinal());
        }

        @Override
        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return PublicKeyFormat.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return PublicKey.getDescriptor().getEnumTypes().get(0);
        }

        public static PublicKeyFormat valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != PublicKeyFormat.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private PublicKeyFormat(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<PublicKeyFormat>(){

                @Override
                public PublicKeyFormat findValueByNumber(int number) {
                    return PublicKeyFormat.forNumber(number);
                }
            };
            VALUES = PublicKeyFormat.values();
        }
    }
}

