/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.kms.v1.KeyName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;

public class KeyRingName
extends KeyName {
    private static final PathTemplate PROJECT_LOCATION_KEY_RING = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/keyRings/{key_ring}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String keyRing;

    @Deprecated
    protected KeyRingName() {
        this.project = null;
        this.location = null;
        this.keyRing = null;
    }

    private KeyRingName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.keyRing = Preconditions.checkNotNull(builder.getKeyRing());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyRing() {
        return this.keyRing;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeyRingName of(String project, String location, String keyRing) {
        return KeyRingName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).build();
    }

    public static String format(String project, String location, String keyRing) {
        return KeyRingName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).build().toString();
    }

    public static KeyRingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_LOCATION_KEY_RING.validatedMatch(formattedString, "KeyRingName.parse: formattedString not in valid format");
        return KeyRingName.of(matchMap.get("project"), matchMap.get("location"), matchMap.get("key_ring"));
    }

    public static List<KeyRingName> parseList(List<String> formattedStrings) {
        ArrayList<KeyRingName> list = new ArrayList<KeyRingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeyRingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeyRingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeyRingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_KEY_RING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeyRingName keyRingName = this;
            synchronized (keyRingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    if (this.keyRing != null) {
                        fieldMapBuilder.put("key_ring", this.keyRing);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_KEY_RING.instantiate("project", this.project, "location", this.location, "key_ring", this.keyRing);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            KeyRingName that = (KeyRingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.keyRing, that.keyRing);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.location);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.keyRing);
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyRing;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyRing() {
            return this.keyRing;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyRing(String keyRing) {
            this.keyRing = keyRing;
            return this;
        }

        private Builder(KeyRingName keyRingName) {
            this.project = keyRingName.project;
            this.location = keyRingName.location;
            this.keyRing = keyRingName.keyRing;
        }

        public KeyRingName build() {
            return new KeyRingName(this);
        }
    }
}

