/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;

public class EkmConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/ekmConfig");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;

    @Deprecated
    protected EkmConfigName() {
        this.project = null;
        this.location = null;
    }

    private EkmConfigName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.location = Preconditions.checkNotNull(builder.getLocation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EkmConfigName of(String project, String location) {
        return EkmConfigName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String project, String location) {
        return EkmConfigName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static EkmConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_LOCATION.validatedMatch(formattedString, "EkmConfigName.parse: formattedString not in valid format");
        return EkmConfigName.of(matchMap.get("project"), matchMap.get("location"));
    }

    public static List<EkmConfigName> parseList(List<String> formattedStrings) {
        ArrayList<EkmConfigName> list = new ArrayList<EkmConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EkmConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EkmConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EkmConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EkmConfigName ekmConfigName = this;
            synchronized (ekmConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION.instantiate("project", this.project, "location", this.location);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EkmConfigName that = (EkmConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.location);
    }

    public static class Builder {
        private String project;
        private String location;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(EkmConfigName ekmConfigName) {
            this.project = ekmConfigName.project;
            this.location = ekmConfigName.location;
        }

        public EkmConfigName build() {
            return new EkmConfigName(this);
        }
    }
}

