/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub.readrows;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;

final class ReadRowsAttemptCallable
implements Callable<Void> {
    private final Object lock = new Object();
    private final ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> innerCallable;
    private final StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse> resumptionStrategy;
    private final Storage.ReadRowsRequest initialRequest;
    private ApiCallContext context;
    private final ResponseObserver<Storage.ReadRowsResponse> outerObserver;
    private boolean autoFlowControl = true;
    private boolean isStarted;
    @GuardedBy(value="lock")
    private Throwable cancellationCause;
    @GuardedBy(value="lock")
    private int pendingRequests;
    private RetryingFuture<Void> outerRetryingFuture;
    private int numAttempts;
    @GuardedBy(value="lock")
    private StreamController innerController;
    private boolean seenSuccessSinceLastError;
    private SettableApiFuture<Void> innerAttemptFuture;

    ReadRowsAttemptCallable(ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> innerCallable, StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse> resumptionStrategy, Storage.ReadRowsRequest initialRequest, ApiCallContext context, ResponseObserver<Storage.ReadRowsResponse> outerObserver) {
        this.innerCallable = innerCallable;
        this.resumptionStrategy = resumptionStrategy;
        this.initialRequest = initialRequest;
        this.context = context;
        this.outerObserver = outerObserver;
    }

    void setExternalFuture(RetryingFuture<Void> retryingFuture) {
        Preconditions.checkState(!this.isStarted, "Can't change the RetryingFuture once the call has start");
        Preconditions.checkNotNull(retryingFuture, "RetryingFuture can't be null");
        this.outerRetryingFuture = retryingFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Preconditions.checkState(!this.isStarted, "Already started");
        this.outerObserver.onStart(new StreamController(){

            @Override
            public void disableAutoInboundFlowControl() {
                Preconditions.checkState(!ReadRowsAttemptCallable.this.isStarted, "Can't disable auto flow control once the stream is started");
                ReadRowsAttemptCallable.this.autoFlowControl = false;
            }

            @Override
            public void request(int count) {
                ReadRowsAttemptCallable.this.onRequest(count);
            }

            @Override
            public void cancel() {
                ReadRowsAttemptCallable.this.onCancel();
            }
        });
        if (this.autoFlowControl) {
            Object object = this.lock;
            synchronized (object) {
                this.pendingRequests = Integer.MAX_VALUE;
            }
        }
        this.isStarted = true;
        Duration totalTimeout = this.outerRetryingFuture.getAttemptSettings().getGlobalSettings().getTotalTimeoutDuration();
        if (totalTimeout != null && this.context != null) {
            this.context = this.context.withTimeoutDuration(totalTimeout);
        }
        this.call();
    }

    @Override
    public Void call() {
        Preconditions.checkState(this.isStarted, "Must be started first");
        Storage.ReadRowsRequest request = ++this.numAttempts == 1 ? this.initialRequest : this.resumptionStrategy.getResumeRequest(this.initialRequest);
        Preconditions.checkState(request != null, "ResumptionStrategy returned a null request.");
        this.innerAttemptFuture = SettableApiFuture.create();
        this.seenSuccessSinceLastError = false;
        ApiCallContext attemptContext = this.context;
        if (!this.outerRetryingFuture.getAttemptSettings().getRpcTimeout().isZero()) {
            attemptContext = attemptContext.withStreamWaitTimeout(this.outerRetryingFuture.getAttemptSettings().getRpcTimeout());
        }
        attemptContext.getTracer().attemptStarted(this.outerRetryingFuture.getAttemptSettings().getOverallAttemptCount());
        this.innerCallable.call(request, (ResponseObserver<Storage.ReadRowsResponse>)new StateCheckingResponseObserver<Storage.ReadRowsResponse>(){

            @Override
            public void onStartImpl(StreamController controller) {
                ReadRowsAttemptCallable.this.onAttemptStart(controller);
            }

            @Override
            public void onResponseImpl(Storage.ReadRowsResponse response) {
                ReadRowsAttemptCallable.this.onAttemptResponse(response);
            }

            @Override
            public void onErrorImpl(Throwable t2) {
                ReadRowsAttemptCallable.this.onAttemptError(t2);
            }

            @Override
            public void onCompleteImpl() {
                ReadRowsAttemptCallable.this.onAttemptComplete();
            }
        }, attemptContext);
        this.outerRetryingFuture.setAttemptFuture(this.innerAttemptFuture);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAttemptStart(StreamController controller) {
        Throwable localCancellationCause;
        if (!this.autoFlowControl) {
            controller.disableAutoInboundFlowControl();
        }
        int numToRequest = 0;
        Object object = this.lock;
        synchronized (object) {
            this.innerController = controller;
            localCancellationCause = this.cancellationCause;
            if (!this.autoFlowControl) {
                numToRequest = this.pendingRequests;
            }
        }
        if (localCancellationCause != null) {
            controller.cancel();
        } else if (numToRequest > 0) {
            controller.request(numToRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCancel() {
        StreamController localInnerController;
        Object object = this.lock;
        synchronized (object) {
            if (this.cancellationCause != null) {
                return;
            }
            this.cancellationCause = new ServerStreamingAttemptException(new CancellationException("User cancelled stream"), this.resumptionStrategy.canResume(), this.seenSuccessSinceLastError);
            localInnerController = this.innerController;
        }
        if (localInnerController != null) {
            localInnerController.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRequest(int count) {
        StreamController localInnerController;
        Preconditions.checkState(!this.autoFlowControl, "Automatic flow control is enabled");
        Preconditions.checkArgument(count > 0, "Count must be > 0");
        Object object = this.lock;
        synchronized (object) {
            int maxInc = Integer.MAX_VALUE - this.pendingRequests;
            count = Math.min(maxInc, count);
            this.pendingRequests += count;
            localInnerController = this.innerController;
        }
        if (localInnerController != null) {
            localInnerController.request(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAttemptResponse(Storage.ReadRowsResponse message) {
        if (!this.autoFlowControl) {
            Object object = this.lock;
            synchronized (object) {
                --this.pendingRequests;
            }
        }
        this.seenSuccessSinceLastError = true;
        message = this.resumptionStrategy.processResponse(message);
        this.outerObserver.onResponse(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAttemptError(Throwable throwable) {
        Throwable localCancellationCause;
        Object object = this.lock;
        synchronized (object) {
            localCancellationCause = this.cancellationCause;
        }
        if (localCancellationCause != null) {
            this.innerAttemptFuture.setException(localCancellationCause);
        } else {
            this.innerAttemptFuture.setException(new ServerStreamingAttemptException(throwable, this.resumptionStrategy.canResume(), this.seenSuccessSinceLastError));
        }
    }

    private void onAttemptComplete() {
        this.innerAttemptFuture.set(null);
    }
}

