/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.cloud.bigquery.storage.v1.ConnectionWorker;
import com.google.cloud.bigquery.storage.v1.Singletons;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;

public class TelemetryMetrics {
    private static final Logger log = Logger.getLogger(TelemetryMetrics.class.getName());
    private final ConnectionWorker connectionWorker;
    private final boolean enableMetrics;
    private Meter writeMeter;
    private OpenTelemetryMetrics openTelemetryMetrics = new OpenTelemetryMetrics();
    private static final List<Long> METRICS_MILLISECONDS_LATENCY_BUCKETS = ImmutableList.of(Long.valueOf(0L), Long.valueOf(17L), Long.valueOf(38L), Long.valueOf(86L), Long.valueOf(195L), Long.valueOf(438L), Long.valueOf(985L), Long.valueOf(2217L), Long.valueOf(4988L), Long.valueOf(11223L), Long.valueOf(25251L), Long.valueOf(56815L), new Long[]{127834L, 287627L, 647160L});
    static AttributeKey<String> telemetryKeyTableId = AttributeKey.stringKey("table_id");
    static AttributeKey<String> telemetryKeyWriterId = AttributeKey.stringKey("writer_id");
    private static String dataflowPrefix = "dataflow:";
    static List<AttributeKey<String>> telemetryKeysTraceId = new ArrayList<AttributeKey<String>>(){
        {
            this.add(AttributeKey.stringKey("trace_field_1"));
            this.add(AttributeKey.stringKey("trace_field_2"));
            this.add(AttributeKey.stringKey("trace_field_3"));
        }
    };
    static AttributeKey<String> telemetryKeyErrorCode = AttributeKey.stringKey("error_code");
    static AttributeKey<String> telemetryKeyIsRetry = AttributeKey.stringKey("is_retry");
    private Attributes telemetryAttributes;

    private void setTraceIdAttributesPart(AttributesBuilder builder, String[] traceIdParts, int indexPartsToCheck, int indexTelemetryKeysToUse) {
        if (indexPartsToCheck < traceIdParts.length && !traceIdParts[indexPartsToCheck].isEmpty()) {
            builder.put(telemetryKeysTraceId.get(indexTelemetryKeysToUse), traceIdParts[indexPartsToCheck]);
        }
    }

    private void setTraceIdAttributes(AttributesBuilder builder, String traceId) {
        int indexDataflow;
        if (traceId != null && !traceId.isEmpty() && (indexDataflow = traceId.toLowerCase().indexOf(dataflowPrefix)) >= 0) {
            String[] traceIdParts = traceId.substring(indexDataflow + dataflowPrefix.length()).split(":", 8);
            this.setTraceIdAttributesPart(builder, traceIdParts, 0, 0);
            this.setTraceIdAttributesPart(builder, traceIdParts, 1, 1);
            this.setTraceIdAttributesPart(builder, traceIdParts, 2, 2);
        }
    }

    private Attributes buildOpenTelemetryAttributes(String tableName, String writerId, String traceId) {
        AttributesBuilder builder = Attributes.builder();
        if (!tableName.isEmpty()) {
            builder.put(telemetryKeyTableId, tableName);
        }
        builder.put(telemetryKeyWriterId, writerId);
        this.setTraceIdAttributes(builder, traceId);
        return builder.build();
    }

    private Attributes augmentAttributesWithErrorCode(Attributes attributes, String errorCode) {
        AttributesBuilder builder = attributes.toBuilder();
        if (errorCode != null && !errorCode.isEmpty()) {
            builder.put(telemetryKeyErrorCode, errorCode);
        }
        return builder.build();
    }

    private Attributes augmentAttributesWithRetry(Attributes attributes) {
        AttributesBuilder builder = attributes.toBuilder();
        builder.put(telemetryKeyIsRetry, "1");
        return builder.build();
    }

    @VisibleForTesting
    Attributes getTelemetryAttributes() {
        return this.telemetryAttributes;
    }

    private void registerOpenTelemetryMetrics(ConnectionWorker connectionWorker) {
        MeterProvider meterProvider = Singletons.getOpenTelemetry().getMeterProvider();
        this.writeMeter = meterProvider.meterBuilder("com.google.cloud.bigquery.storage.v1.write").setInstrumentationVersion(ConnectionWorker.class.getPackage().getImplementationVersion()).build();
        this.openTelemetryMetrics.instrumentAckedRequestCount = this.writeMeter.counterBuilder("append_requests_acked").setDescription("Counts number of requests acked by the server").build();
        this.openTelemetryMetrics.instrumentAckedRequestSize = this.writeMeter.counterBuilder("append_request_bytes_acked").setDescription("Counts byte size of requests acked by the server").build();
        this.openTelemetryMetrics.instrumentAckedRequestRows = this.writeMeter.counterBuilder("append_rows_acked").setDescription("Counts number of request rows acked by the server").build();
        this.writeMeter.gaugeBuilder("active_connection_count").ofLongs().setDescription("Reports number of active connections").buildWithCallback(measurement -> {
            int count = connectionWorker.hasActiveConnection() ? 1 : 0;
            measurement.record(count, this.getTelemetryAttributes());
        });
        this.writeMeter.gaugeBuilder("inflight_queue_length").ofLongs().setDescription("Reports length of inflight queue. This queue contains sent append requests waiting for response from the server.").buildWithCallback(measurement -> {
            int length = connectionWorker.getInflightRequestQueueLength();
            measurement.record(length, this.getTelemetryAttributes());
        });
        this.openTelemetryMetrics.instrumentNetworkResponseLatency = this.writeMeter.histogramBuilder("network_response_latency").ofLongs().setDescription("Reports time taken in milliseconds for a response to arrive once a message has been sent over the network.").setExplicitBucketBoundariesAdvice(TelemetryMetrics.METRICS_MILLISECONDS_LATENCY_BUCKETS).build();
        this.openTelemetryMetrics.instrumentConnectionStartCount = this.writeMeter.counterBuilder("connection_start_count").setDescription("Counts number of connection attempts made, regardless of whether these are initial or retry.").build();
        this.openTelemetryMetrics.instrumentConnectionEndCount = this.writeMeter.counterBuilder("connection_end_count").setDescription("Counts number of connection end events.").build();
    }

    TelemetryMetrics(ConnectionWorker connectionWorker, boolean enableMetrics, String tableName, String writerId, String traceId) {
        this.connectionWorker = connectionWorker;
        this.enableMetrics = enableMetrics;
        if (enableMetrics) {
            this.telemetryAttributes = this.buildOpenTelemetryAttributes(tableName, writerId, traceId);
            this.registerOpenTelemetryMetrics(connectionWorker);
        }
    }

    public void refreshOpenTelemetryTableNameAttributes(String tableName) {
        if (this.enableMetrics && !tableName.isEmpty() && !tableName.equals(this.getTelemetryAttributes().get(telemetryKeyTableId))) {
            AttributesBuilder builder = this.getTelemetryAttributes().toBuilder();
            builder.put(telemetryKeyTableId, tableName);
            this.telemetryAttributes = builder.build();
        }
    }

    public void recordConnectionStart() {
        if (this.enableMetrics) {
            this.openTelemetryMetrics.instrumentConnectionStartCount.add(1L, this.getTelemetryAttributes());
        }
    }

    public void recordConnectionStartWithRetry() {
        if (this.enableMetrics) {
            this.openTelemetryMetrics.instrumentConnectionStartCount.add(1L, this.augmentAttributesWithRetry(this.getTelemetryAttributes()));
        }
    }

    public void recordConnectionEnd(String errorCode) {
        if (this.enableMetrics) {
            this.openTelemetryMetrics.instrumentConnectionEndCount.add(1L, this.augmentAttributesWithErrorCode(this.getTelemetryAttributes(), errorCode));
        }
    }

    public void recordNetworkLatency(Duration latency) {
        if (this.enableMetrics) {
            this.openTelemetryMetrics.instrumentNetworkResponseLatency.record(latency.toMillis(), this.getTelemetryAttributes());
        }
    }

    public void recordResponse(long messageSize, long rowCount, String errorCode, boolean isRetry) {
        if (this.enableMetrics) {
            Attributes augmentedTelemetryAttributes = this.augmentAttributesWithErrorCode(this.getTelemetryAttributes(), errorCode);
            if (isRetry) {
                augmentedTelemetryAttributes = this.augmentAttributesWithRetry(augmentedTelemetryAttributes);
            }
            this.openTelemetryMetrics.instrumentAckedRequestCount.add(1L, augmentedTelemetryAttributes);
            this.openTelemetryMetrics.instrumentAckedRequestSize.add(messageSize, augmentedTelemetryAttributes);
            this.openTelemetryMetrics.instrumentAckedRequestRows.add(rowCount, augmentedTelemetryAttributes);
        }
    }

    private static final class OpenTelemetryMetrics {
        private LongCounter instrumentAckedRequestCount;
        private LongCounter instrumentAckedRequestSize;
        private LongCounter instrumentAckedRequestRows;
        private LongHistogram instrumentNetworkResponseLatency;
        private LongCounter instrumentConnectionStartCount;
        private LongCounter instrumentConnectionEndCount;

        private OpenTelemetryMetrics() {
        }
    }
}

