/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.StandardSqlTableType;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.AutoValue_StandardSQLTableType;
import com.google.cloud.bigquery.StandardSQLField;
import java.io.Serializable;
import java.util.List;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.Lists;

@AutoValue
public abstract class StandardSQLTableType
implements Serializable {
    public abstract List<StandardSQLField> getColumns();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_StandardSQLTableType.Builder();
    }

    public static Builder newBuilder(List<StandardSQLField> columns) {
        return StandardSQLTableType.newBuilder().setColumns(columns);
    }

    static StandardSQLTableType fromPb(StandardSqlTableType tableTypePb) {
        Builder builder = StandardSQLTableType.newBuilder();
        if (tableTypePb.getColumns() != null) {
            builder.setColumns(Lists.transform(tableTypePb.getColumns(), StandardSQLField.FROM_PB_FUNCTION));
        }
        return builder.build();
    }

    StandardSqlTableType toPb() {
        StandardSqlTableType tableType = new StandardSqlTableType();
        if (this.getColumns() != null) {
            tableType.setColumns(Lists.transform(this.getColumns(), StandardSQLField.TO_PB_FUNCTION));
        }
        return tableType;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setColumns(List<StandardSQLField> var1);

        public abstract StandardSQLTableType build();
    }
}

