/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.FormatOptions;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;

public final class GoogleSheetsOptions
extends FormatOptions {
    private static final long serialVersionUID = 1837436979033106123L;
    private final String range;
    private final Long skipLeadingRows;

    private GoogleSheetsOptions(Builder builder) {
        super("GOOGLE_SHEETS");
        this.skipLeadingRows = builder.skipLeadingRows;
        this.range = builder.range;
    }

    public String getRange() {
        return this.range;
    }

    public Long getSkipLeadingRows() {
        return this.skipLeadingRows;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.getType()).add("skipLeadingRows", this.skipLeadingRows).add("range", this.range).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getType(), this.skipLeadingRows);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof GoogleSheetsOptions && Objects.equals(this.toPb(), ((GoogleSheetsOptions)obj).toPb());
    }

    com.google.api.services.bigquery.model.GoogleSheetsOptions toPb() {
        com.google.api.services.bigquery.model.GoogleSheetsOptions options = new com.google.api.services.bigquery.model.GoogleSheetsOptions();
        options.setSkipLeadingRows(this.skipLeadingRows);
        options.setRange(this.range);
        return options;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static GoogleSheetsOptions fromPb(com.google.api.services.bigquery.model.GoogleSheetsOptions options) {
        Builder builder = GoogleSheetsOptions.newBuilder();
        if (options.getSkipLeadingRows() != null) {
            builder.setSkipLeadingRows(options.getSkipLeadingRows());
        }
        if (options.getRange() != null) {
            builder.setRange(options.getRange());
        }
        return builder.build();
    }

    public static final class Builder {
        private String range;
        private Long skipLeadingRows;

        private Builder() {
        }

        private Builder(GoogleSheetsOptions options) {
            this.skipLeadingRows = options.skipLeadingRows;
            this.range = options.range;
        }

        public Builder setRange(String range) {
            this.range = range;
            return this;
        }

        public Builder setSkipLeadingRows(long skipLeadingRows) {
            this.skipLeadingRows = skipLeadingRows;
            return this;
        }

        public GoogleSheetsOptions build() {
            return new GoogleSheetsOptions(this);
        }
    }
}

