/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.BigtableColumnFamily;
import com.google.cloud.bigquery.FormatOptions;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.Lists;

public class BigtableOptions
extends FormatOptions {
    private static final long serialVersionUID = 1L;
    private final Boolean ignoreUnspecifiedColumnFamilies;
    private final Boolean readRowkeyAsString;
    private final List<BigtableColumnFamily> columnFamilies;

    public Boolean getIgnoreUnspecifiedColumnFamilies() {
        return this.ignoreUnspecifiedColumnFamilies;
    }

    public Boolean getReadRowkeyAsString() {
        return this.readRowkeyAsString;
    }

    public List<BigtableColumnFamily> getColumnFamilies() {
        return this.columnFamilies;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    BigtableOptions(Builder builder) {
        super("BIGTABLE");
        this.ignoreUnspecifiedColumnFamilies = builder.ignoreUnspecifiedColumnFamilies;
        this.readRowkeyAsString = builder.readRowkeyAsString;
        this.columnFamilies = builder.columnFamilies;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("ignoreUnspecifiedColumnFamilies", this.ignoreUnspecifiedColumnFamilies).add("readRowkeyAsString", this.readRowkeyAsString).add("columnFamilies", this.columnFamilies).toString();
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.ignoreUnspecifiedColumnFamilies, this.readRowkeyAsString, this.columnFamilies);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(BigtableOptions.class)) {
            return false;
        }
        BigtableOptions other = (BigtableOptions)obj;
        return this.ignoreUnspecifiedColumnFamilies == other.ignoreUnspecifiedColumnFamilies && this.readRowkeyAsString == other.readRowkeyAsString && Objects.equals(this.columnFamilies, other.columnFamilies);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static BigtableOptions fromPb(com.google.api.services.bigquery.model.BigtableOptions options) {
        Builder builder = BigtableOptions.newBuilder();
        builder.setIgnoreUnspecifiedColumnFamilies(options.getIgnoreUnspecifiedColumnFamilies());
        builder.setReadRowkeyAsString(options.getReadRowkeyAsString());
        if (options.getColumnFamilies() != null) {
            builder.setColumnFamilies(Lists.transform(options.getColumnFamilies(), BigtableColumnFamily.FROM_PB_FUNCTION));
        }
        return builder.build();
    }

    com.google.api.services.bigquery.model.BigtableOptions toPb() {
        com.google.api.services.bigquery.model.BigtableOptions options = new com.google.api.services.bigquery.model.BigtableOptions().setIgnoreUnspecifiedColumnFamilies(this.ignoreUnspecifiedColumnFamilies).setReadRowkeyAsString(this.readRowkeyAsString);
        if (this.columnFamilies != null) {
            options.setColumnFamilies(Lists.transform(this.columnFamilies, BigtableColumnFamily.TO_PB_FUNCTION));
        }
        return options;
    }

    public static final class Builder {
        private Boolean ignoreUnspecifiedColumnFamilies;
        private Boolean readRowkeyAsString;
        private List<BigtableColumnFamily> columnFamilies;

        private Builder() {
        }

        private Builder(BigtableOptions bigtableOptions) {
            this.ignoreUnspecifiedColumnFamilies = bigtableOptions.ignoreUnspecifiedColumnFamilies;
            this.readRowkeyAsString = bigtableOptions.readRowkeyAsString;
            this.columnFamilies = bigtableOptions.columnFamilies;
        }

        public Builder setIgnoreUnspecifiedColumnFamilies(Boolean ignoreUnspecifiedColumnFamilies) {
            this.ignoreUnspecifiedColumnFamilies = ignoreUnspecifiedColumnFamilies;
            return this;
        }

        public Builder setReadRowkeyAsString(Boolean readRowkeyAsString) {
            this.readRowkeyAsString = readRowkeyAsString;
            return this;
        }

        public Builder setColumnFamilies(List<BigtableColumnFamily> columnFamilies) {
            this.columnFamilies = columnFamilies;
            return this;
        }

        public BigtableOptions build() {
            return new BigtableOptions(this);
        }
    }
}

