/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.BetaApi;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryFactory;
import com.google.cloud.bigquery.BigQueryImpl;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.spi.BigQueryRpcFactory;
import com.google.cloud.bigquery.spi.v2.HttpBigQueryRpc;
import com.google.cloud.http.HttpTransportOptions;
import io.opentelemetry.api.trace.Tracer;
import java.util.Set;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableSet;

public class BigQueryOptions
extends ServiceOptions<BigQuery, BigQueryOptions> {
    private static final String API_SHORT_NAME = "BigQuery";
    private static final int DEFAULT_READ_API_TIME_OUT = 60000;
    private static final String BIGQUERY_SCOPE = "https://www.googleapis.com/auth/bigquery";
    private static final Set<String> SCOPES = ImmutableSet.of("https://www.googleapis.com/auth/bigquery");
    private static final long serialVersionUID = -2437598817433266048L;
    private final String location;
    private boolean setThrowNotFound;
    private boolean useInt64Timestamps;
    private QueryJobConfiguration.JobCreationMode defaultJobCreationMode = QueryJobConfiguration.JobCreationMode.JOB_CREATION_MODE_UNSPECIFIED;
    private boolean enableOpenTelemetryTracing;
    private Tracer openTelemetryTracer;

    private BigQueryOptions(Builder builder) {
        super(BigQueryFactory.class, BigQueryRpcFactory.class, builder, new BigQueryDefaults());
        this.location = builder.location;
        this.useInt64Timestamps = builder.useInt64Timestamps;
        this.enableOpenTelemetryTracing = builder.enableOpenTelemetryTracing;
        this.openTelemetryTracer = builder.openTelemetryTracer;
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().setReadTimeout(60000).build();
    }

    @Override
    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected HttpBigQueryRpc getBigQueryRpcV2() {
        return (HttpBigQueryRpc)this.getRpc();
    }

    public String getLocation() {
        return this.location;
    }

    @Deprecated
    public boolean isQueryPreviewEnabled() {
        return false;
    }

    public void setThrowNotFound(boolean setThrowNotFound) {
        this.setThrowNotFound = setThrowNotFound;
    }

    public void setUseInt64Timestamps(boolean useInt64Timestamps) {
        this.useInt64Timestamps = useInt64Timestamps;
    }

    @Deprecated
    public void setQueryPreviewEnabled(String queryPreviewEnabled) {
    }

    public void setDefaultJobCreationMode(QueryJobConfiguration.JobCreationMode jobCreationMode) {
        this.defaultJobCreationMode = jobCreationMode;
    }

    public boolean getThrowNotFound() {
        return this.setThrowNotFound;
    }

    public boolean getUseInt64Timestamps() {
        return this.useInt64Timestamps;
    }

    public QueryJobConfiguration.JobCreationMode getDefaultJobCreationMode() {
        return this.defaultJobCreationMode;
    }

    @BetaApi(value="Span names and attributes are subject to change without notice")
    public boolean isOpenTelemetryTracingEnabled() {
        return this.enableOpenTelemetryTracing;
    }

    @BetaApi(value="Span names and attributes are subject to change without notice")
    public Tracer getOpenTelemetryTracer() {
        return this.openTelemetryTracer;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigQueryOptions)) {
            return false;
        }
        BigQueryOptions other = (BigQueryOptions)obj;
        return this.baseEquals(other);
    }

    public static BigQueryOptions getDefaultInstance() {
        return BigQueryOptions.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceOptions.Builder<BigQuery, BigQueryOptions, Builder> {
        private String location;
        private boolean useInt64Timestamps;
        private boolean enableOpenTelemetryTracing;
        private Tracer openTelemetryTracer;

        private Builder() {
        }

        private Builder(BigQueryOptions options) {
            super(options);
        }

        @Override
        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for BigQuery.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setUseInt64Timestamps(boolean useInt64Timestamps) {
            this.useInt64Timestamps = useInt64Timestamps;
            return this;
        }

        @BetaApi
        public Builder setEnableOpenTelemetryTracing(boolean enableOpenTelemetryTracing) {
            this.enableOpenTelemetryTracing = enableOpenTelemetryTracing;
            return this;
        }

        @BetaApi
        public Builder setOpenTelemetryTracer(Tracer tracer) {
            this.openTelemetryTracer = tracer;
            return this;
        }

        public BigQueryOptions build() {
            return new BigQueryOptions(this);
        }
    }

    private static class BigQueryDefaults
    implements ServiceDefaults<BigQuery, BigQueryOptions> {
        private static final long serialVersionUID = -4551722608999107711L;

        private BigQueryDefaults() {
        }

        public BigQueryFactory getDefaultServiceFactory() {
            return DefaultBigQueryFactory.INSTANCE;
        }

        public BigQueryRpcFactory getDefaultRpcFactory() {
            return DefaultBigQueryRpcFactory.INSTANCE;
        }

        @Override
        public TransportOptions getDefaultTransportOptions() {
            return BigQueryOptions.getDefaultHttpTransportOptions();
        }
    }

    public static class DefaultBigQueryRpcFactory
    implements BigQueryRpcFactory {
        private static final BigQueryRpcFactory INSTANCE = new DefaultBigQueryRpcFactory();

        @Override
        public ServiceRpc create(BigQueryOptions options) {
            return new HttpBigQueryRpc(options);
        }
    }

    public static class DefaultBigQueryFactory
    implements BigQueryFactory {
        private static final BigQueryFactory INSTANCE = new DefaultBigQueryFactory();

        @Override
        public BigQuery create(BigQueryOptions options) {
            return new BigQueryImpl(options);
        }
    }
}

