/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.mtls;

import com.google.api.client.json.JsonParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.SecurityUtils;
import com.google.auth.mtls.CertificateSourceUnavailableException;
import com.google.auth.mtls.ContextAwareMetadataJson;
import com.google.auth.mtls.MtlsProvider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;

public class SecureConnectProvider
implements MtlsProvider {
    private static final String DEFAULT_CONTEXT_AWARE_METADATA_PATH = System.getProperty("user.home") + "/.secureConnect/context_aware_metadata.json";
    private String metadataPath;
    private ProcessProvider processProvider;

    @VisibleForTesting
    SecureConnectProvider(ProcessProvider processProvider, String metadataPath) {
        this.processProvider = processProvider;
        this.metadataPath = metadataPath;
    }

    public SecureConnectProvider() {
        this(new DefaultProcessProvider(), DEFAULT_CONTEXT_AWARE_METADATA_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyStore getKeyStore() throws CertificateSourceUnavailableException, IOException {
        try (FileInputStream stream = new FileInputStream(this.metadataPath);){
            KeyStore keyStore = SecureConnectProvider.getKeyStore(stream, this.processProvider);
            return keyStore;
        }
        catch (InterruptedException e) {
            throw new IOException("SecureConnect: Interrupted executing certificate provider command", e);
        }
        catch (GeneralSecurityException e) {
            throw new CertificateSourceUnavailableException("SecureConnect encountered GeneralSecurityException:", e);
        }
        catch (FileNotFoundException exception) {
            throw new CertificateSourceUnavailableException("SecureConnect metadata does not exist.");
        }
    }

    @Override
    public boolean isAvailable() throws IOException {
        try {
            this.getKeyStore();
        }
        catch (CertificateSourceUnavailableException e) {
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static KeyStore getKeyStore(InputStream metadata, ProcessProvider processProvider) throws IOException, InterruptedException, GeneralSecurityException {
        Process process = processProvider.createProcess(metadata);
        int exitCode = SecureConnectProvider.runCertificateProviderCommand(process, 1000L);
        if (exitCode != 0) {
            throw new IOException("SecureConnect: Cert provider command failed with exit code: " + exitCode);
        }
        return SecurityUtils.createMtlsKeyStore(process.getInputStream());
    }

    @VisibleForTesting
    static ImmutableList<String> extractCertificateProviderCommand(InputStream contextAwareMetadata) throws IOException {
        JsonParser parser = new GsonFactory().createJsonParser(contextAwareMetadata);
        ContextAwareMetadataJson json = parser.parse(ContextAwareMetadataJson.class);
        return json.getCommands();
    }

    @VisibleForTesting
    static int runCertificateProviderCommand(Process commandProcess, long timeoutMilliseconds) throws IOException, InterruptedException {
        boolean terminated = commandProcess.waitFor(timeoutMilliseconds, TimeUnit.MILLISECONDS);
        if (!terminated) {
            commandProcess.destroy();
            throw new IOException("SecureConnect: Cert provider command timed out");
        }
        return commandProcess.exitValue();
    }

    static class DefaultProcessProvider
    implements ProcessProvider {
        DefaultProcessProvider() {
        }

        @Override
        public Process createProcess(InputStream metadata) throws IOException {
            if (metadata == null) {
                throw new IOException("Error creating Process: metadata is null");
            }
            ImmutableList<String> command = SecureConnectProvider.extractCertificateProviderCommand(metadata);
            return new ProcessBuilder(command).start();
        }
    }

    static interface ProcessProvider {
        public Process createProcess(InputStream var1) throws IOException;
    }
}

