/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchEntry;
import com.google.api.gax.batching.BatchResource;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherStats;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingException;
import com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Stopwatch;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.Futures;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.MoreExecutors;

@InternalApi(value="For google-cloud-java client use only")
public class BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>
implements Batcher<ElementT, ElementResultT> {
    private static final Logger LOG = Logger.getLogger(BatcherImpl.class.getName());
    private final BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor;
    private final UnaryCallable<RequestT, ResponseT> unaryCallable;
    private final RequestT prototype;
    private final BatchingSettings batchingSettings;
    private final BatcherReference currentBatcherReference;
    private Batch<ElementT, ElementResultT, RequestT, ResponseT> currentOpenBatch;
    private final ConcurrentMap<Batch<ElementT, ElementResultT, RequestT, ResponseT>, Boolean> outstandingBatches = new ConcurrentHashMap<Batch<ElementT, ElementResultT, RequestT, ResponseT>, Boolean>();
    private final Object flushLock = new Object();
    private final Object elementLock = new Object();
    private final Future<?> scheduledFuture;
    private SettableApiFuture<Void> closeFuture;
    private final BatcherStats batcherStats = new BatcherStats();
    private final FlowController flowController;
    private final ApiCallContext callContext;
    private final long elementThreshold;
    private final long bytesThreshold;

    @Deprecated
    public BatcherImpl(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor, UnaryCallable<RequestT, ResponseT> unaryCallable, RequestT prototype, BatchingSettings batchingSettings, ScheduledExecutorService executor) {
        this(batchingDescriptor, unaryCallable, prototype, batchingSettings, executor, null, null);
    }

    @Deprecated
    public BatcherImpl(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor, UnaryCallable<RequestT, ResponseT> unaryCallable, RequestT prototype, BatchingSettings batchingSettings, ScheduledExecutorService executor, @Nullable FlowController flowController) {
        this(batchingDescriptor, unaryCallable, prototype, batchingSettings, executor, flowController, null);
    }

    public BatcherImpl(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor, UnaryCallable<RequestT, ResponseT> unaryCallable, RequestT prototype, BatchingSettings batchingSettings, ScheduledExecutorService executor, @Nullable FlowController flowController, @Nullable ApiCallContext callContext) {
        this.batchingDescriptor = Preconditions.checkNotNull(batchingDescriptor, "batching descriptor cannot be null");
        this.unaryCallable = Preconditions.checkNotNull(unaryCallable, "callable cannot be null");
        this.prototype = Preconditions.checkNotNull(prototype, "request prototype cannot be null");
        this.batchingSettings = Preconditions.checkNotNull(batchingSettings, "batching setting cannot be null");
        Preconditions.checkNotNull(executor, "executor cannot be null");
        if (flowController == null) {
            flowController = new FlowController(batchingSettings.getFlowControlSettings());
        }
        if (flowController.getLimitExceededBehavior() != FlowController.LimitExceededBehavior.Ignore) {
            Preconditions.checkArgument(flowController.getMaxElementCountLimit() == null || batchingSettings.getElementCountThreshold() == null || flowController.getMaxElementCountLimit() >= batchingSettings.getElementCountThreshold(), "If throttling and batching on element count are enabled, FlowController#maxOutstandingElementCount must be greater or equal to elementCountThreshold");
            Preconditions.checkArgument(flowController.getMaxRequestBytesLimit() == null || batchingSettings.getRequestByteThreshold() == null || flowController.getMaxRequestBytesLimit() >= batchingSettings.getRequestByteThreshold(), "If throttling and batching on request bytes are enabled, FlowController#maxOutstandingRequestBytes must be greater or equal to requestByteThreshold");
        }
        this.flowController = flowController;
        this.currentOpenBatch = new Batch(prototype, batchingDescriptor, this.batcherStats);
        if (batchingSettings.getDelayThresholdDuration() != null) {
            long delay = batchingSettings.getDelayThresholdDuration().toMillis();
            PushCurrentBatchRunnable runnable = new PushCurrentBatchRunnable(this);
            this.scheduledFuture = executor.scheduleWithFixedDelay(runnable, delay, delay, TimeUnit.MILLISECONDS);
        } else {
            this.scheduledFuture = Futures.immediateCancelledFuture();
        }
        this.currentBatcherReference = new BatcherReference(this);
        this.callContext = callContext;
        Long elementCountThreshold = batchingSettings.getElementCountThreshold();
        this.elementThreshold = elementCountThreshold == null ? 0L : elementCountThreshold;
        Long requestByteThreshold = batchingSettings.getRequestByteThreshold();
        this.bytesThreshold = requestByteThreshold == null ? 0L : requestByteThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<ElementResultT> add(ElementT element) {
        Preconditions.checkState(this.closeFuture == null, "Cannot add elements on a closed batcher");
        BatchResource newResource = this.batchingDescriptor.createResource(element);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.flowController.reserve(newResource.getElementCount(), newResource.getByteCount());
        }
        catch (FlowController.FlowControlException e) {
            throw FlowController.FlowControlRuntimeException.fromFlowControlException(e);
        }
        long throttledTimeMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        SettableApiFuture result = SettableApiFuture.create();
        Object object = this.elementLock;
        synchronized (object) {
            if (((Batch)this.currentOpenBatch).resource.add(newResource).shouldFlush(this.elementThreshold, this.bytesThreshold)) {
                this.sendOutstanding();
            }
            this.currentOpenBatch.add(element, newResource, result, throttledTimeMs);
        }
        return result;
    }

    @Override
    public void flush() throws InterruptedException {
        this.sendOutstanding();
        this.awaitAllOutstandingBatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOutstanding() {
        ApiFuture<Object> batchResponse;
        Batch accumulatedBatch;
        Object object = this.elementLock;
        synchronized (object) {
            if (this.currentOpenBatch.isEmpty()) {
                return;
            }
            accumulatedBatch = this.currentOpenBatch;
            this.currentOpenBatch = new Batch(this.prototype, this.batchingDescriptor, this.batcherStats);
        }
        ApiCallContext callContextWithOption = null;
        if (this.callContext != null) {
            callContextWithOption = this.callContext.withOption(THROTTLED_TIME_KEY, accumulatedBatch.totalThrottledTimeMs);
        }
        try {
            batchResponse = this.unaryCallable.futureCall(accumulatedBatch.builder.build(), callContextWithOption);
        }
        catch (Exception ex) {
            batchResponse = ApiFutures.immediateFailedFuture(ex);
        }
        accumulatedBatch.setResponseFuture(batchResponse);
        this.outstandingBatches.put(accumulatedBatch, Boolean.TRUE);
        ApiFutures.addCallback(batchResponse, new ApiFutureCallback<ResponseT>(){

            @Override
            public void onSuccess(ResponseT response) {
                try {
                    BatcherImpl.this.flowController.release(accumulatedBatch.resource.getElementCount(), accumulatedBatch.resource.getByteCount());
                    accumulatedBatch.onBatchSuccess(response);
                }
                finally {
                    BatcherImpl.this.onBatchCompletion(accumulatedBatch);
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                try {
                    BatcherImpl.this.flowController.release(accumulatedBatch.resource.getElementCount(), accumulatedBatch.resource.getByteCount());
                    accumulatedBatch.onBatchFailure(throwable);
                }
                finally {
                    BatcherImpl.this.onBatchCompletion(accumulatedBatch);
                }
            }
        }, MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBatchCompletion(Batch<ElementT, ElementResultT, RequestT, ResponseT> batch) {
        boolean shouldClose = false;
        Object object = this.flushLock;
        synchronized (object) {
            this.outstandingBatches.remove(batch);
            if (this.outstandingBatches.isEmpty()) {
                this.flushLock.notifyAll();
                shouldClose = this.closeFuture != null;
            }
        }
        if (shouldClose) {
            BatchingException overallError = this.batcherStats.asException();
            if (overallError != null) {
                this.closeFuture.setException(overallError);
            } else {
                this.closeFuture.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAllOutstandingBatches() throws InterruptedException {
        while (!this.outstandingBatches.isEmpty()) {
            Object object = this.flushLock;
            synchronized (object) {
                if (this.outstandingBatches.isEmpty()) {
                    break;
                }
                this.flushLock.wait();
            }
        }
    }

    @Override
    public void cancelOutstanding() {
        for (Batch batch : this.outstandingBatches.keySet()) {
            batch.cancel();
        }
    }

    @Override
    public void close() throws InterruptedException {
        try {
            this.close(null);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Unexpected timeout exception when trying to close the batcher without a timeout", e);
        }
    }

    @Override
    public void close(@Nullable Duration timeout) throws InterruptedException, TimeoutException {
        try {
            if (timeout != null) {
                this.closeAsync().get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.closeAsync().get();
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BatchingException) {
                BatchingException cause = (BatchingException)e.getCause();
                throw new BatchingException(cause.getMessage());
            }
            throw new IllegalStateException("unexpected error closing the batcher", e.getCause());
        }
        catch (TimeoutException e) {
            StringJoiner batchesStr = new StringJoiner(",");
            for (Batch batch : this.outstandingBatches.keySet()) {
                batchesStr.add(batch.toString());
            }
            String msg = "Timed out trying to close batcher after " + timeout + ".";
            msg = msg + " Batch request prototype: " + this.prototype + ".";
            msg = msg + " Outstanding batches: " + batchesStr;
            throw new TimeoutException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Void> closeAsync() {
        boolean closeImmediately;
        if (this.closeFuture != null) {
            return this.closeFuture;
        }
        this.sendOutstanding();
        Object object = this.flushLock;
        synchronized (object) {
            this.closeFuture = SettableApiFuture.create();
            closeImmediately = this.outstandingBatches.isEmpty();
        }
        this.scheduledFuture.cancel(false);
        this.currentBatcherReference.closed = true;
        this.currentBatcherReference.clear();
        if (closeImmediately) {
            this.finishClose();
        }
        return this.closeFuture;
    }

    private void finishClose() {
        BatchingException batchingException = this.batcherStats.asException();
        if (batchingException != null) {
            this.closeFuture.setException(batchingException);
        } else {
            this.closeFuture.set(null);
        }
    }

    @InternalApi(value="For google-cloud-java client use only")
    public FlowController getFlowController() {
        return this.flowController;
    }

    private static class Batch<ElementT, ElementResultT, RequestT, ResponseT> {
        private final BatchingRequestBuilder<ElementT, RequestT> builder;
        private final List<BatchEntry<ElementT, ElementResultT>> entries;
        private final BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> descriptor;
        private final BatcherStats batcherStats;
        private long totalThrottledTimeMs = 0L;
        private BatchResource resource;
        private volatile ApiFuture<ResponseT> responseFuture;

        private Batch(RequestT prototype, BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> descriptor, BatcherStats batcherStats) {
            this.descriptor = descriptor;
            this.builder = descriptor.newRequestBuilder(prototype);
            this.entries = new ArrayList<BatchEntry<ElementT, ElementResultT>>();
            this.batcherStats = batcherStats;
            this.resource = descriptor.createEmptyResource();
        }

        void add(ElementT element, BatchResource newResource, SettableApiFuture<ElementResultT> result, long throttledTimeMs) {
            this.builder.add(element);
            this.entries.add(BatchEntry.create(element, result));
            this.resource = this.resource.add(newResource);
            this.totalThrottledTimeMs += throttledTimeMs;
        }

        void setResponseFuture(@Nonnull ApiFuture<ResponseT> responseFuture) {
            Preconditions.checkNotNull(responseFuture);
            this.responseFuture = responseFuture;
        }

        void cancel() {
            if (this.responseFuture != null) {
                this.responseFuture.cancel(true);
            }
        }

        void onBatchSuccess(ResponseT response) {
            try {
                this.descriptor.splitResponse(response, this.entries);
                this.batcherStats.recordBatchElementsCompletion(this.entries);
            }
            catch (Exception ex) {
                this.onBatchFailure(ex);
            }
        }

        void onBatchFailure(Throwable throwable) {
            try {
                this.descriptor.splitException(throwable, this.entries);
            }
            catch (Exception ex) {
                for (BatchEntry<ElementT, ElementResultT> batchEntry : this.entries) {
                    batchEntry.getResultFuture().setException(ex);
                }
            }
            this.batcherStats.recordBatchFailure(throwable);
        }

        boolean isEmpty() {
            return this.resource.getElementCount() == 0L;
        }

        public String toString() {
            StringJoiner elementsStr = new StringJoiner(",");
            for (BatchEntry<ElementT, ElementResultT> entry : this.entries) {
                elementsStr.add(Optional.ofNullable(entry.getElement()).map(Object::toString).orElse("null"));
            }
            return MoreObjects.toStringHelper(this).add("responseFuture", this.responseFuture).add("elements", elementsStr).toString();
        }
    }

    @VisibleForTesting
    static class PushCurrentBatchRunnable<ElementT, ElementResultT, RequestT, ResponseT>
    implements Runnable {
        private Future<?> scheduledFuture;
        private final WeakReference<BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>> batcherReferent;

        PushCurrentBatchRunnable(BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT> batcher) {
            this.batcherReferent = new WeakReference<BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>>(batcher);
        }

        @Override
        public void run() {
            BatcherImpl batcher = (BatcherImpl)this.batcherReferent.get();
            if (batcher == null) {
                this.scheduledFuture.cancel(true);
            } else {
                batcher.sendOutstanding();
            }
        }

        void setScheduledFuture(Future<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }
    }

    @VisibleForTesting
    static final class BatcherReference
    extends WeakReference<BatcherImpl> {
        private static final ReferenceQueue<BatcherImpl> refQueue = new ReferenceQueue();
        private static final ConcurrentMap<BatcherReference, BatcherReference> refs = new ConcurrentHashMap<BatcherReference, BatcherReference>();
        private static final String ALLOCATION_SITE_PROPERTY_NAME = "com.google.api.gax.batching.Batcher.enableAllocationTracking";
        private static final boolean ENABLE_ALLOCATION_TRACKING = Boolean.parseBoolean(System.getProperty("com.google.api.gax.batching.Batcher.enableAllocationTracking", "true"));
        private static final RuntimeException missingCallSite = BatcherReference.missingCallSite();
        private final Reference<RuntimeException> allocationSite = new SoftReference<RuntimeException>(ENABLE_ALLOCATION_TRACKING ? new RuntimeException("Batcher allocation site") : missingCallSite);
        private volatile boolean closed;

        BatcherReference(BatcherImpl referent) {
            super(referent, refQueue);
            refs.put(this, this);
            BatcherReference.cleanQueue();
        }

        @Override
        public void clear() {
            this.clearInternal();
            BatcherReference.cleanQueue();
        }

        private void clearInternal() {
            super.clear();
            refs.remove(this);
            this.allocationSite.clear();
        }

        @VisibleForTesting
        static int cleanQueue() {
            BatcherReference ref;
            int orphanedBatchers = 0;
            while ((ref = (BatcherReference)refQueue.poll()) != null) {
                RuntimeException maybeAllocationSite = ref.allocationSite.get();
                ref.clearInternal();
                if (ref.closed) continue;
                ++orphanedBatchers;
                if (!LOG.isLoggable(Level.SEVERE)) continue;
                String message = "Batcher was not closed properly!!! Make sure to call close().";
                LOG.log(Level.SEVERE, message, maybeAllocationSite);
            }
            return orphanedBatchers;
        }

        private static RuntimeException missingCallSite() {
            RuntimeException e = new RuntimeException("Batcher allocation site not recorded.  Set -Dcom.google.api.gax.batching.Batcher.enableAllocationTracking=true to enable it");
            e.setStackTrace(new StackTraceElement[0]);
            return e;
        }
    }
}

