/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Validation {
    public static final String OWNER_REGEX = "^[A-Za-z](((?![.][.])[A-Za-z0-9._-])*[A-Za-z0-9._-])?$";
    public static final String REPO_REGEX = "^[A-Za-z](((?![.][.])[A-Za-z0-9._-])*[A-Za-z0-9._-])?$";
    public static final String HASH_REGEX = "^[0-9a-fA-F]{16,64}$";
    public static final String REF_NAME_REGEX = "^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$";
    public static final String REF_NAME_OR_HASH_REGEX = "^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$";
    public static final Pattern REPO_PATTERN = Pattern.compile("^[A-Za-z](((?![.][.])[A-Za-z0-9._-])*[A-Za-z0-9._-])?$");
    public static final Pattern OWNER_PATTERN = Pattern.compile("^[A-Za-z](((?![.][.])[A-Za-z0-9._-])*[A-Za-z0-9._-])?$");
    public static final Pattern HASH_PATTERN = Pattern.compile("^[0-9a-fA-F]{16,64}$");
    public static final Pattern REF_NAME_PATTERN = Pattern.compile("^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$");
    public static final Pattern REF_NAME_OR_HASH_PATTERN = Pattern.compile("^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$");
    public static final Collection<String> INVALID_REPO_IDS = Collections.unmodifiableList(Arrays.asList("config", "contents", "trees"));
    private static final String REPO_RULE = "start with a letter, followed by letters, digits, ._- characters and not be equal to 'config', 'contents', 'trees'";
    private static final String OWNER_RULE = "start with a letter, followed by letters, digits, ._- characters and not be equal to 'config', 'contents', 'trees'";
    private static final String HASH_RULE = "consist of the hex representation of 8-32 bytes";
    private static final String REF_RULE = "start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..";
    public static final String REPO_MESSAGE = "Repository name must start with a letter, followed by letters, digits, ._- characters and not be equal to 'config', 'contents', 'trees'";
    public static final String OWNER_MESSAGE = "Owner name must start with a letter, followed by letters, digits, ._- characters and not be equal to 'config', 'contents', 'trees'";
    public static final String HASH_MESSAGE = "Hash must consist of the hex representation of 8-32 bytes";
    public static final String REF_NAME_MESSAGE = "Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..";
    public static final String REF_NAME_OR_HASH_MESSAGE = "Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes";

    private Validation() {
    }

    public static boolean isValidOwner(String repoOwner) {
        Objects.requireNonNull(repoOwner, "repo must not be null");
        Matcher matcher = OWNER_PATTERN.matcher(repoOwner);
        return matcher.matches() && !INVALID_REPO_IDS.contains(repoOwner);
    }

    public static String validateOwner(String owner) {
        if (Validation.isValidOwner(owner)) {
            return owner;
        }
        throw new IllegalArgumentException("Owner name must start with a letter, followed by letters, digits, ._- characters and not be equal to 'config', 'contents', 'trees' - but was: " + owner);
    }

    public static boolean isValidRepo(String repo) {
        Objects.requireNonNull(repo, "repo must not be null");
        Matcher matcher = REPO_PATTERN.matcher(repo);
        return matcher.matches() && !INVALID_REPO_IDS.contains(repo);
    }

    public static String validateRepo(String repo) {
        if (Validation.isValidRepo(repo)) {
            return repo;
        }
        throw new IllegalArgumentException("Repository name must start with a letter, followed by letters, digits, ._- characters and not be equal to 'config', 'contents', 'trees' - but was: " + repo);
    }

    public static boolean isValidReferenceName(String referenceName) {
        Objects.requireNonNull(referenceName, "referenceName must not be null");
        Matcher matcher = REF_NAME_PATTERN.matcher(referenceName);
        return matcher.matches();
    }

    public static boolean isValidHash(String hash) {
        Objects.requireNonNull(hash, "hash must not be null");
        Matcher matcher = HASH_PATTERN.matcher(hash);
        return matcher.matches();
    }

    public static boolean isValidReferenceNameOrHash(String ref) {
        Objects.requireNonNull(ref, "reference (name or hash) must not be null");
        Matcher matcher = REF_NAME_OR_HASH_PATTERN.matcher(ref);
        return matcher.matches();
    }

    public static String validateReferenceName(String referenceName) {
        if (Validation.isValidReferenceName(referenceName)) {
            return referenceName;
        }
        throw new IllegalArgumentException("Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + referenceName);
    }

    public static String validateHash(String referenceName) {
        if (Validation.isValidHash(referenceName)) {
            return referenceName;
        }
        throw new IllegalArgumentException("Hash must consist of the hex representation of 8-32 bytes - but was: " + referenceName);
    }

    public static String validateReferenceNameOrHash(String ref) {
        if (Validation.isValidReferenceNameOrHash(ref)) {
            return ref;
        }
        throw new IllegalArgumentException("Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes - but was: " + ref);
    }
}

