/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableTransplant;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Transplant", properties={@SchemaProperty(name="hashesToTransplant", uniqueItems=true)})
@JsonSerialize(as=ImmutableTransplant.class)
@JsonDeserialize(as=ImmutableTransplant.class)
@Value.Immutable(prehash=true)
public interface Transplant {
    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<String> getHashesToTransplant();

    @Value.Check
    default public void checkHashes() {
        List<String> hashes = this.getHashesToTransplant();
        if (hashes != null) {
            for (String hash : hashes) {
                Validation.validateHash(hash);
            }
        }
    }
}

