/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieTableOperations;
import org.apache.iceberg.nessie.NessieUtil;
import org.apache.iceberg.nessie.TableReference;
import org.apache.iceberg.nessie.UpdateableReference;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.Tasks;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Contents;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableDelete;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.ImmutablePut;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieCatalog
extends BaseMetastoreCatalog
implements AutoCloseable,
SupportsNamespaces,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(NessieCatalog.class);
    private static final Joiner SLASH = Joiner.on("/");
    private NessieClient client;
    private String warehouseLocation;
    private Configuration config;
    private UpdateableReference reference;
    private String name;
    private FileIO fileIO;
    private Map<String, String> catalogOptions;

    @Override
    public void initialize(String inputName, Map<String, String> options) {
        this.catalogOptions = ImmutableMap.copyOf(options);
        String fileIOImpl = options.get("io-impl");
        this.fileIO = fileIOImpl == null ? new HadoopFileIO(this.config) : CatalogUtil.loadFileIO(fileIOImpl, options, this.config);
        this.name = inputName == null ? "nessie" : inputName;
        Function<String, String> removePrefix = x -> x.replace("nessie.", "");
        this.client = NessieClient.builder().fromConfig(x -> (String)options.get(removePrefix.apply((String)x))).build();
        this.warehouseLocation = options.get("warehouse");
        if (this.warehouseLocation == null) {
            logger.warn("Catalog creation for inputName={} and options {} failed, because parameter 'warehouse' is not set, Nessie can't store data.", (Object)inputName, options);
            throw new IllegalStateException("Parameter 'warehouse' not set, Nessie can't store data.");
        }
        String requestedRef = options.get(removePrefix.apply("nessie.ref"));
        this.reference = this.loadReference(requestedRef);
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        TableReference pti = TableReference.parse(tableIdentifier);
        UpdateableReference newReference = this.reference;
        if (pti.reference() != null) {
            newReference = this.loadReference(pti.reference());
        }
        return new NessieTableOperations(NessieUtil.toKey(pti.tableIdentifier()), newReference, this.client, this.fileIO, this.catalogOptions);
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier table) {
        if (table.hasNamespace()) {
            return SLASH.join(this.warehouseLocation, table.namespace().toString(), table.name());
        }
        return SLASH.join(this.warehouseLocation, table.name(), new Object[0]);
    }

    @Override
    public List<TableIdentifier> listTables(Namespace namespace) {
        return this.tableStream(namespace).collect(Collectors.toList());
    }

    @Override
    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        this.reference.checkMutable();
        IcebergTable existingTable = this.table(identifier);
        if (existingTable == null) {
            return false;
        }
        ImmutableOperations contents = ImmutableOperations.builder().addOperations((Operation)ImmutableDelete.builder().key(NessieUtil.toKey(identifier)).build()).commitMeta(NessieUtil.buildCommitMetadata(String.format("delete table %s", identifier), this.catalogOptions)).build();
        boolean threw = true;
        try {
            Tasks.foreach(contents).retry(5).stopRetryOn(NessieNotFoundException.class).throwFailureWhenFinished().onFailure((c, exception) -> this.refresh()).run(c -> {
                Branch branch = this.client.getTreeApi().commitMultipleOperations(this.reference.getAsBranch().getName(), this.reference.getHash(), (Operations)c);
                this.reference.updateReference(branch);
            }, BaseNessieClientServerException.class);
            threw = false;
        }
        catch (NessieConflictException e) {
            logger.error("Cannot drop table: failed after retry (update ref and retry)", (Throwable)e);
        }
        catch (NessieNotFoundException e) {
            logger.error("Cannot drop table: ref is no longer valid.", (Throwable)e);
        }
        catch (BaseNessieClientServerException e) {
            logger.error("Cannot drop table: unknown error", (Throwable)e);
        }
        return !threw;
    }

    @Override
    public void renameTable(TableIdentifier from, TableIdentifier toOriginal) {
        this.reference.checkMutable();
        TableIdentifier to = NessieUtil.removeCatalogName(toOriginal, this.name());
        IcebergTable existingFromTable = this.table(from);
        if (existingFromTable == null) {
            throw new NoSuchTableException("table %s doesn't exists", from.name());
        }
        IcebergTable existingToTable = this.table(to);
        if (existingToTable != null) {
            throw new AlreadyExistsException("table %s already exists", to.name());
        }
        ImmutableOperations contents = ImmutableOperations.builder().addOperations(ImmutablePut.builder().key(NessieUtil.toKey(to)).contents(existingFromTable).build(), ImmutableDelete.builder().key(NessieUtil.toKey(from)).build()).commitMeta(NessieUtil.buildCommitMetadata("iceberg rename table", this.catalogOptions)).build();
        try {
            Tasks.foreach(contents).retry(5).stopRetryOn(NessieNotFoundException.class).throwFailureWhenFinished().onFailure((c, exception) -> this.refresh()).run(c -> {
                Branch branch = this.client.getTreeApi().commitMultipleOperations(this.reference.getAsBranch().getName(), this.reference.getHash(), (Operations)c);
                this.reference.updateReference(branch);
            }, BaseNessieClientServerException.class);
        }
        catch (NessieNotFoundException e) {
            throw new RuntimeException("Failed to drop table as ref is no longer valid.", e);
        }
        catch (BaseNessieClientServerException e) {
            throw new CommitFailedException(e, "Failed to rename table: the current reference is not up to date.", new Object[0]);
        }
        catch (HttpClientException ex) {
            throw new CommitStateUnknownException(ex);
        }
    }

    @Override
    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
    }

    @Override
    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        return this.tableStream(namespace).map(TableIdentifier::namespace).filter(n -> !n.isEmpty()).distinct().collect(Collectors.toList());
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        return ImmutableMap.of();
    }

    @Override
    public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
        return false;
    }

    @Override
    public boolean setProperties(Namespace namespace, Map<String, String> properties) throws NoSuchNamespaceException {
        throw new UnsupportedOperationException("Cannot set namespace properties " + namespace + " : setProperties is not supported");
    }

    @Override
    public boolean removeProperties(Namespace namespace, Set<String> properties) throws NoSuchNamespaceException {
        throw new UnsupportedOperationException("Cannot remove properties " + namespace + " : removeProperties is not supported");
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public Configuration getConf() {
        return this.config;
    }

    TreeApi getTreeApi() {
        return this.client.getTreeApi();
    }

    public void refresh() throws NessieNotFoundException {
        this.reference.refresh();
    }

    public String currentHash() {
        return this.reference.getHash();
    }

    String currentRefName() {
        return this.reference.getName();
    }

    private IcebergTable table(TableIdentifier tableIdentifier) {
        try {
            Contents table = this.client.getContentsApi().getContents(NessieUtil.toKey(tableIdentifier), this.reference.getName(), this.reference.getHash());
            return table.unwrap(IcebergTable.class).orElse(null);
        }
        catch (NessieNotFoundException e) {
            return null;
        }
    }

    private UpdateableReference loadReference(String requestedRef) {
        try {
            Reference ref = requestedRef == null ? this.client.getTreeApi().getDefaultBranch() : this.client.getTreeApi().getReferenceByName(requestedRef);
            return new UpdateableReference(ref, this.client.getTreeApi());
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef != null) {
                throw new IllegalArgumentException(String.format("Nessie ref '%s' does not exist. This ref must exist before creating a NessieCatalog.", requestedRef), ex);
            }
            throw new IllegalArgumentException(String.format("Nessie does not have an existing default branch.Either configure an alternative ref via %s or create the default branch on the server.", "nessie.ref"), ex);
        }
    }

    private Stream<TableIdentifier> tableStream(Namespace namespace) {
        try {
            return this.client.getTreeApi().getEntries(this.reference.getName(), EntriesParams.builder().hashOnRef(this.reference.getHash()).build()).getEntries().stream().filter(NessieUtil.namespacePredicate(namespace)).map(NessieUtil::toIdentifier);
        }
        catch (NessieNotFoundException ex) {
            throw new NoSuchNamespaceException(ex, "Unable to list tables due to missing ref. %s", this.reference.getName());
        }
    }
}

